/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.ExceptionMarshallerHandler;
import com.eucalyptus.ws.server.DuplicatePipelineException;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.eucalyptus.ws.server.MessageStatistics;
import com.eucalyptus.ws.server.NoAcceptingPipelineException;
import com.eucalyptus.ws.server.Pipelines;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutException;

public class NioServerHandler
extends SimpleChannelUpstreamHandler {
    private static Logger LOG = Logger.getLogger(NioServerHandler.class);
    private AtomicReference<FilteredPipeline> pipeline = new AtomicReference();

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Callable<Long> stat = MessageStatistics.startUpstream(ctx.getChannel(), this);
        try {
            if (this.pipeline.get() == null) {
                this.lookupPipeline(ctx, e);
            } else if (e.getMessage() instanceof MappingHttpRequest) {
                MappingHttpRequest httpRequest = (MappingHttpRequest)((Object)e.getMessage());
                if (NioServerHandler.isPersistentConnection(httpRequest)) {
                    ChannelHandler p;
                    this.pipeline.set(null);
                    while ((p = ctx.getPipeline().getLast()) != this) {
                        ctx.getPipeline().remove(p);
                    }
                    this.lookupPipeline(ctx, e);
                } else {
                    LOG.warn((Object)"Hard close the socket on an attempt to do a second request.");
                    ctx.getChannel().close();
                    return;
                }
            }
            stat.call();
            ctx.sendUpstream((ChannelEvent)e);
        }
        catch (Exception ex) {
            LOG.trace((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            stat.call();
            this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.NOT_FOUND, ex);
        }
    }

    public static boolean isPersistentConnection(MappingHttpRequest httpRequest) {
        return httpRequest.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_1) && !"close".equalsIgnoreCase(httpRequest.getHeader("Connection")) || httpRequest.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && "keep-alive".equalsIgnoreCase(httpRequest.getHeader("Connection"));
    }

    private void lookupPipeline(ChannelHandlerContext ctx, MessageEvent e) throws DuplicatePipelineException, NoAcceptingPipelineException {
        try {
            FilteredPipeline filteredPipeline;
            HttpRequest request = (HttpRequest)e.getMessage();
            if (Logs.isExtrrreeeme() && request instanceof MappingHttpMessage) {
                Logs.extreme().trace((Object)((MappingHttpMessage)request).logMessage());
            }
            if (this.pipeline.compareAndSet(null, filteredPipeline = Pipelines.find(request))) {
                Ats ats;
                this.pipeline.get().unroll(ctx.getPipeline());
                if (filteredPipeline instanceof FilteredPipeline.InternalPipeline) {
                    Handlers.addInternalSystemHandlers(ctx.getPipeline());
                }
                Handlers.addComponentHandlers((ats = Ats.inClassHierarchy(filteredPipeline)).has(ComponentPart.class) ? ats.get(ComponentPart.class).value() : null, ctx.getPipeline());
                Handlers.addSystemHandlers(ctx.getPipeline());
            }
        }
        catch (DuplicatePipelineException e1) {
            LOG.error((Object)("This is a BUG: " + e1), (Throwable)e1);
            throw e1;
        }
        catch (NoAcceptingPipelineException e2) {
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel ch = e.getChannel();
        Throwable cause = e.getCause();
        Logs.extreme().error((Object)cause, cause);
        try {
            if (cause instanceof ReadTimeoutException) {
                this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.REQUEST_TIMEOUT, cause);
            } else if (cause instanceof WriteTimeoutException) {
                ctx.sendUpstream((ChannelEvent)e);
                ctx.getChannel().close();
            } else if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.BAD_REQUEST, cause);
            } else if (cause instanceof IllegalArgumentException) {
                this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.BAD_REQUEST, cause);
            } else if (cause instanceof LoginException) {
                this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.FORBIDDEN, cause);
            } else if (e.getCause() instanceof WebServicesException) {
                WebServicesException webEx = (WebServicesException)e.getCause();
                if (webEx.getStatus().getCode() != 403) {
                    LOG.error((Object)("Internal Error: " + cause.getMessage()));
                }
                Logs.extreme().error((Object)cause, cause);
                this.sendError(ctx, (ChannelEvent)e, webEx.getStatus(), cause);
            } else {
                this.sendError(ctx, (ChannelEvent)e, HttpResponseStatus.BAD_REQUEST, cause);
            }
        }
        finally {
            try {
                if (ch != null) {
                    Contexts.clear(Contexts.lookup(ch));
                }
            }
            catch (Exception exception) {}
        }
    }

    private void sendError(ChannelHandlerContext ctx, ChannelEvent event, HttpResponseStatus restStatus, Throwable t) {
        Logs.exhaust().error((Object)t, t);
        HttpResponseStatus status = restStatus;
        ChannelBuffer buffer = null;
        Map<Object, Object> headers = Collections.emptyMap();
        ExceptionMarshallerHandler exceptionMarshallerHandler = (ExceptionMarshallerHandler)ctx.getPipeline().get(ExceptionMarshallerHandler.class);
        if (exceptionMarshallerHandler != null) {
            try {
                ExceptionMarshallerHandler.ExceptionResponse exceptionResponse = exceptionMarshallerHandler.marshallException(event, status, t);
                status = exceptionResponse.getStatus();
                buffer = exceptionResponse.getContent();
                headers = exceptionResponse.getHeaders();
            }
            catch (Exception e) {
                Logs.exhaust().error((Object)e, (Throwable)e);
            }
        }
        if (buffer == null) {
            buffer = ChannelBuffers.copiedBuffer((String)Binding.createRestFault(status.toString(), t.getMessage(), Logs.isExtrrreeeme() ? Exceptions.string(t) : t.getMessage()), (String)"UTF-8");
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setHeader("Content-Length", (Object)String.valueOf(buffer.readableBytes()));
        for (Map.Entry<Object, Object> headerEntry : headers.entrySet()) {
            response.setHeader((String)headerEntry.getKey(), headerEntry.getValue());
        }
        response.setContent(buffer);
        ChannelFuture writeFuture = Channels.future((Channel)ctx.getChannel());
        writeFuture.addListener(ChannelFutureListener.CLOSE);
        response.addHeader("Connection", (Object)"close");
        if (ctx.getChannel().isConnected()) {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)writeFuture, (Object)response);
        }
    }
}

