/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.context.Contexts;
import com.eucalyptus.records.Logs;
import com.eucalyptus.ws.StackConfiguration;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Callables;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;

public class MessageStatistics {
    private static Logger LOG = Logger.getLogger(MessageStatistics.class);
    private static final Map<Integer, RequestRecord> requestStatistics = Maps.newConcurrentMap();

    public static final void startRequest(final Channel channel) {
        if (StackConfiguration.STATISTICS.booleanValue()) {
            RequestRecord record = new RequestRecord();
            requestStatistics.put(channel.getId(), record);
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    LOG.info(requestStatistics.remove(channel.getId()));
                }
            });
        }
    }

    public static final <T extends ChannelHandler> Callable<Long> startUpstream(Channel channel, T handler) {
        Integer correlationId = channel.getId();
        if (StackConfiguration.STATISTICS.booleanValue() && requestStatistics.containsKey(correlationId)) {
            RequestRecord record = requestStatistics.get(correlationId);
            if (record.type == null) {
                try {
                    record.type = Contexts.lookup(channel).getRequest().getClass().getSimpleName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HandlerRecord handlerRecord = new HandlerRecord(handler.getClass());
            record.handlerUpstreamStats.put(handler.getClass(), handlerRecord);
            return handlerRecord;
        }
        return Callables.returning((Object)0L);
    }

    public static final <T extends ChannelHandler> Callable<Long> startDownstream(Channel channel, T handler) {
        Integer correlationId = channel.getId();
        if (StackConfiguration.STATISTICS.booleanValue() && requestStatistics.containsKey(correlationId)) {
            RequestRecord record = requestStatistics.get(correlationId);
            HandlerRecord handlerRecord = new HandlerRecord(handler.getClass());
            record.handlerDownstreamStats.put(handler.getClass(), handlerRecord);
            return handlerRecord;
        }
        return Callables.returning((Object)0L);
    }

    private static class RequestRecord {
        private final Map<Class, HandlerRecord> handlerUpstreamStats = Maps.newHashMap();
        private final Map<Class, HandlerRecord> handlerDownstreamStats = Maps.newHashMap();
        String type;
        private final long creationTime = System.currentTimeMillis();

        private RequestRecord() {
        }

        public Collection<HandlerRecord> values() {
            return this.handlerUpstreamStats.values();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            String typeName = this.type == null ? "unknown" : this.type;
            builder.append(typeName).append(" ").append(Joiner.on((String)("\n" + typeName)).join(this.handlerUpstreamStats.values()));
            builder.append(typeName).append(" ").append(Joiner.on((String)("\n" + typeName)).join(this.handlerDownstreamStats.values()));
            builder.append(typeName).append(" ").append(System.currentTimeMillis() - this.creationTime).append(" msec");
            return builder.toString();
        }
    }

    private static class HandlerRecord
    implements Callable<Long> {
        private final String handlerClassName;
        private final Long startTime = System.currentTimeMillis();
        private Long endTime;

        private HandlerRecord(Class<? extends ChannelHandler> class1) {
            this.handlerClassName = class1.toString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            Long time = (this.endTime == null ? System.currentTimeMillis() : this.endTime) - this.startTime;
            builder.append(" ");
            builder.append(this.handlerClassName).append(": ").append(time).append(" msec");
            return builder.toString();
        }

        @Override
        public Long call() throws Exception {
            Logs.extreme().debug((Object)("HandlerRecord:" + this.handlerClassName + " " + ((this.endTime == null ? (this.endTime = Long.valueOf(System.currentTimeMillis())) : this.endTime) - this.startTime) + "msec"));
            return this.endTime;
        }
    }
}

