/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.server.FilteredPipeline;
import com.google.common.base.Charsets;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ComponentPart(value=Empyrean.class)
public class LegacyHBPipeline
extends FilteredPipeline {
    private static Logger LOG = Logger.getLogger(LegacyHBPipeline.class);

    @Override
    public boolean checkAccepts(HttpRequest message) {
        return message.getUri().endsWith("/services/Heartbeat");
    }

    @Override
    public String getName() {
        return "heartbeat";
    }

    @Override
    public ChannelPipeline addHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("hb-get-handler", (ChannelHandler)new SimpleHeartbeatHandler());
        return pipeline;
    }

    public static class SimpleHeartbeatHandler
    extends SimpleChannelHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            if (e.getMessage() instanceof MappingHttpRequest) {
                MappingHttpRequest request = (MappingHttpRequest)((Object)e.getMessage());
                HttpMethod method = request.getMethod();
                if (HttpMethod.GET.equals((Object)method)) {
                    try {
                        DefaultHttpResponse response = new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.OK);
                        String resp = "";
                        for (Component c : Components.list()) {
                            boolean enabledLocally = Topology.isEnabledLocally(c.getComponentId().getClass());
                            resp = resp + String.format("name=%-20.20s enabled=%-10.10s local=%-10.10s initialized=%-10.10s\n", c.getName(), enabledLocally, c.hasLocalService(), c.getComponentId().isAvailableLocally());
                        }
                        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((byte[])resp.getBytes(Charsets.UTF_8));
                        response.setContent(buf);
                        response.addHeader("Content-Length", (Object)String.valueOf(buf.readableBytes()));
                        response.addHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
                        ChannelFuture writeFuture = ctx.getChannel().write((Object)response);
                        writeFuture.addListener(ChannelFutureListener.CLOSE);
                    }
                    finally {
                        Contexts.clear(request.getCorrelationId());
                    }
                } else {
                    try {
                        ctx.getChannel().write((Object)new DefaultHttpResponse(request.getProtocolVersion(), HttpResponseStatus.METHOD_NOT_ALLOWED)).addListener(ChannelFutureListener.CLOSE);
                    }
                    finally {
                        Contexts.clear(request.getCorrelationId());
                    }
                }
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            e.getFuture().addListener(ChannelFutureListener.CLOSE);
            super.exceptionCaught(ctx, e);
        }
    }
}

