/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.server;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Filterable;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.dns.DomainNames;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public abstract class FilteredPipeline
implements HasName<FilteredPipeline>,
Filterable<HttpRequest> {
    private static Logger LOG = Logger.getLogger(FilteredPipeline.class);
    private static final Splitter hostSplitter = Splitter.on((char)':').limit(2);
    private final Supplier<Set<Name>> nameSupplier = Suppliers.memoizeWithExpiration((Supplier)new NamesSupplier(this.getClass()), (long)15L, (TimeUnit)TimeUnit.SECONDS);

    @Override
    public abstract String getName();

    public void unroll(ChannelPipeline pipeline) {
        try {
            this.addHandlers(pipeline);
            if (Logs.isExtrrreeeme()) {
                for (Map.Entry e : pipeline.toMap().entrySet()) {
                    EventRecord.here(this.getClass(), EventType.PIPELINE_HANDLER, (String)e.getKey(), ((ChannelHandler)e.getValue()).getClass().getSimpleName()).trace();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error unrolling pipeline: " + this.getName()));
            ChannelFuture close = pipeline.getChannel().close();
            close.awaitUninterruptibly();
            LOG.error((Object)"Forced pipeline to close due to exception: ", (Throwable)e);
        }
    }

    public abstract ChannelPipeline addHandlers(ChannelPipeline var1);

    @Override
    public abstract boolean checkAccepts(HttpRequest var1);

    @Override
    public final int compareTo(FilteredPipeline o) {
        return this.getName().compareTo(this.getName());
    }

    protected boolean resolvesByHost(@Nullable String host) {
        boolean match = false;
        if (host != null) {
            try {
                Name hostName = Name.fromString((String)((String)Iterables.getFirst((Iterable)hostSplitter.split((CharSequence)host), (Object)host)));
                match = ((Set)this.nameSupplier.get()).contains(DomainNames.absolute(hostName));
            }
            catch (TextParseException e) {
                Logs.exhaust().error((Object)("Invalid host: " + host), (Throwable)e);
            }
        }
        return match;
    }

    @Override
    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        return result;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilteredPipeline other = (FilteredPipeline)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public String toString() {
        return String.format("FilteredPipeline:name=%s:hashCode=%s:class=%s", this.getName(), this.hashCode(), this.getClass().getSimpleName());
    }

    private static class NamesSupplier
    implements Supplier<Set<Name>> {
        private final Class<?> componentClass;

        private NamesSupplier(Class<?> componentClass) {
            this.componentClass = componentClass;
        }

        public Set<Name> get() {
            ComponentPart part2 = Ats.inClassHierarchy(this.componentClass).get(ComponentPart.class);
            Class<? extends ComponentId> component = part2 == null ? null : part2.value();
            ImmutableSet names = component != null ? ImmutableSet.of((Object)DomainNames.internalSubdomain(component), (Object)DomainNames.externalSubdomain(component)) : Collections.emptySet();
            return names;
        }
    }

    protected static abstract class InternalPipeline
    extends FilteredPipeline {
        private final ComponentId componentId;

        InternalPipeline(ComponentId componentId) {
            this.componentId = componentId;
        }

        private ComponentId getComponentId() {
            return this.componentId;
        }
    }
}

