/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.protocol;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ChannelHandler.Sharable
public class SoapHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(SoapHandler.class);

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage message = (MappingHttpMessage)((Object)event.getMessage());
            SOAPEnvelope env = message.getSoapEnvelope();
            if (!env.hasFault()) {
                message.setOmMessage(env.getBody().getFirstElement());
            } else {
                SOAPFault fault;
                SOAPHeader header = env.getHeader();
                String action = "ProblemAction";
                String relatesTo = "RelatesTo";
                if (header != null) {
                    ArrayList headers = Lists.newArrayList((Iterator)header.examineAllHeaderBlocks());
                    for (SOAPHeaderBlock headerBlock : headers) {
                        if (action.equals(headerBlock.getLocalName())) {
                            action = headerBlock.getText();
                            continue;
                        }
                        if (!relatesTo.equals(headerBlock.getLocalName())) continue;
                        relatesTo = headerBlock.getText();
                    }
                }
                if ((fault = env.getBody().getFault()) != null) {
                    String faultReason = "";
                    Iterator children = fault.getChildElements();
                    while (children.hasNext()) {
                        OMElement child = (OMElement)children.next();
                        faultReason = faultReason + child.getText();
                    }
                    String faultCode = fault.getCode().getText();
                    faultReason = faultReason.replaceAll(faultCode, "");
                    String faultDetail = fault.getDetail().getText();
                    throw new EucalyptusRemoteFault(action, relatesTo, faultCode, faultReason, faultDetail, SoapHandler.getStatus(message));
                }
            }
        }
    }

    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage httpMessage = (MappingHttpMessage)((Object)event.getMessage());
            if (httpMessage.getMessage() instanceof EucalyptusErrorMessageType) {
                EucalyptusErrorMessageType errMsg = (EucalyptusErrorMessageType)httpMessage.getMessage();
                httpMessage.setSoapEnvelope(Binding.createFault(errMsg.getSource(), errMsg.getMessage(), errMsg.getStatusMessage()));
                if (httpMessage instanceof MappingHttpResponse) {
                    ((MappingHttpResponse)httpMessage).setStatus(HttpResponseStatus.BAD_REQUEST);
                }
            } else if (httpMessage.getMessage() instanceof ExceptionResponseType) {
                ExceptionResponseType errMsg = (ExceptionResponseType)httpMessage.getMessage();
                String createFaultDetails = Logs.isExtrrreeeme() ? Exceptions.string(errMsg.getException()) : errMsg.getException().getMessage();
                httpMessage.setSoapEnvelope(Binding.createFault(errMsg.getRequestType(), errMsg.getMessage(), createFaultDetails));
                if (httpMessage instanceof MappingHttpResponse) {
                    ((MappingHttpResponse)httpMessage).setStatus(errMsg.getHttpStatus());
                }
            } else {
                SOAPFactory factory = HoldMe.getOMSOAP11Factory();
                SOAPEnvelope soapEnvelope = factory.createSOAPEnvelope(factory.createOMNamespace("http://schemas.xmlsoap.org/soap/envelope/", ""));
                factory.createSOAPHeader(soapEnvelope);
                factory.createSOAPBody(soapEnvelope);
                httpMessage.setSoapEnvelope(soapEnvelope);
                httpMessage.getSoapEnvelope().getBody().addChild((OMNode)httpMessage.getOmMessage());
            }
        }
    }

    @Nullable
    private static HttpResponseStatus getStatus(MappingHttpMessage message) {
        return message instanceof MappingHttpResponse ? ((MappingHttpResponse)message).getStatus() : null;
    }
}

