/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.protocol;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.binding.HttpEmbedded;
import com.eucalyptus.binding.HttpEmbeddeds;
import com.eucalyptus.binding.HttpParameterMapping;
import com.eucalyptus.binding.HttpParameterMappings;
import com.eucalyptus.binding.HttpValue;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.handlers.RestfulMarshallingHandler;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseData;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusData;
import edu.ucsb.eucalyptus.msgs.EucalyptusMessage;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class BaseQueryBinding<T extends Enum<T>>
extends RestfulMarshallingHandler {
    private static Logger LOG = Logger.getLogger(BaseQueryBinding.class);
    private final UnknownParameterStrategy unknownParameterStrategy;
    private final T operationParam;
    private final List<T> altOperationParams;
    private final List<T> possibleParams;

    @SafeVarargs
    public BaseQueryBinding(String namespacePattern, String defaultVersion, T operationParam, T ... alternativeOperationParam) {
        this(namespacePattern, defaultVersion, UnknownParameterStrategy.IGNORE, (Enum)operationParam, (Enum[])alternativeOperationParam);
    }

    @SafeVarargs
    public BaseQueryBinding(String namespacePattern, String defaultVersion, UnknownParameterStrategy unknownParameterStrategy, T operationParam, T ... alternativeOperationParam) {
        super(namespacePattern, defaultVersion);
        this.unknownParameterStrategy = unknownParameterStrategy;
        this.operationParam = operationParam;
        this.altOperationParams = Arrays.asList(alternativeOperationParam);
        this.possibleParams = Arrays.asList(((Enum)operationParam).getDeclaringClass().getEnumConstants());
    }

    private String extractOperationName(MappingHttpRequest httpRequest) {
        if (httpRequest.getParameters().containsKey(((Enum)this.operationParam).toString())) {
            return httpRequest.getParameters().get(((Enum)this.operationParam).toString());
        }
        for (Enum param : this.altOperationParams) {
            if (!httpRequest.getParameters().containsKey(param.toString())) continue;
            return httpRequest.getParameters().get(param.toString());
        }
        LOG.error((Object)("Failed to find operation parameter an " + Lists.asList(this.operationParam, (Object[])this.altOperationParams.toArray()).toString() + " in HTTP request: " + (Object)((Object)httpRequest)));
        return null;
    }

    @Override
    public Object bind(MappingHttpRequest httpRequest) throws BindingException {
        BaseMessage eucaMsg;
        Map<String, String> fieldMap;
        Binding currentBinding;
        String operationName = this.extractOperationName(httpRequest);
        String operationNameType = operationName + "Type";
        for (Enum op : this.possibleParams) {
            httpRequest.getParameters().remove(op.name());
        }
        Map<String, String> params = httpRequest.getParameters();
        try {
            Class targetType;
            currentBinding = this.getBindingWithElementClass(operationName);
            Class clazz = targetType = currentBinding == null ? null : currentBinding.getElementClass(operationName);
            if (currentBinding == null) {
                currentBinding = this.getBindingWithElementClass(operationNameType);
                Class clazz2 = targetType = currentBinding == null ? null : currentBinding.getElementClass(operationNameType);
            }
            if (currentBinding == null) {
                try {
                    targetType = this.getBinding().getElementClass(operationName);
                }
                catch (BindingException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            fieldMap = this.buildFieldMap(targetType);
            eucaMsg = (BaseMessage)targetType.newInstance();
        }
        catch (BindingException e) {
            LOG.debug((Object)("Failed to construct message of type: " + operationName), (Throwable)e);
            LOG.error((Object)e, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            throw new BindingException("Failed to construct message of type " + operationName, e);
        }
        List<String> failedMappings = this.populateObject((GroovyObject)eucaMsg, fieldMap, params);
        if (!(!this.isStrictBinding() || failedMappings.isEmpty() && params.isEmpty())) {
            StringBuilder errMsg = new StringBuilder("Failed to bind the following fields:\n");
            for (String string : failedMappings) {
                errMsg.append(string).append('\n');
            }
            for (Map.Entry entry : params.entrySet()) {
                errMsg.append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append('\n');
            }
            throw new BindingException(errMsg.toString());
        }
        this.validateBinding(currentBinding, operationName, params, eucaMsg);
        return eucaMsg;
    }

    protected Binding getBindingWithElementClass(String operationName) throws BindingException {
        Binding binding = null;
        if (this.getBinding().hasElementClass(operationName)) {
            binding = this.getBinding();
        } else if (this.getDefaultBinding().hasElementClass(operationName)) {
            binding = this.getDefaultBinding();
        } else if (BindingManager.getDefaultBinding().hasElementClass(operationName)) {
            binding = BindingManager.getDefaultBinding();
        }
        return binding;
    }

    protected void validateBinding(Binding currentBinding, String operationName, Map<String, String> params, BaseMessage eucaMsg) throws BindingException {
        try {
            currentBinding.toOM(eucaMsg, this.getNamespace());
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Falling back to default (unvalidated) binding for: " + operationName + " with params=" + params));
            LOG.error((Object)("Failed to build a valid message: " + e.getMessage()), (Throwable)e);
            try {
                BindingManager.getDefaultBinding().toOM(eucaMsg, BindingManager.defaultBindingNamespace());
            }
            catch (RuntimeException ex) {
                throw new BindingException("Default binding failed to build a valid message: " + ex.getMessage(), ex);
            }
        }
    }

    private boolean isStrictBinding() {
        String strategy = StackConfiguration.UNKNOWN_PARAMETER_HANDLING;
        return "error".equalsIgnoreCase(strategy) || !"ignore".equalsIgnoreCase(strategy) && this.unknownParameterStrategy == UnknownParameterStrategy.ERROR;
    }

    private static Field getRecursiveField(Class<?> clazz, String fieldName) throws Exception {
        Exception e = null;
        while (!BaseMessage.class.equals(clazz) && !Object.class.equals(clazz)) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (Exception e1) {
                e = e1;
                clazz = clazz.getSuperclass();
            }
        }
        if (e == null) {
            throw new Exception("Class not supported: " + clazz);
        }
        throw e;
    }

    private List<String> populateObject(GroovyObject obj, Map<String, String> paramFieldMap, Map<String, String> params) {
        ArrayList<String> failedMappings = new ArrayList<String>();
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            try {
                if (!BaseQueryBinding.getRecursiveField(obj.getClass(), e.getValue()).getType().equals(ArrayList.class)) continue;
                failedMappings.addAll(this.populateObjectList(obj, e, params, params.size()));
            }
            catch (Exception e1) {
                LOG.debug((Object)"Failed mapping : ", (Throwable)e1);
                failedMappings.add(e.getKey());
            }
        }
        for (Map.Entry<String, String> e : paramFieldMap.entrySet()) {
            Field field = null;
            Class<?> declaredType = null;
            try {
                field = BaseQueryBinding.getRecursiveField(obj.getClass(), e.getValue());
                declaredType = field.getType();
            }
            catch (Exception e2) {
                LOG.debug((Object)("Field not found: " + e.getValue()), (Throwable)e2);
            }
            if (!(!params.containsKey(e.getKey()) || declaredType != null && EucalyptusData.class.isAssignableFrom(declaredType) || this.populateObjectField(obj, e, params))) {
                failedMappings.add(e.getKey());
                continue;
            }
            if (declaredType != null && EucalyptusData.class.isAssignableFrom(declaredType)) {
                try {
                    Map<String, String> fieldMap = this.buildFieldMap(declaredType);
                    Object newInstance = declaredType.newInstance();
                    Map<Object, Object> subParams = Maps.newHashMap();
                    HttpEmbedded httpEmbedded = null;
                    if (field != null && (field.isAnnotationPresent(HttpEmbedded.class) || field.isAnnotationPresent(HttpEmbeddeds.class))) {
                        httpEmbedded = this.getHttpEmbeddedAnnotation(field);
                    }
                    if (httpEmbedded != null && !httpEmbedded.multiple()) {
                        subParams = params;
                    } else {
                        for (String item : Sets.newHashSet(params.keySet())) {
                            if (!item.startsWith(e.getKey())) continue;
                            params.get(item);
                            subParams.put(item.replace(e.getKey() + ".", ""), params.remove(item));
                        }
                    }
                    if (!subParams.isEmpty()) {
                        this.populateObject((GroovyObject)newInstance, fieldMap, subParams);
                        obj.setProperty(e.getValue(), newInstance);
                        continue;
                    }
                    if (!params.containsKey(e.getKey())) continue;
                    obj.setProperty(e.getValue(), newInstance);
                }
                catch (Exception e1) {
                    LOG.debug((Object)"Error binding object", (Throwable)e1);
                }
                continue;
            }
            failedMappings.remove(e.getKey());
        }
        return failedMappings;
    }

    private boolean populateObjectField(GroovyObject obj, final Map.Entry<String, String> paramFieldPair, final Map<String, String> params) {
        try {
            Class<?> declaredType = BaseQueryBinding.getRecursiveField(obj.getClass(), paramFieldPair.getValue()).getType();
            Object value = this.convertToType(new Supplier<String>(){

                public String get() {
                    return (String)params.remove(paramFieldPair.getKey());
                }
            }, declaredType);
            if (value != null) {
                obj.setProperty(paramFieldPair.getValue(), value);
            }
            return !params.containsKey(paramFieldPair.getKey());
        }
        catch (Exception e1) {
            return false;
        }
    }

    private Object convertToType(Supplier<String> value, Class<?> targetType) throws Exception {
        if (targetType.equals(String.class)) {
            return value.get();
        }
        if (targetType.getName().equals("int")) {
            return Integer.parseInt((String)value.get());
        }
        if (targetType.equals(Integer.class)) {
            return Integer.valueOf((String)value.get());
        }
        if (targetType.getName().equals("boolean")) {
            return Boolean.parseBoolean((String)value.get());
        }
        if (targetType.equals(Boolean.class)) {
            return Boolean.valueOf((String)value.get());
        }
        if (targetType.getName().equals("long")) {
            return Long.parseLong((String)value.get());
        }
        if (targetType.equals(Long.class)) {
            return Long.valueOf((String)value.get());
        }
        if (targetType.getName().equals("double")) {
            return Double.parseDouble((String)value.get());
        }
        if (targetType.equals(Double.class)) {
            return Double.valueOf((String)value.get());
        }
        if (targetType.equals(Date.class)) {
            return Timestamps.parseIso8601Timestamp((String)value.get());
        }
        return null;
    }

    private List<String> populateObjectList(GroovyObject obj, Map.Entry<String, String> paramFieldPair, Map<String, String> params, int paramSize) {
        ArrayList<String> failedMappings = new ArrayList<String>();
        try {
            Field declaredField = BaseQueryBinding.getRecursiveField(obj.getClass(), paramFieldPair.getValue());
            ArrayList theList = (ArrayList)obj.getProperty(paramFieldPair.getValue());
            Class genericType = (Class)((ParameterizedType)declaredField.getGenericType()).getActualTypeArguments()[0];
            if (String.class.equals((Object)genericType) || Boolean.class.equals((Object)genericType) || Integer.class.equals((Object)genericType) || Long.class.equals((Object)genericType) || Double.class.equals((Object)genericType) || Date.class.equals((Object)genericType)) {
                if (params.containsKey(paramFieldPair.getKey())) {
                    theList.add(this.convertToType((Supplier<String>)Suppliers.ofInstance((Object)params.remove(paramFieldPair.getKey())), genericType));
                } else {
                    ArrayList keys = Lists.newArrayList(params.keySet());
                    Pattern paramPattern = Pattern.compile(Pattern.quote(paramFieldPair.getKey()) + "\\.([0-9]{1,7})");
                    TreeMap<String, Object> indexToValueMap = new TreeMap<String, Object>((Comparator<String>)Ordering.natural().onResultOf((Function)FunctionToInteger.INSTANCE));
                    for (String k : keys) {
                        Matcher matcher = paramPattern.matcher(k);
                        if (!matcher.matches()) continue;
                        indexToValueMap.put(matcher.group(1), this.convertToType((Supplier<String>)Suppliers.ofInstance((Object)params.remove(k)), genericType));
                    }
                    theList.addAll(indexToValueMap.values());
                }
            } else if (declaredField.isAnnotationPresent(HttpEmbedded.class) || declaredField.isAnnotationPresent(HttpEmbeddeds.class)) {
                HttpEmbedded annoteEmbedded = this.getHttpEmbeddedAnnotation(declaredField);
                if (annoteEmbedded.multiple()) {
                    ArrayList keys = Lists.newArrayList(params.keySet());
                    TreeMap<String, HashMap> subParamMaps = new TreeMap<String, HashMap>((Comparator<String>)Ordering.natural().onResultOf((Function)FunctionToInteger.INSTANCE));
                    TreeMap<String, String> valueMap = new TreeMap<String, String>((Comparator<String>)Ordering.natural().onResultOf((Function)FunctionToInteger.INSTANCE));
                    for (String k : keys) {
                        String currentValue;
                        if (k.matches(Pattern.quote(paramFieldPair.getKey()) + "\\.[0-9]{1,7}\\..*")) {
                            currentValue = params.remove(k);
                            String setKey = k.replaceAll("^" + paramFieldPair.getKey() + "\\.([0-9]{1,7})\\..*", "$1");
                            if (setKey.length() > 7) continue;
                            String subKey = k.replaceAll("^" + paramFieldPair.getKey() + "\\.[0-9]{1,7}\\.", "");
                            Map subMap = (Map)subParamMaps.get(setKey);
                            if (subMap == null) {
                                subMap = Maps.newHashMap();
                                subParamMaps.put(setKey, (HashMap)subMap);
                            }
                            subMap.put(subKey, currentValue);
                            continue;
                        }
                        if (!k.matches(Pattern.quote(paramFieldPair.getKey()) + "\\.[0-9]{1,7}")) continue;
                        currentValue = params.remove(k);
                        String orderKey = k.replaceAll("^" + paramFieldPair.getKey() + "\\.([0-9]{1,7})", "$1");
                        if (orderKey.length() > 7) continue;
                        valueMap.put(orderKey, currentValue);
                    }
                    if (subParamMaps.isEmpty()) {
                        for (String value : valueMap.values()) {
                            failedMappings.addAll(this.populateEmbedded(genericType, value, theList));
                        }
                    } else {
                        for (Map subParams : subParamMaps.values()) {
                            failedMappings.addAll(this.populateEmbedded(genericType, subParams, theList));
                        }
                    }
                } else {
                    failedMappings.addAll(this.populateEmbedded(genericType, params, theList));
                }
            }
        }
        catch (Exception e1) {
            LOG.debug((Object)"FAILED HERE : ", (Throwable)e1);
            failedMappings.add(paramFieldPair.getKey());
        }
        return failedMappings;
    }

    private List<String> populateEmbedded(Class<?> genericType, Map<String, String> params, ArrayList theList) throws InstantiationException, IllegalAccessException {
        GroovyObject embedded = (GroovyObject)genericType.newInstance();
        Map<String, String> embeddedFields = this.buildFieldMap(genericType);
        int startSize = params.size();
        List<String> embeddedFailures = this.populateObject(embedded, embeddedFields, params);
        if (embeddedFailures.isEmpty() && params.size() - startSize != 0) {
            theList.add(embedded);
        }
        return embeddedFailures;
    }

    private List<String> populateEmbedded(Class<?> genericType, String value, ArrayList theList) throws InstantiationException, IllegalAccessException {
        GroovyObject embedded = (GroovyObject)genericType.newInstance();
        Field valueField = this.findValueField(genericType);
        if (valueField == null) {
            throw new IllegalArgumentException("Simple type cannot be mapped for " + genericType.getSimpleName());
        }
        List<String> embeddedFailures = this.populateObject(embedded, Maps.newHashMap(Collections.singletonMap("value", valueField.getName())), Maps.newHashMap(Collections.singletonMap("value", value)));
        if (embeddedFailures.isEmpty()) {
            theList.add(embedded);
        }
        return embeddedFailures;
    }

    @Nullable
    private Field findValueField(Class<?> targetType) {
        while (!(BaseMessage.class.equals(targetType) || EucalyptusMessage.class.equals(targetType) || EucalyptusData.class.equals(targetType) || BaseData.class.equals(targetType))) {
            Field[] fields;
            for (Field f : fields = targetType.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || !f.isAnnotationPresent(HttpValue.class)) continue;
                return f;
            }
            targetType = targetType.getSuperclass();
        }
        return null;
    }

    private Map<String, String> buildFieldMap(Class<?> targetType) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        while (!(BaseMessage.class.equals(targetType) || EucalyptusMessage.class.equals(targetType) || EucalyptusData.class.equals(targetType) || BaseData.class.equals(targetType))) {
            Field[] fields;
            for (Field f : fields = targetType.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                if (f.isAnnotationPresent(HttpParameterMapping.class) || f.isAnnotationPresent(HttpParameterMappings.class)) {
                    for (String parameter : this.getHttpParameterMappingAnnotation(f).parameter()) {
                        fieldMap.put(parameter, f.getName());
                    }
                    continue;
                }
                fieldMap.put(f.getName().substring(0, 1).toUpperCase().concat(f.getName().substring(1)), f.getName());
            }
            targetType = targetType.getSuperclass();
        }
        return fieldMap;
    }

    private HttpEmbedded getHttpEmbeddedAnnotation(Field field) {
        if (field.isAnnotationPresent(HttpEmbedded.class)) {
            return field.getAnnotation(HttpEmbedded.class);
        }
        return (HttpEmbedded)this.getVersionedAnnotation(field.getAnnotation(HttpEmbeddeds.class).value(), HttpEmbeddedVersionExtractor.INSTANCE);
    }

    private HttpParameterMapping getHttpParameterMappingAnnotation(Field field) {
        if (field.isAnnotationPresent(HttpParameterMapping.class)) {
            return field.getAnnotation(HttpParameterMapping.class);
        }
        return (HttpParameterMapping)this.getVersionedAnnotation(field.getAnnotation(HttpParameterMappings.class).value(), HttpParameterMappingVersionExtractor.INSTANCE);
    }

    private <T extends Annotation> T getVersionedAnnotation(T[] values, Function<T, String> versionExtractor) {
        for (T t : values) {
            String version = (String)versionExtractor.apply(t);
            if (Strings.isNullOrEmpty((String)version) || this.getNamespace().compareTo(this.getNamespaceForVersion(version)) >= 1) continue;
            return t;
        }
        return values[values.length - 1];
    }

    private static enum FunctionToInteger implements Function<String, Integer>
    {
        INSTANCE{

            public Integer apply(String parameterIndex) {
                Integer result = Integer.MAX_VALUE;
                try {
                    result = Integer.valueOf(parameterIndex);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return result;
            }
        };

    }

    private static enum HttpParameterMappingVersionExtractor implements Function<HttpParameterMapping, String>
    {
        INSTANCE;


        public String apply(HttpParameterMapping httpParameterMapping) {
            return httpParameterMapping.version();
        }
    }

    private static enum HttpEmbeddedVersionExtractor implements Function<HttpEmbedded, String>
    {
        INSTANCE;


        public String apply(HttpEmbedded httpEmbedded) {
            return httpEmbedded.version();
        }
    }

    public static enum UnknownParameterStrategy {
        IGNORE,
        ERROR;

    }
}

