/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.protocol;

import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import java.util.UUID;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

@ChannelHandler.Sharable
public class AddressingHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(AddressingHandler.class);
    static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    static final String WSA_NAMESPACE_PREFIX = "wsa";
    static final String WSA_MESSAGE_ID = "MessageID";
    static final String WSA_RELATES_TO = "RelatesTo";
    static final String WSA_RELATES_TO_RELATIONSHIP_TYPE = "RelationshipType";
    static final String WSA_TO = "To";
    static final String WSA_REPLY_TO = "ReplyTo";
    static final String WSA_FROM = "From";
    static final String WSA_FAULT_TO = "FaultTo";
    static final String WSA_ACTION = "Action";
    private String prefix;

    public AddressingHandler() {
        this.prefix = "";
    }

    public AddressingHandler(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpMessage = (MappingHttpRequest)((Object)event.getMessage());
            String action = this.prefix + httpMessage.getOmMessage().getLocalName();
            httpMessage.addHeader("SOAPAction", action);
            SOAPHeader header = httpMessage.getSoapEnvelope().getHeader();
            OMNamespace wsaNs = HoldMe.getOMFactory().createOMNamespace(WSA_NAMESPACE, WSA_NAMESPACE_PREFIX);
            if (header != null) {
                SOAPHeaderBlock wsaToHeader = header.addHeaderBlock(WSA_TO, wsaNs);
                wsaToHeader.setText(httpMessage.getUri());
                SOAPHeaderBlock wsaActionHeader = header.addHeaderBlock(WSA_ACTION, wsaNs);
                wsaActionHeader.setText(action);
                SOAPHeaderBlock wsaMsgId = header.addHeaderBlock(WSA_MESSAGE_ID, wsaNs);
                wsaMsgId.setText("urn:uuid:" + UUID.randomUUID().toString().replaceAll("-", "").toUpperCase());
            }
        }
    }
}

