/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers.http;

import com.eucalyptus.ws.handlers.http.HttpException;
import org.jboss.netty.buffer.ChannelBuffer;

public class HttpUtils {
    public static final byte SP = 32;
    public static final byte HT = 9;
    public static final byte CR = 13;
    public static final byte EQUALS = 61;
    public static final byte LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte COLON = 58;
    public static final byte SEMICOLON = 59;
    public static final byte COMMA = 44;
    public static final byte DOUBLE_QUOTE = 34;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public static String readLine(ChannelBuffer buffer, int maxLineLength) throws HttpException {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return sb.toString();
            }
            if (nextByte == 10) {
                return sb.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new HttpException("HTTP input line longer than " + maxLineLength + " bytes: " + sb.toString());
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }
}

