/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.crypto.util.WSSecurity;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.util.CredentialProxy;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@ChannelHandler.Sharable
public abstract class WsSecHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(WsSecHandler.class);
    private final CredentialProxy credentials;

    public WsSecHandler(CredentialProxy credentials) {
        this.credentials = credentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) {
        Object o = event.getMessage();
        if (o instanceof MappingHttpMessage) {
            try {
                MappingHttpMessage httpRequest = (MappingHttpMessage)((Object)o);
                OMElement elem = null;
                Document doc = null;
                SOAPEnvelope env = httpRequest.getSoapEnvelope();
                HoldMe.canHas.lock();
                try {
                    StAXOMBuilder doomBuilder = HoldMe.getStAXOMBuilder(HoldMe.getDOOMFactory(), env.getXMLStreamReader());
                    elem = doomBuilder.getDocumentElement();
                    elem.build();
                    doc = ((Element)elem).getOwnerDocument();
                }
                finally {
                    HoldMe.canHas.unlock();
                }
                ArrayList partsToSign = Lists.newArrayList();
                WSSecHeader wsheader = new WSSecHeader("", false);
                try {
                    wsheader.insertSecurityHeader(doc);
                }
                catch (WSSecurityException e) {
                    LOG.error((Object)e, (Throwable)e);
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
                }
                WSSecSignature signer = new WSSecSignature();
                WSSConfig config = WSSConfig.getNewInstance();
                config.setWsiBSPCompliant(false);
                signer.setWsConfig(config);
                signer.setKeyIdentifierType(1);
                signer.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#");
                try {
                    signer.prepare(doc, (Crypto)this.credentials, wsheader);
                }
                catch (WSSecurityException e) {
                    LOG.error((Object)doc);
                    LOG.error((Object)e, (Throwable)e);
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
                }
                if (this.shouldTimeStamp()) {
                    WSSecTimestamp ts = new WSSecTimestamp();
                    ts.setTimeToLive(300);
                    ts.prepare(doc);
                    ts.prependToHeader(wsheader);
                }
                partsToSign.addAll(this.getSignatureParts());
                signer.appendBSTElementToHeader(wsheader);
                List references = null;
                try {
                    references = signer.addReferencesToSign((List)partsToSign, wsheader);
                }
                catch (WSSecurityException e) {
                    LOG.error((Object)doc);
                    LOG.error((Object)e, (Throwable)e);
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
                }
                try {
                    signer.computeSignature(references, false, null);
                }
                catch (WSSecurityException e) {
                    LOG.error((Object)doc);
                    LOG.error((Object)e, (Throwable)e);
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
                }
                SOAPEnvelope envelope = null;
                HoldMe.canHas.lock();
                try {
                    StAXSOAPModelBuilder stAXSOAPModelBuilder = new StAXSOAPModelBuilder(elem.getXMLStreamReader(), HoldMe.getOMSOAP11Factory(), null);
                    envelope = stAXSOAPModelBuilder.getSOAPEnvelope();
                    if (envelope != null) {
                        envelope.build();
                    }
                }
                finally {
                    HoldMe.canHas.unlock();
                }
                httpRequest.setSoapEnvelope(envelope);
            }
            catch (OMException e) {
                LOG.error((Object)e, (Throwable)e);
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)e);
            }
        }
    }

    public abstract Collection<WSEncryptionPart> getSignatureParts();

    public abstract boolean shouldTimeStamp();

    static {
        WSSecurity.init();
    }
}

