/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.ExceptionMarshallerHandler;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ChannelHandler.Sharable
public class SoapMarshallingHandler
extends MessageStackHandler
implements ExceptionMarshallerHandler {
    private static Logger LOG = Logger.getLogger(SoapMarshallingHandler.class);

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage httpMessage = (MappingHttpMessage)((Object)event.getMessage());
            String content = httpMessage.getContent().toString("UTF-8");
            httpMessage.setMessageString(content);
            HoldMe.canHas.lock();
            SOAPEnvelope env = null;
            try {
                StAXSOAPModelBuilder soapBuilder = null;
                try {
                    SOAPFactory factory = HoldMe.getOMSOAP11Factory();
                    soapBuilder = new StAXSOAPModelBuilder(HoldMe.getXMLStreamReader(content), factory, "http://schemas.xmlsoap.org/soap/envelope/");
                }
                catch (Exception e) {
                    SOAPFactory factory = HoldMe.getOMSOAP12Factory();
                    soapBuilder = new StAXSOAPModelBuilder(HoldMe.getXMLStreamReader(content), factory, "http://www.w3.org/2003/05/soap-envelope");
                }
                env = (SOAPEnvelope)soapBuilder.getDocumentElement();
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to marshall response: " + content));
                LOG.error((Object)ex, (Throwable)ex);
                throw new WebServicesException("Failed to marshall response: " + content, ex);
            }
            finally {
                HoldMe.canHas.unlock();
            }
            httpMessage.setSoapEnvelope(env);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            MappingHttpMessage httpMessage = (MappingHttpMessage)((Object)event.getMessage());
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            HoldMe.canHas.lock();
            try {
                httpMessage.getSoapEnvelope().serialize((OutputStream)byteOut);
            }
            finally {
                HoldMe.canHas.unlock();
            }
            ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])byteOut.toByteArray());
            httpMessage.addHeader("Content-Length", String.valueOf(buffer.readableBytes()));
            httpMessage.addHeader("Content-Type", "text/xml; charset=UTF-8");
            httpMessage.setContent(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ExceptionMarshallerHandler.ExceptionResponse marshallException(@Nonnull ChannelEvent event, @Nonnull HttpResponseStatus status, @Nonnull Throwable t) throws Exception {
        SOAPEnvelope soapEnvelope = Binding.createFault(status.getCode() < 500 ? "soapenv:Client" : "soapenv:Server", t.getMessage(), Logs.isExtrrreeeme() ? Exceptions.string(t) : t.getMessage());
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        HoldMe.canHas.lock();
        try {
            soapEnvelope.serialize((OutputStream)byteOut);
        }
        finally {
            HoldMe.canHas.unlock();
        }
        return new ExceptionMarshallerHandler.ExceptionResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, ChannelBuffers.wrappedBuffer((byte[])byteOut.toByteArray()), (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"text/xml; charset=UTF-8"));
    }
}

