/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.binding.HoldMe;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentPart;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.ws.EucalyptusWebServiceException;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.protocol.RequiredQueryParams;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.MissingFormatArgumentException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public abstract class RestfulMarshallingHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(RestfulMarshallingHandler.class);
    private String namespace;
    private final String namespacePattern;
    private Binding defaultBinding = BindingManager.getDefaultBinding();
    private Binding binding;
    private final Class<? extends ComponentId> component;

    public RestfulMarshallingHandler(String namespacePattern) {
        this.namespacePattern = namespacePattern;
        this.component = this.getClass().getAnnotation(ComponentPart.class) == null ? null : this.getClass().getAnnotation(ComponentPart.class).value();
        try {
            this.setNamespace(String.format(namespacePattern, new Object[0]));
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            // empty catch block
        }
    }

    public RestfulMarshallingHandler(String namespacePattern, String defaultVersion) {
        this(namespacePattern);
        String defaultBindingNamespace = String.format(namespacePattern, defaultVersion);
        this.defaultBinding = BindingManager.getBinding(BindingManager.sanitizeNamespace(defaultBindingNamespace), this.component);
    }

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)((Object)event.getMessage());
            String bindingVersion = httpRequest.getParameters().remove(RequiredQueryParams.Version.toString());
            if (bindingVersion.matches("\\d\\d\\d\\d-\\d\\d-\\d\\d")) {
                this.setNamespaceVersion(bindingVersion);
            } else {
                this.setNamespace(BindingManager.defaultBindingName());
            }
            try {
                BaseMessage msg = (BaseMessage)this.bind(httpRequest);
                httpRequest.setMessage(msg);
            }
            catch (Exception e2) {
                BindingException e2;
                if (!(e2 instanceof BindingException)) {
                    e2 = new BindingException(e2);
                }
                throw e2;
            }
        }
    }

    protected void setNamespace(String namespace) {
        this.namespace = namespace;
        this.binding = BindingManager.getBinding(this.namespace, this.component);
    }

    protected String getNamespaceForVersion(String bindingVersion) {
        return String.format(this.namespacePattern, bindingVersion);
    }

    private void setNamespaceVersion(String bindingVersion) {
        String newNs = null;
        try {
            newNs = String.format(this.namespacePattern, new Object[0]);
        }
        catch (MissingFormatArgumentException e) {
            newNs = String.format(this.namespacePattern, bindingVersion);
        }
        this.setNamespace(newNs);
    }

    public abstract Object bind(MappingHttpRequest var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpResponse) {
            MappingHttpResponse httpResponse = (MappingHttpResponse)event.getMessage();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(8192);
            HoldMe.canHas.lock();
            try {
                if (httpResponse.getMessage() != null) {
                    if (httpResponse.getMessage() instanceof EucalyptusErrorMessageType) {
                        EucalyptusErrorMessageType errMsg = (EucalyptusErrorMessageType)httpResponse.getMessage();
                        byteOut.write(Binding.createRestFault(errMsg.getSource(), errMsg.getMessage(), errMsg.getCorrelationId()).getBytes());
                        httpResponse.setStatus(HttpResponseStatus.BAD_REQUEST);
                    } else if (httpResponse.getMessage() instanceof ExceptionResponseType) {
                        ExceptionResponseType msg = (ExceptionResponseType)httpResponse.getMessage();
                        String detail = msg.getError();
                        if (msg.getException() != null) {
                            Logs.extreme().debug((Object)msg, msg.getException());
                        }
                        if (msg.getException() instanceof EucalyptusWebServiceException) {
                            detail = msg.getCorrelationId();
                        }
                        String response = Binding.createRestFault(msg.getRequestType(), msg.getMessage(), detail);
                        byteOut.write(response.getBytes());
                        httpResponse.setStatus(msg.getHttpStatus());
                    } else {
                        Object message = httpResponse.getMessage();
                        try {
                            this.binding.toStream(byteOut, message, this.getNamespaceOverride(message, null));
                        }
                        catch (BindingException ex) {
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            byteOut.reset();
                            try {
                                this.getDefaultBinding().toStream(byteOut, message, this.getNamespaceOverride(message, this.namespace));
                            }
                            catch (BindingException ex1) {
                                byteOut.reset();
                                BindingManager.getDefaultBinding().toStream(byteOut, message);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Object)e);
                            Logs.exhaust().error((Object)e, (Throwable)e);
                            throw e;
                        }
                    }
                }
                byte[] req = byteOut.toByteArray();
                ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])req);
                httpResponse.addHeader("Content-Length", String.valueOf(buffer.readableBytes()));
                httpResponse.addHeader("Content-Type", "application/xml; charset=UTF-8");
                httpResponse.setContent(buffer);
            }
            finally {
                HoldMe.canHas.unlock();
            }
        }
    }

    public static void streamResponse(Object message) {
        Context context = Contexts.lookup();
        final Channel channel = context.getChannel();
        RestfulMarshallingHandler handler = (RestfulMarshallingHandler)channel.getPipeline().get(RestfulMarshallingHandler.class);
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        EncodingWrapper wrapper = RestfulMarshallingHandler.getEncodingWrapper();
        wrapper.writeHeaders((HttpMessage)httpResponse);
        try {
            httpResponse.addHeader("Transfer-Encoding", (Object)"chunked");
            httpResponse.addHeader("Content-Type", (Object)"application/xml; charset=UTF-8");
            OutputStream outputStream = wrapper.wrapOutput(new BufferedOutputStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    this.write(new byte[]{(byte)b}, 0, 1);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    ChannelFuture future = Channels.write((Channel)channel, (Object)new DefaultHttpChunk(ChannelBuffers.wrappedBuffer((byte[])b, (int)off, (int)len)));
                    if (!future.awaitUninterruptibly().isSuccess()) {
                        throw new IOException(future.getCause());
                    }
                }

                @Override
                public void flush() throws IOException {
                }
            }));
            Channels.write((Channel)channel, (Object)httpResponse);
            handler.binding.toStream(outputStream, message);
            outputStream.close();
            Channels.write((Channel)channel, (Object)HttpChunk.LAST_CHUNK);
        }
        catch (Exception e) {
            LOG.error((Object)"Error streaming response", (Throwable)e);
        }
    }

    protected String getNamespaceOverride(@Nonnull Object message, @Nullable String namespace) {
        return namespace;
    }

    static EncodingWrapper getEncodingWrapper() {
        String accept;
        EncodingWrapper wrapper = null;
        MappingHttpRequest request = Contexts.lookup().getHttpRequest();
        if (request != null && (accept = ((String)Objects.firstNonNull((Object)request.getHeader("Accept-Encoding"), (Object)"")).toLowerCase()).matches("[a-z, *_-]{1,1024}")) {
            Iterable encodings = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)accept);
            if (Iterables.contains((Iterable)encodings, (Object)"deflate")) {
                wrapper = new DeflateEncodingWrapper();
            } else if (Iterables.contains((Iterable)encodings, (Object)"gzip")) {
                wrapper = new GzipEncodingWrapper();
            }
        }
        if (wrapper == null) {
            wrapper = new EncodingWrapper();
        }
        return wrapper;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public Binding getDefaultBinding() {
        return this.defaultBinding;
    }

    private static final class GzipEncodingWrapper
    extends CompressingEncodingWrapper {
        private GzipEncodingWrapper() {
            super("gzip");
        }

        @Override
        @Nonnull
        OutputStream compress(@Nonnull OutputStream out) throws IOException {
            return new GZIPOutputStream(out);
        }
    }

    private static final class DeflateEncodingWrapper
    extends CompressingEncodingWrapper {
        DeflateEncodingWrapper() {
            super("deflate");
        }

        @Override
        @Nonnull
        OutputStream compress(@Nonnull OutputStream out) {
            return new DeflaterOutputStream(out);
        }
    }

    private static abstract class CompressingEncodingWrapper
    extends EncodingWrapper {
        private final String encoding;

        protected CompressingEncodingWrapper(String encoding) {
            this.encoding = encoding;
        }

        @Override
        void writeHeaders(@Nonnull HttpMessage httpResponse) {
            httpResponse.addHeader("Content-Encoding", (Object)this.encoding);
        }

        @Override
        @Nonnull
        final OutputStream wrapOutput(@Nonnull OutputStream out) throws IOException {
            return this.compress(out);
        }

        @Nonnull
        abstract OutputStream compress(@Nonnull OutputStream var1) throws IOException;
    }

    private static class EncodingWrapper {
        private EncodingWrapper() {
        }

        void writeHeaders(@Nonnull HttpMessage httpResponse) {
        }

        @Nonnull
        OutputStream wrapOutput(@Nonnull OutputStream out) throws IOException {
            return out;
        }
    }
}

