/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.crypto.util.SecurityHeader;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.crypto.util.Timestamps;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.handlers.SignatureHandlerUtils;
import com.eucalyptus.ws.util.HmacUtils;
import com.google.common.base.Function;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.MessageEvent;

public class QueryTimestampHandler
extends MessageStackHandler {
    private static final Logger LOG = Logger.getLogger(QueryTimestampHandler.class);
    private static final EnumSet<HmacUtils.SignatureVersion> SIGNATURE_VERSIONS = EnumSet.allOf(HmacUtils.SignatureVersion.class);

    @Override
    public void incomingMessage(MessageEvent event) throws AuthenticationException {
        if (event.getMessage() instanceof MappingHttpRequest) {
            String exp;
            String timestamp;
            Calendar expires;
            Calendar now;
            block10: {
                Function<String, List<String>> parameterLookup;
                MappingHttpRequest httpRequest = (MappingHttpRequest)((Object)event.getMessage());
                Map<String, String> parameters = httpRequest.getParameters();
                Function<String, List<String>> headerLookup = SignatureHandlerUtils.headerLookup(httpRequest);
                boolean hasSignatureDate = HmacUtils.hasSignatureDate(SIGNATURE_VERSIONS, headerLookup, parameterLookup = SignatureHandlerUtils.parameterLookup(httpRequest));
                if (!hasSignatureDate && !parameters.containsKey(SecurityParameter.Expires.parameter())) {
                    throw new AuthenticationException("One of the following parameters must be specified: " + SecurityParameter.Timestamp.parameter() + " OR " + SecurityParameter.Expires.parameter() + " OR " + SecurityParameter.X_Amz_Date.parameter() + " OR " + SecurityHeader.Date.header());
                }
                now = Calendar.getInstance();
                expires = Calendar.getInstance();
                timestamp = null;
                exp = null;
                try {
                    if (hasSignatureDate) {
                        Date date = HmacUtils.getSignatureDate(SIGNATURE_VERSIONS, headerLookup, parameterLookup);
                        parameters.keySet().removeAll(HmacUtils.detectSignatureVariant(headerLookup, parameterLookup).getDateParametersToRemove());
                        expires.setTimeInMillis(this.verifyTimestampAndCalculateExpiry(now.getTimeInMillis(), date));
                        break block10;
                    }
                    exp = parameters.remove(SecurityParameter.Expires.parameter());
                    try {
                        expires.setTime(Timestamps.parseIso8601Timestamp(exp));
                    }
                    catch (Exception e) {
                        expires.setTime(Timestamps.parseIso8601Timestamp(URLDecoder.decode(exp)));
                    }
                    Calendar cacheExpire = (Calendar)now.clone();
                    cacheExpire.add(12, 15);
                    if (expires.after(cacheExpire)) {
                        LOG.warn((Object)("[security] Message expiration date " + expires + " is further in the future that replay cache expiration"));
                    }
                }
                catch (AuthenticationException a) {
                    LOG.debug((Object)a, (Throwable)a);
                    throw a;
                }
                catch (Exception t) {
                    LOG.debug((Object)t, (Throwable)t);
                    throw new AuthenticationException("Failure to parse timestamp: Timestamp=" + timestamp + " Expires=" + exp);
                }
            }
            if (now.after(expires)) {
                expires.setTimeZone(TimeZone.getTimeZone("GMT"));
                String expiryTime = String.format("%4d-%02d-%02dT%02d:%02d:%02d", expires.get(1), expires.get(2) + 1, expires.get(5), expires.get(11), expires.get(12), expires.get(13));
                throw new AuthenticationException("Message has expired (times in UTC): Timestamp=" + timestamp + " Expires=" + exp + " Deadline=" + expiryTime);
            }
        }
    }

    private long verifyTimestampAndCalculateExpiry(long now, Date timestamp) throws AuthenticationException {
        long maxTimestamp = now + TimeUnit.SECONDS.toMillis(StackConfiguration.CLOCK_SKEW_SEC.intValue());
        if (maxTimestamp < timestamp.getTime()) {
            throw new AuthenticationException("Message was generated in the future (times in UTC): Timestamp=" + timestamp);
        }
        return timestamp.getTime() + TimeUnit.SECONDS.toMillis(900 + StackConfiguration.CLOCK_SKEW_SEC);
    }
}

