/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.WSSecurity;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.WsSecHandler;
import com.eucalyptus.ws.util.CredentialProxy;
import com.google.common.collect.Lists;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.apache.ws.security.WSEncryptionPart;
import org.jboss.netty.channel.MessageEvent;

public class NodeWsSecHandler
extends WsSecHandler {
    private static final String WSA_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    private static Logger LOG = Logger.getLogger(NodeWsSecHandler.class);

    public NodeWsSecHandler() {
        super(new CredentialProxy(Eucalyptus.class));
    }

    @Override
    public Collection<WSEncryptionPart> getSignatureParts() {
        return Lists.newArrayList((Object[])new WSEncryptionPart[]{new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Content"), new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "Content")});
    }

    @Override
    public boolean shouldTimeStamp() {
        return true;
    }

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        Object o = event.getMessage();
        if (o instanceof MappingHttpRequest) {
            MappingHttpMessage httpRequest = (MappingHttpMessage)((Object)o);
            SOAPEnvelope envelope = httpRequest.getSoapEnvelope();
            X509Certificate cert = WSSecurity.verifyWSSec(envelope);
            if (cert == null) {
                throw new WebServicesException("Authentication failed: Certificate is null");
            }
            boolean nodeCertFound = false;
            for (Partition p : Partitions.list()) {
                if (!cert.equals(p.getNodeCertificate())) continue;
                nodeCertFound = true;
                break;
            }
            if (!nodeCertFound) {
                throw new WebServicesException("Authentication failed: The following certificate is not trusted:\n " + cert);
            }
            Contexts.lookup(((MappingHttpMessage)((Object)o)).getCorrelationId()).setUser(Principals.systemUser());
        }
    }
}

