/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.server.MessageStatistics;
import java.util.concurrent.Callable;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public abstract class MessageStackHandler
implements ChannelDownstreamHandler,
ChannelUpstreamHandler {
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        try {
            MessageEvent msgEvent;
            if (channelEvent instanceof MessageEvent && (msgEvent = (MessageEvent)channelEvent).getMessage() != null) {
                Callable<Long> stat = MessageStatistics.startDownstream(ctx.getChannel(), this);
                this.outgoingMessage(ctx, msgEvent);
                stat.call();
            }
            ctx.sendDownstream(channelEvent);
        }
        catch (Exception e) {
            throw new WebServicesException(e.getMessage(), HttpResponseStatus.BAD_REQUEST);
        }
    }

    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
    }

    public void incomingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        this.incomingMessage(event);
    }

    public void incomingMessage(MessageEvent event) throws Exception {
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent channelEvent) throws Exception {
        if (channelEvent instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)channelEvent;
            Callable<Long> stat = MessageStatistics.startUpstream(ctx.getChannel(), this);
            this.incomingMessage(ctx, msgEvent);
            stat.call();
            ctx.sendUpstream(channelEvent);
        } else {
            ctx.sendUpstream(channelEvent);
        }
    }
}

