/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.auth.login.AuthenticationException;
import com.eucalyptus.auth.login.HmacCredentials;
import com.eucalyptus.auth.login.SecurityContext;
import com.eucalyptus.auth.principal.TemporaryAccessKey;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.crypto.util.SecurityParameter;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import com.eucalyptus.ws.handlers.SignatureHandlerUtils;
import com.eucalyptus.ws.util.HmacUtils;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.MessageEvent;

public class HmacHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(HmacHandler.class);
    private final Set<TemporaryAccessKey.TemporaryKeyType> allowedTemporaryKeyTypes;

    public HmacHandler(Set<TemporaryAccessKey.TemporaryKeyType> allowedTemporaryKeyTypes) {
        this.allowedTemporaryKeyTypes = allowedTemporaryKeyTypes;
    }

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpRequest) {
            MappingHttpRequest httpRequest = (MappingHttpRequest)((Object)event.getMessage());
            Map<String, String> parameters = httpRequest.getParameters();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            httpRequest.getContent().markReaderIndex();
            httpRequest.getContent().readBytes((OutputStream)bos, httpRequest.getContent().readableBytes());
            httpRequest.getContent().resetReaderIndex();
            String body = bos.toString();
            bos.close();
            Function<String, List<String>> headerLookup = SignatureHandlerUtils.headerLookup(httpRequest);
            Function<String, List<String>> parameterLookup = SignatureHandlerUtils.parameterLookup(httpRequest);
            HmacUtils.SignatureVariant variant = HmacUtils.detectSignatureVariant(headerLookup, parameterLookup);
            HashMap headers = Maps.newHashMap();
            for (String header : httpRequest.getHeaderNames()) {
                headers.put(header.toLowerCase(), httpRequest.getHeaders(header));
            }
            if (variant.getVersion().value() <= 2 && !parameters.containsKey(SecurityParameter.AWSAccessKeyId.parameter())) {
                throw new AuthenticationException("Missing required parameter: " + (Object)((Object)SecurityParameter.AWSAccessKeyId));
            }
            HmacCredentials credentials = new HmacCredentials(httpRequest.getCorrelationId(), variant, this.processParametersForVariant(httpRequest, variant), headers, httpRequest.getMethod().getName(), httpRequest.getServicePath(), body);
            SecurityContext.getLoginContext(credentials).login();
            Subject subject = Contexts.lookup(httpRequest.getCorrelationId()).getSubject();
            HmacCredentials.QueryIdCredential credential = (HmacCredentials.QueryIdCredential)Iterables.getFirst(subject.getPublicCredentials(HmacCredentials.QueryIdCredential.class), null);
            if (credential == null || credential.getType().isPresent() && !this.allowedTemporaryKeyTypes.contains(credential.getType().get())) {
                throw new AuthenticationException("Temporary credentials forbidden for service");
            }
            parameters.keySet().removeAll(variant.getParametersToRemove());
            parameters.remove(SecurityParameter.SecurityToken.parameter());
        }
    }

    private Map<String, List<String>> processParametersForVariant(MappingHttpRequest httpRequest, HmacUtils.SignatureVariant variant) {
        HashMap result = httpRequest.getParameters();
        if (variant.getVersion().value() > 2) {
            result = Maps.newHashMap();
            for (Map.Entry<String, String> entry : httpRequest.getParameters().entrySet()) {
                if (!httpRequest.isQueryParameter(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return Maps.transformValues((Map)result, CollectionUtils.listUnit());
    }
}

