/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.handlers;

import com.eucalyptus.binding.Binding;
import com.eucalyptus.binding.BindingException;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.MessageStackHandler;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;

public class BindingHandler
extends MessageStackHandler {
    private static Logger LOG = Logger.getLogger(BindingHandler.class);
    private Binding binding;
    private String namespace;
    private final Binding defaultBinding;
    private final Pattern namespacePattern;
    private final Class<? extends ComponentId> component;

    public BindingHandler(Binding binding) {
        this(binding, null, null);
    }

    public BindingHandler(Binding binding, Pattern namespacePattern) {
        this(binding, namespacePattern, null);
    }

    public BindingHandler(Binding binding, Pattern namespacePattern, Class<? extends ComponentId> component) {
        this.binding = binding;
        this.defaultBinding = binding;
        this.namespacePattern = namespacePattern;
        this.component = component;
    }

    @Override
    public void incomingMessage(MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            Class msgType;
            BaseMessage msg;
            MappingHttpMessage httpMessage;
            block15: {
                httpMessage = (MappingHttpMessage)((Object)event.getMessage());
                msg = null;
                msgType = null;
                String namespace = null;
                try {
                    OMElement elem = httpMessage.getOmMessage();
                    OMNamespace omNs = elem.getNamespace();
                    namespace = omNs.getNamespaceURI();
                    if (this.namespacePattern != null && !this.namespacePattern.matcher(namespace).matches()) {
                        throw new WebServicesException("Invalid request");
                    }
                    this.binding = BindingManager.getBinding(namespace, this.component);
                    msgType = this.binding.getElementClass(httpMessage.getOmMessage().getLocalName());
                }
                catch (BindingException ex) {
                    if (this.defaultBinding == null) break block15;
                    this.namespace = namespace;
                    this.binding = this.defaultBinding;
                    try {
                        msgType = this.binding.getElementClass(httpMessage.getOmMessage().getLocalName());
                    }
                    catch (Exception ex1) {
                        throw new WebServicesException("Failed to find binding for namespace: " + namespace + " due to: " + ex.getMessage(), ex);
                    }
                }
                catch (Exception e1) {
                    LOG.error((Object)(e1.getMessage() + " while attempting to bind: " + httpMessage.getOmMessage()));
                    Logs.extreme().error((Object)httpMessage.getSoapEnvelope().toString(), (Throwable)e1);
                    if (this.binding == null) {
                        throw new WebServicesException(e1);
                    }
                    throw new WebServicesException("Failed to find binding for namespace: " + namespace + " due to: " + e1.getMessage(), e1);
                }
            }
            try {
                msg = httpMessage instanceof MappingHttpRequest ? (msgType != null ? (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage(), msgType) : (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage())) : (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage());
            }
            catch (Exception e1) {
                try {
                    msg = (BaseMessage)this.binding.fromOM(httpMessage.getOmMessage(), this.namespace);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("FAILED TO PARSE:\n" + httpMessage.getMessageString()));
                    throw new WebServicesException(e1);
                }
            }
            if (httpMessage.getCorrelationId() != null && msg.getCorrelationId() != null && msg.hasRequestId()) {
                try {
                    Context ctx = Contexts.lookup(httpMessage.getCorrelationId());
                    msg.regardingRequestId(msg.getCorrelationId());
                    httpMessage.setCorrelationId(msg.getCorrelationId());
                    Contexts.update(ctx, httpMessage.getCorrelationId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            msg.setCorrelationId(httpMessage.getCorrelationId());
            httpMessage.setMessage(msg);
        }
    }

    @Override
    public void outgoingMessage(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
        if (event.getMessage() instanceof MappingHttpMessage) {
            OMElement omElem;
            MappingHttpMessage httpMessage = (MappingHttpMessage)((Object)event.getMessage());
            if (httpMessage.getMessage() instanceof EucalyptusErrorMessageType || httpMessage.getMessage() == null) {
                return;
            }
            if (httpMessage.getMessage() instanceof ExceptionResponseType) {
                ExceptionResponseType msg = (ExceptionResponseType)httpMessage.getMessage();
                String createFaultDetails = Logs.isExtrrreeeme() ? Exceptions.string(msg.getException()) : msg.getException().getMessage();
                omElem = Binding.createFault(msg.getRequestType(), msg.getMessage(), createFaultDetails);
                if (httpMessage instanceof MappingHttpResponse) {
                    ((MappingHttpResponse)httpMessage).setStatus(msg.getHttpStatus());
                }
            } else {
                try {
                    omElem = this.binding.toOM(httpMessage.getMessage(), this.namespace);
                }
                catch (BindingException ex) {
                    omElem = BindingManager.getDefaultBinding().toOM(httpMessage.getMessage());
                }
                catch (Exception ex) {
                    Logs.exhaust().debug((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
            httpMessage.setOmMessage(omElem);
        }
    }
}

