/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.client;

import com.eucalyptus.component.Component;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Dispatcher;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.FullName;
import com.eucalyptus.ws.EucalyptusRemoteFault;
import com.eucalyptus.ws.client.NioClient;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.module.client.MuleClient;

public abstract class ServiceDispatcher
implements Dispatcher {
    private static Logger LOG = Logger.getLogger(ServiceDispatcher.class);
    private static ConcurrentMap<FullName, Dispatcher> proxies = new ConcurrentHashMap<FullName, Dispatcher>();
    private static ChannelPipelineFactory internalPipeline = ComponentIds.lookup(Empyrean.class).getClientPipeline();

    public static Dispatcher lookupSingle(Component c) throws NoSuchElementException {
        return ServiceDispatcher.lookupSingle(c.getComponentId().getClass());
    }

    public static Dispatcher lookupSingle(Class<? extends ComponentId> c) throws NoSuchElementException {
        try {
            ServiceConfiguration first = Topology.enabledServices(c).iterator().next();
            if (!Component.State.ENABLED.equals(first.lookupState())) {
                LOG.error((Object)("Failed to find service dispatcher for component=" + c));
                throw new NoSuchElementException("Failed to find ENABLED service for component=" + c.getName() + " existing services are: " + ServiceConfigurations.list(c));
            }
            return ServiceDispatcher.lookup(first);
        }
        catch (NoSuchElementException ex) {
            LOG.error((Object)("Failed to find service dispatcher for component=" + c), (Throwable)ex);
            throw new NoSuchElementException("Failed to find service for component=" + c);
        }
    }

    public static Dispatcher lookup(ServiceConfiguration configuration) {
        return configuration.isVmLocal() != false ? new LocalDispatcher(configuration, configuration.getComponentId().getLocalEndpointUri()) : new RemoteDispatcher(configuration, ServiceUris.internal(configuration, new String[0]));
    }

    static class LocalDispatcher
    extends AbstractDispatcher {
        private MuleClient muleClient;

        LocalDispatcher(ServiceConfiguration serviceConfiguration, URI address) {
            super(serviceConfiguration, address);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(BaseMessage msg) {
            MuleEvent context = RequestContext.getEvent();
            try {
                ServiceContext.dispatch(this.getServiceConfiguration().getComponentId().getLocalEndpointName(), msg);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            finally {
                RequestContext.setEvent((MuleEvent)context);
            }
        }

        public BaseMessage send(BaseMessage msg) {
            try {
                return (BaseMessage)ServiceContext.send(this.getComponentId(), (Object)msg);
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((String)ex.getMessage(), (Throwable[])new Exception[]{ex});
            }
        }

        @Override
        public boolean isLocal() {
            return true;
        }
    }

    static class RemoteDispatcher
    extends AbstractDispatcher {
        RemoteDispatcher(ServiceConfiguration serviceConfiguration, URI address) {
            super(serviceConfiguration, address);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatch(BaseMessage msg) {
            MuleEvent context = RequestContext.getEvent();
            try {
                this.getNioClient().dispatch(msg);
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
            finally {
                RequestContext.setEvent((MuleEvent)context);
            }
        }

        public BaseMessage send(BaseMessage msg) throws EucalyptusCloudException {
            MuleEvent context = RequestContext.getEvent();
            try {
                BaseMessage baseMessage = this.getNioClient().send(msg);
                return baseMessage;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                EucalyptusRemoteFault rootCause = Exceptions.findCause(e, EucalyptusRemoteFault.class);
                if (rootCause == null) {
                    throw new EucalyptusCloudException(e);
                }
                if (rootCause instanceof EucalyptusRemoteFault) {
                    EucalyptusRemoteFault remoteFault = rootCause;
                    throw new EucalyptusCloudException(" " + remoteFault.getFaultString());
                }
                throw new EucalyptusCloudException(msg.getClass().getSimpleName() + ": " + rootCause.getMessage(), rootCause);
            }
            finally {
                RequestContext.setEvent((MuleEvent)context);
            }
        }

        @Override
        public boolean isLocal() {
            return false;
        }
    }

    static abstract class AbstractDispatcher
    implements Dispatcher {
        private final ServiceConfiguration serviceConfiguration;
        private final URI address;

        AbstractDispatcher(ServiceConfiguration serviceConfiguration, URI address) {
            this.serviceConfiguration = serviceConfiguration;
            this.address = address;
        }

        public final ComponentId getComponentId() {
            return this.serviceConfiguration.getComponentId();
        }

        @Override
        public final String getName() {
            return this.serviceConfiguration.getFullName().toString();
        }

        @Override
        public final URI getAddress() {
            return this.address;
        }

        protected final NioClient getNioClient() throws Exception {
            return new NioClient(this.address.getHost(), this.address.getPort(), this.address.getPath(), ComponentIds.lookup(Empyrean.class).getClientPipeline());
        }

        protected final ServiceConfiguration getServiceConfiguration() {
            return this.serviceConfiguration;
        }

        @Override
        public String toString() {
            return String.format("Dispatcher:serviceConfiguration=%s:address=%s:isLocal()=%s", this.serviceConfiguration, this.address, this.isLocal());
        }
    }
}

