/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws.client;

import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.EucalyptusClusterException;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.ws.Client;
import com.eucalyptus.ws.handlers.ResponseHandler;
import com.google.common.base.Supplier;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;

public class NioClient
implements Client {
    private static NioClientSocketChannelFactory clientSocketFactory;
    private static OrderedMemoryAwareThreadPoolExecutor clientBossPool;
    private static OrderedMemoryAwareThreadPoolExecutor clientWorkerPool;
    private static Logger LOG;
    private ClientBootstrap clientBootstrap;
    private String hostname;
    private int port;
    private String servicePath;
    private InetSocketAddress remoteAddr;
    private ResponseHandler responseHandler = new NioResponseHandler();
    private ChannelFuture connectFuture;

    public static ClientBootstrap getClientBootstrap(ChannelPipelineFactory factory) {
        ClientBootstrap bootstrap = new ClientBootstrap(NioClient.getClientChannelFactory());
        bootstrap.setPipelineFactory(factory);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("connectTimeoutMillis", (Object)3000);
        return bootstrap;
    }

    private static synchronized ChannelFactory getClientChannelFactory() {
        if (clientSocketFactory == null) {
            clientBossPool = new OrderedMemoryAwareThreadPoolExecutor(4, 0xA00000L, 0xC800000L, 500L, TimeUnit.MILLISECONDS);
            clientWorkerPool = new OrderedMemoryAwareThreadPoolExecutor(16, 0xA00000L, 0xC800000L, 500L, TimeUnit.MILLISECONDS);
            clientSocketFactory = new NioClientSocketChannelFactory((Executor)clientBossPool, (Executor)clientWorkerPool, 16);
        }
        return clientSocketFactory;
    }

    public static ChannelFutureListener WRITE(Object o) {
        return new DeferedWriter(o, new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
            }
        });
    }

    public NioClient(String hostname, int port, String servicePath, ChannelPipelineFactory clientPipeline) {
        this.clientBootstrap = NioClient.getClientBootstrap(new DelegatingPipeline(clientPipeline, this.responseHandler));
        this.remoteAddr = new InetSocketAddress(hostname, port);
        this.hostname = hostname;
        this.port = port;
        this.servicePath = servicePath;
        this.connectFuture = this.clientBootstrap.connect((SocketAddress)this.remoteAddr);
    }

    public void write(HttpRequest httpRequest) throws Exception {
        this.connectFuture.addListener(NioClient.WRITE(httpRequest));
    }

    @Override
    public BaseMessage send(BaseMessage msg) throws Exception {
        MappingHttpRequest request = new MappingHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.hostname, this.port, this.servicePath, msg);
        this.write(request);
        Object response = this.responseHandler.getResponse();
        return response;
    }

    @Override
    public void dispatch(BaseMessage msg) throws Exception {
        MappingHttpRequest request = new MappingHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.hostname, this.port, this.servicePath, msg);
        this.write(request);
        Object response = this.responseHandler.getResponse();
    }

    @Override
    public String getUri() {
        return "http://" + this.hostname + ":" + this.port + (this.servicePath.startsWith("/") ? "" : "?") + this.servicePath;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getServicePath() {
        return this.servicePath;
    }

    static {
        LOG = Logger.getLogger(NioClient.class);
    }

    public static class DelegatingPipeline
    implements ResponseHandlingPipeline {
        private ChannelPipelineFactory pipelineFactory;
        private ResponseHandler handler;

        DelegatingPipeline(ChannelPipelineFactory pipelineFactory, ResponseHandler handler) {
            this.pipelineFactory = pipelineFactory;
            this.handler = handler;
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = this.pipelineFactory.getPipeline();
            pipeline.addLast("response-handler", (ChannelHandler)this.handler);
            return pipeline;
        }

        public BaseMessage getRequest() {
            return this.handler.getRequest();
        }

        public BaseMessage getResponse() throws Exception {
            return this.handler.getResponse();
        }

        public void waitForResponse() {
            this.handler.waitForResponse();
        }

        public ResponseHandler get() {
            return this.handler;
        }
    }

    public class NioResponseHandler
    extends SimpleChannelHandler
    implements ResponseHandler {
        private Lock canHas = new ReentrantLock();
        private Condition ready = this.canHas.newCondition();
        private AtomicReference<Object> response = new AtomicReference<Object>(null);
        protected BlockingQueue<BaseMessage> requestQueue = new LinkedBlockingQueue<BaseMessage>();

        public boolean hasException() {
            return this.response.get() instanceof Throwable;
        }

        public boolean hasResponse() {
            return this.response.get() instanceof BaseMessage;
        }

        public BaseMessage getResponse() throws Exception {
            this.waitForResponse();
            if (this.response.get() instanceof BaseMessage) {
                return (BaseMessage)this.response.get();
            }
            if (this.response.get() instanceof Throwable) {
                throw new EucalyptusClusterException("Exception in NIO request.", (Throwable)this.response.get());
            }
            throw new EucalyptusClusterException("Failed to retrieve result of asynchronous operation.");
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
            LOG.debug((Object)e, e);
            this.queueResponse(e);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            this.exceptionCaught(ctx, e.getCause());
            ctx.getChannel().close();
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            MappingHttpMessage httpResponse = (MappingHttpMessage)((Object)e.getMessage());
            BaseMessage reply = (BaseMessage)httpResponse.getMessage();
            this.queueResponse(reply);
            ctx.getChannel().close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueResponse(Object o) {
            if (o instanceof MappingHttpResponse) {
                MappingHttpResponse httpResponse = (MappingHttpResponse)o;
                o = httpResponse.getMessage() != null ? httpResponse.getMessage() : new EucalyptusClusterException(httpResponse.getMessageString());
            }
            this.canHas.lock();
            try {
                if (!this.response.compareAndSet(null, o)) {
                    if (!(o instanceof Throwable)) {
                        LOG.debug((Object)LogUtil.subheader("Received spurious second response: " + LogUtil.dumpObject(o)));
                    }
                    o = this.response.getAndSet(o);
                    LOG.debug((Object)LogUtil.subheader("Previous response was: " + LogUtil.dumpObject(this.response.get())));
                } else if (o instanceof Throwable) {
                    LOG.error((Object)"Caught exception in asynchronous response handler.", (Throwable)o);
                } else {
                    LOG.trace((Object)(this.getClass().getSimpleName() + " Got response of: " + LogUtil.dumpObject(o)));
                }
                this.ready.signalAll();
            }
            finally {
                this.canHas.unlock();
            }
        }

        public Throwable getException() {
            this.waitForResponse();
            return (Throwable)this.response.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForResponse() {
            this.canHas.lock();
            try {
                while (this.response.get() == null) {
                    try {
                        this.ready.await(10000L, TimeUnit.MILLISECONDS);
                        LOG.debug((Object)"Waiting for response.");
                    }
                    catch (InterruptedException e) {
                        LOG.debug((Object)e, (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
                EventRecord.here(NioResponseHandler.class, EventType.MSG_SERVICED, this.response.get().getClass().toString()).debug();
            }
            finally {
                this.canHas.unlock();
            }
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            if (this.response.get() == null) {
                this.queueResponse(new EucalyptusClusterException(LogUtil.dumpObject(e)));
            }
            super.channelClosed(ctx, e);
        }

        public BaseMessage getRequest() {
            throw new RuntimeException("Not implemented");
        }
    }

    private static class DeferedWriter
    implements ChannelFutureListener {
        private Object request;
        private ChannelFutureListener callback;

        DeferedWriter(Object request, ChannelFutureListener callback) {
            this.callback = callback;
            this.request = request;
        }

        public void operationComplete(ChannelFuture channelFuture) {
            if (channelFuture.isSuccess()) {
                channelFuture.getChannel().write(this.request).addListener(this.callback);
            } else {
                LOG.debug((Object)channelFuture.getCause(), channelFuture.getCause());
                try {
                    this.callback.operationComplete(channelFuture);
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    public static interface ResponseHandlingPipeline
    extends ChannelPipelineFactory,
    Supplier<ResponseHandler> {
    }
}

