/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.LockResource;
import com.eucalyptus.util.LogUtil;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.Strings;
import com.eucalyptus.ws.Handlers;
import com.eucalyptus.ws.StackConfiguration;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;

public class WebServices {
    private static Logger LOG = Logger.getLogger(WebServices.class);
    private static Lock clientResourceLock = new ReentrantLock();
    private static Executor clientWorkerThreadPool;
    private static NioClientSocketChannelFactory nioClientSocketChannelFactory;
    private static Runnable serverShutdown;

    private static Iterable<Cidr> parse(Function<String, Optional<Cidr>> cidrTransform, String cidrList) {
        return Optional.presentInstances((Iterable)Iterables.transform((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)", ;:")).trimResults().omitEmptyStrings().split((CharSequence)cidrList), cidrTransform));
    }

    public static ClientBootstrap clientBootstrap(ChannelPipelineFactory factory) {
        NioClientSocketChannelFactory clientChannelFactory = WebServices.clientChannelFactory();
        ClientBootstrap bootstrap = WebServices.clientBootstrap(factory, (ChannelFactory)clientChannelFactory);
        return bootstrap;
    }

    private static ClientBootstrap clientBootstrap(ChannelPipelineFactory factory, ChannelFactory clientChannelFactory) {
        ClientBootstrap bootstrap = new ClientBootstrap(clientChannelFactory);
        bootstrap.setPipelineFactory(factory);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("connectTimeoutMillis", (Object)3000);
        return bootstrap;
    }

    private static NioClientSocketChannelFactory clientChannelFactory() {
        if (nioClientSocketChannelFactory != null) {
            return nioClientSocketChannelFactory;
        }
        try (LockResource resourceLock = LockResource.lock(clientResourceLock);){
            if (nioClientSocketChannelFactory != null) {
                NioClientSocketChannelFactory nioClientSocketChannelFactory = WebServices.nioClientSocketChannelFactory;
                return nioClientSocketChannelFactory;
            }
            NioClientSocketChannelFactory nioClientSocketChannelFactory = WebServices.nioClientSocketChannelFactory = new NioClientSocketChannelFactory((Executor)Threads.lookup(Empyrean.class, WebServices.class), WebServices.clientWorkerPool(), StackConfiguration.CLIENT_POOL_MAX_THREADS.intValue());
            return nioClientSocketChannelFactory;
        }
    }

    public static Executor clientWorkerPool() {
        if (clientWorkerThreadPool != null) {
            return clientWorkerThreadPool;
        }
        try (LockResource resourceLock = LockResource.lock(clientResourceLock);){
            if (clientWorkerThreadPool != null) {
                Executor executor = clientWorkerThreadPool;
                return executor;
            }
            LOG.trace((Object)LogUtil.subheader("Creating client worker thread pool."));
            LOG.trace((Object)String.format("-> Pool threads:              %8d", StackConfiguration.CLIENT_POOL_MAX_THREADS));
            LOG.trace((Object)String.format("-> Pool timeout:              %8d ms", StackConfiguration.CLIENT_POOL_TIMEOUT_MILLIS));
            LOG.trace((Object)String.format("-> Max memory per connection: %8.2f MB", Float.valueOf((float)StackConfiguration.CLIENT_POOL_MAX_MEM_PER_CONN.longValue() / 1048576.0f)));
            LOG.trace((Object)String.format("-> Max total memory:          %8.2f MB", Float.valueOf((float)StackConfiguration.CLIENT_POOL_TOTAL_MEM.longValue() / 1048576.0f)));
            clientWorkerThreadPool = new OrderedMemoryAwareThreadPoolExecutor(StackConfiguration.CLIENT_POOL_MAX_THREADS.intValue(), StackConfiguration.CLIENT_POOL_MAX_MEM_PER_CONN.longValue(), StackConfiguration.CLIENT_POOL_TOTAL_MEM.longValue(), StackConfiguration.CLIENT_POOL_TIMEOUT_MILLIS.longValue(), TimeUnit.MILLISECONDS);
            OrderedMemoryAwareThreadPoolExecutor orderedMemoryAwareThreadPoolExecutor = clientWorkerThreadPool;
            return orderedMemoryAwareThreadPoolExecutor;
        }
    }

    public static synchronized void restart() {
        if (serverShutdown != null) {
            serverShutdown.run();
            serverShutdown = null;
        }
        Executor workerPool = WebServices.workerPool();
        NioServerSocketChannelFactory serverChannelFactory = WebServices.channelFactory(workerPool);
        final ChannelPipelineFactory serverPipelineFactory = Handlers.serverPipelineFactory();
        DefaultChannelGroup serverChannelGroup = WebServices.channelGroup();
        ChannelGroupChannelHandler channelGroupHandler = new ChannelGroupChannelHandler((ChannelGroup)serverChannelGroup);
        ChannelPipelineFactory pipelineFactory = new ChannelPipelineFactory((ChannelHandler)channelGroupHandler){
            final /* synthetic */ ChannelHandler val$channelGroupHandler;
            {
                this.val$channelGroupHandler = channelHandler;
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = serverPipelineFactory.getPipeline();
                pipeline.addLast("channel-group-handler", this.val$channelGroupHandler);
                return pipeline;
            }
        };
        ServerBootstrap bootstrap = WebServices.serverBootstrap((ChannelFactory)serverChannelFactory, pipelineFactory);
        List<Pair> internalAddressAndPorts = Arrays.asList(Pair.pair(Internets.localHostInetAddress(), StackConfiguration.INTERNAL_PORT), Pair.pair(Internets.loopback(), StackConfiguration.INTERNAL_PORT));
        LinkedHashSet listenerAddressAndPorts = Sets.newLinkedHashSet();
        listenerAddressAndPorts.addAll(internalAddressAndPorts);
        if (Bootstrap.isOperational().booleanValue()) {
            Iterables.addAll((Collection)listenerAddressAndPorts, (Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)Iterables.concat(Collections.singleton(Internets.any()), Internets.getAllInetAddresses()), (Predicate)Predicates.or(WebServices.parse(Cidr.parse(), StackConfiguration.LISTENER_ADDRESS_MATCH))), CollectionUtils.flipCurried(Pair.pair()).apply(StackConfiguration.PORT)));
        }
        if (listenerAddressAndPorts.contains(Pair.pair(Internets.any(), StackConfiguration.INTERNAL_PORT))) {
            listenerAddressAndPorts.removeAll(internalAddressAndPorts);
        }
        LOG.info((Object)("Starting web services listeners on " + Joiner.on((char)',').join(Iterables.transform((Iterable)listenerAddressAndPorts, Pair.left()))));
        for (Pair listenerAddressAndPort : listenerAddressAndPorts) {
            InetAddress address = (InetAddress)listenerAddressAndPort.getLeft();
            int port = (Integer)listenerAddressAndPort.getRight();
            try {
                Channel serverChannel = bootstrap.bind((SocketAddress)new InetSocketAddress(address, port));
                serverChannelGroup.add((Object)serverChannel);
            }
            catch (ChannelException ex) {
                LOG.error((Object)("Unable to bind web services listener " + address + ":" + port + ", port may be already in use."));
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
        try {
            serverShutdown = new Runnable((ChannelGroup)serverChannelGroup, (ChannelFactory)serverChannelFactory){
                AtomicBoolean ranned = new AtomicBoolean(false);
                final /* synthetic */ ChannelGroup val$serverChannelGroup;
                final /* synthetic */ ChannelFactory val$serverChannelFactory;
                {
                    this.val$serverChannelGroup = channelGroup;
                    this.val$serverChannelFactory = channelFactory;
                }

                @Override
                public void run() {
                    if (this.ranned.compareAndSet(false, true)) {
                        this.val$serverChannelGroup.close().awaitUninterruptibly();
                        this.val$serverChannelFactory.releaseExternalResources();
                    }
                }
            };
            OrderedShutdown.registerPreShutdownHook(serverShutdown);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }

    private static DefaultChannelGroup channelGroup() {
        return new DefaultChannelGroup(Empyrean.INSTANCE.getFullName() + ":" + WebServices.class.getSimpleName() + ":" + StackConfiguration.PORT);
    }

    private static ServerBootstrap serverBootstrap(ChannelFactory channelFactory, ChannelPipelineFactory serverPipelineFactory) {
        ServerBootstrap bootstrap = new ServerBootstrap(channelFactory);
        bootstrap.setPipelineFactory(serverPipelineFactory);
        if (!Logs.isExtrrreeeme()) {
            LOG.info((Object)"Creating server bootstrap. (log level EXTREME for details)");
        } else {
            LOG.trace((Object)LogUtil.subheader("Creating server boss thread pool."));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "child.tcpNoDelay", StackConfiguration.CHANNEL_NODELAY));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "child.keepAlive", StackConfiguration.CHANNEL_KEEP_ALIVE));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "child.reuseAddress", StackConfiguration.CHANNEL_REUSE_ADDRESS));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "child.connectTimeoutMillis", StackConfiguration.CHANNEL_CONNECT_TIMEOUT));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "tcpNoDelay", StackConfiguration.SERVER_CHANNEL_NODELAY));
            LOG.trace((Object)String.format("-> Server option: %25.25s = %s", "reuseAddress", StackConfiguration.SERVER_CHANNEL_REUSE_ADDRESS));
        }
        bootstrap.setOption("child.tcpNoDelay", (Object)StackConfiguration.CHANNEL_NODELAY);
        bootstrap.setOption("child.keepAlive", (Object)StackConfiguration.CHANNEL_KEEP_ALIVE);
        bootstrap.setOption("child.reuseAddress", (Object)StackConfiguration.CHANNEL_REUSE_ADDRESS);
        bootstrap.setOption("child.connectTimeoutMillis", (Object)StackConfiguration.CHANNEL_CONNECT_TIMEOUT);
        bootstrap.setOption("tcpNoDelay", (Object)StackConfiguration.SERVER_CHANNEL_NODELAY);
        bootstrap.setOption("reuseAddress", (Object)StackConfiguration.SERVER_CHANNEL_REUSE_ADDRESS);
        return bootstrap;
    }

    private static NioServerSocketChannelFactory channelFactory(Executor workerPool) {
        return new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), workerPool, StackConfiguration.SERVER_POOL_MAX_THREADS.intValue());
    }

    private static Executor workerPool() {
        if (!Logs.isExtrrreeeme()) {
            LOG.info((Object)"Creating server worker thread pool. (log level EXTREME for details)");
        } else {
            LOG.trace((Object)LogUtil.subheader("Creating server worker thread pool."));
            LOG.trace((Object)String.format("-> Pool threads:              %8d", StackConfiguration.SERVER_POOL_MAX_THREADS));
            LOG.trace((Object)String.format("-> Pool timeout:              %8d ms", StackConfiguration.SERVER_POOL_TIMEOUT_MILLIS));
            LOG.trace((Object)String.format("-> Max memory per connection: %8.2f MB", Float.valueOf((float)StackConfiguration.SERVER_POOL_MAX_MEM_PER_CONN.longValue() / 1048576.0f)));
            LOG.trace((Object)String.format("-> Max total memory:          %8.2f MB", Float.valueOf((float)StackConfiguration.SERVER_POOL_TOTAL_MEM.longValue() / 1048576.0f)));
        }
        OrderedMemoryAwareThreadPoolExecutor workerPool = new OrderedMemoryAwareThreadPoolExecutor(StackConfiguration.SERVER_POOL_MAX_THREADS.intValue(), StackConfiguration.SERVER_POOL_MAX_MEM_PER_CONN.longValue(), StackConfiguration.SERVER_POOL_TOTAL_MEM.longValue(), StackConfiguration.SERVER_POOL_TIMEOUT_MILLIS.longValue(), TimeUnit.MILLISECONDS);
        return workerPool;
    }

    private static Iterable<String> iterableFromList(String list) {
        return Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" ,\t\n\r")).omitEmptyStrings().trimResults().split((CharSequence)list);
    }

    public static boolean isSoapEnabled(Class<? extends ComponentId> component) {
        return !StackConfiguration.DISABLED_SOAP_API_COMPONENTS.equals("*") && !Iterables.contains((Iterable)Iterables.transform(WebServices.iterableFromList(StackConfiguration.DISABLED_SOAP_API_COMPONENTS), Strings.lower()), (Object)Components.lookup(component).getName());
    }

    public static class WebServicePropertiesChangedEventListener
    implements EventListener<Hertz> {
        private Integer CHANNEL_CONNECT_TIMEOUT = 500;
        private Boolean SERVER_CHANNEL_REUSE_ADDRESS = true;
        private Boolean SERVER_CHANNEL_NODELAY = true;
        private boolean CHANNEL_REUSE_ADDRESS = true;
        private Boolean CHANNEL_KEEP_ALIVE = true;
        private Boolean CHANNEL_NODELAY = true;
        private Integer SERVER_POOL_MAX_THREADS = 128;
        private Long SERVER_POOL_MAX_MEM_PER_CONN = 0L;
        private Long SERVER_POOL_TOTAL_MEM = 0L;
        private Long SERVER_POOL_TIMEOUT_MILLIS = 500L;
        private Integer SERVER_BOSS_POOL_MAX_THREADS = 128;
        private Long SERVER_BOSS_POOL_MAX_MEM_PER_CONN = 0L;
        private Long SERVER_BOSS_POOL_TOTAL_MEM = 0L;
        private Long SERVER_BOSS_POOL_TIMEOUT_MILLIS = 500L;
        private Integer PORT = 8773;
        private String LISTENER_ADDRESS_MATCH = "";
        private AtomicBoolean isRunning = new AtomicBoolean(false);

        public static void register() {
            Listeners.register(Hertz.class, new WebServicePropertiesChangedEventListener());
        }

        @Override
        public void fireEvent(Hertz event) {
            if (Bootstrap.isOperational().booleanValue() && event.isAsserted(60L) && this.isRunning.compareAndSet(false, true)) {
                String NEW_LISTENER_ADDRESS_MATCH;
                LOG.trace((Object)"Checking for updates to bootstrap.webservices properties");
                boolean different = false;
                Integer NEW_CHANNEL_CONNECT_TIMEOUT = StackConfiguration.CHANNEL_CONNECT_TIMEOUT;
                Boolean NEW_SERVER_CHANNEL_REUSE_ADDRESS = StackConfiguration.SERVER_CHANNEL_REUSE_ADDRESS;
                Boolean NEW_SERVER_CHANNEL_NODELAY = StackConfiguration.SERVER_CHANNEL_NODELAY;
                boolean NEW_CHANNEL_REUSE_ADDRESS = StackConfiguration.CHANNEL_REUSE_ADDRESS;
                Boolean NEW_CHANNEL_KEEP_ALIVE = StackConfiguration.CHANNEL_KEEP_ALIVE;
                Boolean NEW_CHANNEL_NODELAY = StackConfiguration.CHANNEL_NODELAY;
                Integer NEW_SERVER_POOL_MAX_THREADS = StackConfiguration.SERVER_POOL_MAX_THREADS;
                Long NEW_SERVER_POOL_MAX_MEM_PER_CONN = StackConfiguration.SERVER_POOL_MAX_MEM_PER_CONN;
                Long NEW_SERVER_POOL_TOTAL_MEM = StackConfiguration.SERVER_POOL_TOTAL_MEM;
                Long NEW_SERVER_POOL_TIMEOUT_MILLIS = StackConfiguration.SERVER_POOL_TIMEOUT_MILLIS;
                Integer NEW_SERVER_BOSS_POOL_MAX_THREADS = StackConfiguration.SERVER_BOSS_POOL_MAX_THREADS;
                Long NEW_SERVER_BOSS_POOL_MAX_MEM_PER_CONN = StackConfiguration.SERVER_BOSS_POOL_MAX_MEM_PER_CONN;
                Long NEW_SERVER_BOSS_POOL_TOTAL_MEM = StackConfiguration.SERVER_BOSS_POOL_TOTAL_MEM;
                Long NEW_SERVER_BOSS_POOL_TIMEOUT_MILLIS = StackConfiguration.SERVER_BOSS_POOL_TIMEOUT_MILLIS;
                Integer NEW_PORT = StackConfiguration.PORT;
                String string = NEW_LISTENER_ADDRESS_MATCH = Bootstrap.isOperational() != false ? StackConfiguration.LISTENER_ADDRESS_MATCH : "";
                if (!this.CHANNEL_CONNECT_TIMEOUT.equals(NEW_CHANNEL_CONNECT_TIMEOUT)) {
                    LOG.info((Object)("bootstrap.webservices.channel_connect_timeout has changed: oldValue = " + this.CHANNEL_CONNECT_TIMEOUT + ", newValue = " + NEW_CHANNEL_CONNECT_TIMEOUT));
                    this.CHANNEL_CONNECT_TIMEOUT = NEW_CHANNEL_CONNECT_TIMEOUT;
                    different = true;
                }
                if (this.SERVER_CHANNEL_REUSE_ADDRESS != NEW_SERVER_CHANNEL_REUSE_ADDRESS) {
                    LOG.info((Object)("bootstrap.webservices.server_channel_reuse_address has changed: oldValue = " + this.SERVER_CHANNEL_REUSE_ADDRESS + ", newValue = " + NEW_SERVER_CHANNEL_REUSE_ADDRESS));
                    this.SERVER_CHANNEL_REUSE_ADDRESS = NEW_SERVER_CHANNEL_REUSE_ADDRESS;
                    different = true;
                }
                if (this.SERVER_CHANNEL_NODELAY != NEW_SERVER_CHANNEL_NODELAY) {
                    LOG.info((Object)("bootstrap.webservices.server_channel_nodelay has changed: oldValue = " + this.SERVER_CHANNEL_NODELAY + ", newValue = " + NEW_SERVER_CHANNEL_NODELAY));
                    this.SERVER_CHANNEL_NODELAY = NEW_SERVER_CHANNEL_NODELAY;
                    different = true;
                }
                if (this.CHANNEL_REUSE_ADDRESS != NEW_CHANNEL_REUSE_ADDRESS) {
                    LOG.info((Object)("bootstrap.webservices.channel_reuse_address has changed: oldValue = " + this.CHANNEL_REUSE_ADDRESS + ", newValue = " + NEW_CHANNEL_REUSE_ADDRESS));
                    this.CHANNEL_REUSE_ADDRESS = NEW_CHANNEL_REUSE_ADDRESS;
                    different = true;
                }
                if (this.CHANNEL_KEEP_ALIVE != NEW_CHANNEL_KEEP_ALIVE) {
                    LOG.info((Object)("bootstrap.webservices.channel_keep_alive has changed: oldValue = " + this.CHANNEL_KEEP_ALIVE + ", newValue = " + NEW_CHANNEL_KEEP_ALIVE));
                    this.CHANNEL_KEEP_ALIVE = NEW_CHANNEL_KEEP_ALIVE;
                    different = true;
                }
                if (this.CHANNEL_NODELAY != NEW_CHANNEL_NODELAY) {
                    LOG.info((Object)("bootstrap.webservices.channel_nodelay has changed: oldValue = " + this.CHANNEL_NODELAY + ", newValue = " + NEW_CHANNEL_NODELAY));
                    this.CHANNEL_NODELAY = NEW_CHANNEL_NODELAY;
                    different = true;
                }
                if (!this.SERVER_POOL_MAX_THREADS.equals(NEW_SERVER_POOL_MAX_THREADS)) {
                    LOG.info((Object)("bootstrap.webservices.server_pool_max_threads has changed: oldValue = " + this.SERVER_POOL_MAX_THREADS + ", newValue = " + NEW_SERVER_POOL_MAX_THREADS));
                    this.SERVER_POOL_MAX_THREADS = NEW_SERVER_POOL_MAX_THREADS;
                    different = true;
                }
                if (!this.SERVER_POOL_MAX_MEM_PER_CONN.equals(NEW_SERVER_POOL_MAX_MEM_PER_CONN)) {
                    LOG.info((Object)("bootstrap.webservices.server_pool_max_mem_per_conn has changed: oldValue = " + this.SERVER_POOL_MAX_MEM_PER_CONN + ", newValue = " + NEW_SERVER_POOL_MAX_MEM_PER_CONN));
                    this.SERVER_POOL_MAX_MEM_PER_CONN = NEW_SERVER_POOL_MAX_MEM_PER_CONN;
                    different = true;
                }
                if (!this.SERVER_POOL_TOTAL_MEM.equals(NEW_SERVER_POOL_TOTAL_MEM)) {
                    LOG.info((Object)("bootstrap.webservices.server_pool_total_mem has changed: oldValue = " + this.SERVER_POOL_TOTAL_MEM + ", newValue = " + NEW_SERVER_POOL_TOTAL_MEM));
                    this.SERVER_POOL_TOTAL_MEM = NEW_SERVER_POOL_TOTAL_MEM;
                    different = true;
                }
                if (!this.SERVER_POOL_TIMEOUT_MILLIS.equals(NEW_SERVER_POOL_TIMEOUT_MILLIS)) {
                    LOG.info((Object)("bootstrap.webservices.server_pool_timeout_millis has changed: oldValue = " + this.SERVER_POOL_TIMEOUT_MILLIS + ", newValue = " + NEW_SERVER_POOL_TIMEOUT_MILLIS));
                    this.SERVER_POOL_TIMEOUT_MILLIS = NEW_SERVER_POOL_TIMEOUT_MILLIS;
                    different = true;
                }
                if (!this.SERVER_BOSS_POOL_MAX_THREADS.equals(NEW_SERVER_BOSS_POOL_MAX_THREADS)) {
                    LOG.info((Object)("bootstrap.webservices.server_boss_pool_max_threads has changed: oldValue = " + this.SERVER_BOSS_POOL_MAX_THREADS + ", newValue = " + NEW_SERVER_BOSS_POOL_MAX_THREADS));
                    this.SERVER_BOSS_POOL_MAX_THREADS = NEW_SERVER_BOSS_POOL_MAX_THREADS;
                    different = true;
                }
                if (!this.SERVER_BOSS_POOL_MAX_MEM_PER_CONN.equals(NEW_SERVER_BOSS_POOL_MAX_MEM_PER_CONN)) {
                    LOG.info((Object)("bootstrap.webservices.server_boss_pool_max_mem_per_conn has changed: oldValue = " + this.SERVER_BOSS_POOL_MAX_MEM_PER_CONN + ", newValue = " + NEW_SERVER_BOSS_POOL_MAX_MEM_PER_CONN));
                    this.SERVER_BOSS_POOL_MAX_MEM_PER_CONN = NEW_SERVER_BOSS_POOL_MAX_MEM_PER_CONN;
                    different = true;
                }
                if (!this.SERVER_BOSS_POOL_TOTAL_MEM.equals(NEW_SERVER_BOSS_POOL_TOTAL_MEM)) {
                    LOG.info((Object)("bootstrap.webservices.server_boss_pool_total_mem has changed: oldValue = " + this.SERVER_BOSS_POOL_TOTAL_MEM + ", newValue = " + NEW_SERVER_BOSS_POOL_TOTAL_MEM));
                    this.SERVER_BOSS_POOL_TOTAL_MEM = NEW_SERVER_BOSS_POOL_TOTAL_MEM;
                    different = true;
                }
                if (!this.SERVER_BOSS_POOL_TIMEOUT_MILLIS.equals(NEW_SERVER_BOSS_POOL_TIMEOUT_MILLIS)) {
                    LOG.info((Object)("bootstrap.webservices.server_boss_pool_timeout_millis has changed: oldValue = " + this.SERVER_BOSS_POOL_TIMEOUT_MILLIS + ", newValue = " + NEW_SERVER_BOSS_POOL_TIMEOUT_MILLIS));
                    this.SERVER_BOSS_POOL_TIMEOUT_MILLIS = NEW_SERVER_BOSS_POOL_TIMEOUT_MILLIS;
                    different = true;
                }
                if (!this.PORT.equals(NEW_PORT)) {
                    LOG.info((Object)("bootstrap.webservices.port has changed: oldValue = " + this.PORT + ", newValue = " + NEW_PORT));
                    this.PORT = NEW_PORT;
                    different = true;
                }
                if (!this.LISTENER_ADDRESS_MATCH.equals(NEW_LISTENER_ADDRESS_MATCH)) {
                    LOG.info((Object)("bootstrap.webservices.listener_address_match has changed: oldValue = " + this.LISTENER_ADDRESS_MATCH + ", newValue = " + NEW_LISTENER_ADDRESS_MATCH));
                    this.LISTENER_ADDRESS_MATCH = NEW_LISTENER_ADDRESS_MATCH;
                    different = true;
                }
                if (different) {
                    LOG.info((Object)"One or more bootstrap.webservices properties have changed, restarting web services listeners [May change ports]");
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                WebServices.restart();
                                LOG.info((Object)"Web services restart complete");
                            }
                            catch (Exception ex) {
                                LOG.error((Object)ex, (Throwable)ex);
                            }
                            finally {
                                WebServicePropertiesChangedEventListener.this.isRunning.set(false);
                            }
                        }
                    }.start();
                } else {
                    this.isRunning.set(false);
                    LOG.trace((Object)"No updates found to web services properties");
                }
            }
        }
    }

    public static class ComponentListPropertyChangeListener
    implements PropertyChangeListener {
        private static final Predicate<String> validComponentName = new Predicate<String>(){

            public boolean apply(@Nullable String value) {
                try {
                    ComponentIds.lookup(value);
                    return true;
                }
                catch (NoSuchElementException e) {
                    return false;
                }
            }
        };

        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (!"*".equals(String.valueOf(newValue)) && !Iterables.all((Iterable)WebServices.iterableFromList(String.valueOf(newValue)), validComponentName)) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
        }
    }

    public static class CheckBooleanPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue == null || !((String)newValue).equalsIgnoreCase("true") && !((String)newValue).equalsIgnoreCase("false")) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
        }
    }

    public static class CheckNonNegativeLongPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            long value;
            try {
                value = Long.parseLong((String)newValue);
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
            if (value < 0L) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
        }
    }

    public static class CheckNonNegativeIntegerPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            int value;
            try {
                value = Integer.parseInt((String)newValue);
            }
            catch (Exception ex) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
            if (value < 0) {
                throw new ConfigurablePropertyException("Invalid value " + newValue);
            }
        }
    }

    public static class CheckCidrListPropertyChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            if (newValue != null) {
                try {
                    WebServices.parse((Function<String, Optional<Cidr>>)Functions.compose(CollectionUtils.optionalUnit(), Cidr.parseUnsafe()), Objects.toString(newValue));
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigurablePropertyException(e.getMessage());
                }
            }
        }
    }

    @ChannelHandler.Sharable
    private static class ChannelGroupChannelHandler
    extends SimpleChannelHandler {
        private final ChannelGroup serverChannelGroup;

        public ChannelGroupChannelHandler(ChannelGroup serverChannelGroup) {
            this.serverChannelGroup = serverChannelGroup;
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            this.serverChannelGroup.add((Object)ctx.getChannel());
            super.channelOpen(ctx, e);
        }
    }

    @Provides(value=Empyrean.class)
    @RunDuring(value=Bootstrap.Stage.RemoteServicesInit)
    public static class WebServicesBootstrapper
    extends Bootstrapper.Simple {
        @Override
        public boolean load() throws Exception {
            WebServices.restart();
            return true;
        }

        @Override
        public boolean check() throws Exception {
            return super.check();
        }

        @Override
        public boolean stop() throws Exception {
            Handlers.pipelineExecutionHandler().releaseExternalResources();
            Handlers.serviceExecutionHandler().releaseExternalResources();
            return true;
        }

        static {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        }
    }
}

