/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.ws.TransportDefinition;
import com.eucalyptus.ws.WebServices;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="cloud_image_configuration")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="bootstrap.webservices", description="Parameters controlling the web services endpoint.")
public class StackConfiguration
extends AbstractPersistent {
    @ConfigurableField(description="Channel connect timeout (ms).", changeListener=WebServices.CheckNonNegativeIntegerPropertyChangeListener.class)
    public static Integer CHANNEL_CONNECT_TIMEOUT = 500;
    @ConfigurableField(changeListener=TimeChangeListener.class, description="Time interval duration (in seconds) during which duplicate signatures will be accepted to accomodate collisions for legitimate requests inherent in Query/REST signing protocol.")
    public static Integer REPLAY_SKEW_WINDOW_SEC = 3;
    @ConfigurableField(description="A max clock skew value (in seconds) between client and server accepted when validating timestamps in Query/REST protocol.", changeListener=TimeChangeListener.class)
    public static Integer CLOCK_SKEW_SEC = 20;
    @ConfigurableField(description="Server socket reuse address.", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static final Boolean SERVER_CHANNEL_REUSE_ADDRESS = true;
    @ConfigurableField(description="Server socket TCP_NODELAY.", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static final Boolean SERVER_CHANNEL_NODELAY = true;
    @ConfigurableField(description="Socket reuse address.", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static final Boolean CHANNEL_REUSE_ADDRESS = true;
    @ConfigurableField(description="Socket keep alive.", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static final Boolean CHANNEL_KEEP_ALIVE = true;
    @ConfigurableField(description="Server socket TCP_NODELAY.", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static final Boolean CHANNEL_NODELAY = true;
    @ConfigurableField(description="Server worker thread pool max.", changeListener=WebServices.CheckNonNegativeIntegerPropertyChangeListener.class)
    public static Integer SERVER_POOL_MAX_THREADS = 128;
    @ConfigurableField(description="Server max worker memory per connection.", changeListener=WebServices.CheckNonNegativeLongPropertyChangeListener.class)
    public static Long SERVER_POOL_MAX_MEM_PER_CONN = 0L;
    @ConfigurableField(description="Server max worker memory total.", changeListener=WebServices.CheckNonNegativeIntegerPropertyChangeListener.class)
    public static Long SERVER_POOL_TOTAL_MEM = 0L;
    @ConfigurableField(description="Service socket select timeout (ms).", changeListener=WebServices.CheckNonNegativeLongPropertyChangeListener.class)
    public static Long SERVER_POOL_TIMEOUT_MILLIS = 500L;
    @ConfigurableField(description="Server selector thread pool max.", changeListener=WebServices.CheckNonNegativeIntegerPropertyChangeListener.class)
    public static Integer SERVER_BOSS_POOL_MAX_THREADS = 128;
    @ConfigurableField(description="Server max selector memory per connection.", changeListener=WebServices.CheckNonNegativeLongPropertyChangeListener.class)
    public static Long SERVER_BOSS_POOL_MAX_MEM_PER_CONN = 0L;
    @ConfigurableField(description="Server worker thread pool max.", changeListener=WebServices.CheckNonNegativeLongPropertyChangeListener.class)
    public static Long SERVER_BOSS_POOL_TOTAL_MEM = 0L;
    @ConfigurableField(description="Service socket select timeout (ms).", changeListener=WebServices.CheckNonNegativeLongPropertyChangeListener.class)
    public static Long SERVER_BOSS_POOL_TIMEOUT_MILLIS = 500L;
    @ConfigurableField(description="Port to bind (note: port 8773 is always bound regardless).", changeListener=WebServices.CheckNonNegativeIntegerPropertyChangeListener.class)
    public static Integer PORT = 8773;
    public static final Integer INTERNAL_PORT = 8773;
    @ConfigurableField(description="CIDRs matching addresses to bind on (note: default interface is always bound regardless).", initial="0.0.0.0", changeListener=WebServices.CheckCidrListPropertyChangeListener.class)
    public static volatile String LISTENER_ADDRESS_MATCH = "0.0.0.0";
    @ConfigurableField(description="Record and report service times.")
    public static Boolean STATISTICS = Boolean.FALSE;
    @ConfigurableField(description="Execute service specific pipeline handlers from a separate thread pool (with respect to I/O).")
    public static Boolean ASYNC_PIPELINE = Boolean.FALSE;
    @ConfigurableField(description="Execute service operations from a separate thread pool (with respect to I/O).")
    public static Boolean ASYNC_OPERATIONS = Boolean.FALSE;
    @ConfigurableField(description="Execute internal service operations from a separate thread pool (with respect to I/O).")
    public static Boolean ASYNC_INTERNAL_OPERATIONS = Boolean.FALSE;
    @ConfigurableField(description="Execute internal service operations out of band from the normal service bus.")
    public static Boolean OOB_INTERNAL_OPERATIONS = Boolean.TRUE;
    @ConfigurableField(description="Client idle timeout (secs).")
    public static Long CLIENT_IDLE_TIMEOUT_SECS = 30L;
    @ConfigurableField(description="Client idle timeout (secs).")
    public static Integer CLIENT_INTERNAL_TIMEOUT_SECS = 60;
    @ConfigurableField(description="Cluster connect timeout (ms).")
    public static Long CLUSTER_CONNECT_TIMEOUT_MILLIS = 2000L;
    @ConfigurableField(description="Server socket idle time-out.")
    public static Integer PIPELINE_IDLE_TIMEOUT_SECONDS = 60;
    @ConfigurableField(description="Server http chunk max.")
    public static Integer CLIENT_HTTP_CHUNK_BUFFER_MAX = 1048576000;
    @ConfigurableField(description="Server worker thread pool max.")
    public static Integer CLIENT_POOL_MAX_THREADS = 40;
    @ConfigurableField(description="Server worker thread pool max.")
    public static Long CLIENT_POOL_MAX_MEM_PER_CONN = 0L;
    @ConfigurableField(description="Server worker thread pool max.")
    public static Long CLIENT_POOL_TOTAL_MEM = 0L;
    @ConfigurableField(description="Client socket select timeout (ms).")
    public static Long CLIENT_POOL_TIMEOUT_MILLIS = 500L;
    @ConfigurableField(description="Maximum HTTP chunk size (bytes).")
    public static Integer HTTP_MAX_CHUNK_BYTES = 102400;
    @ConfigurableField(description="Maximum HTTP initial line size (bytes).")
    public static Integer HTTP_MAX_INITIAL_LINE_BYTES = 4096;
    @ConfigurableField(description="Maximum HTTP headers size (bytes).")
    public static Integer HTTP_MAX_HEADER_BYTES = 8192;
    @ConfigurableField(description="Use DNS delegation for eucarc.")
    @Deprecated
    public static Boolean USE_DNS_DELEGATION = Boolean.FALSE;
    @ConfigurableField(description="Use DNS names for instances.")
    @Deprecated
    public static Boolean USE_INSTANCE_DNS = Boolean.FALSE;
    @ConfigurableField(description="Default scheme prefix in eucarc.", changeListener=TemporarySchemeUpdater.class)
    @Deprecated
    public static Boolean DEFAULT_HTTPS_ENABLED = Boolean.FALSE;
    @ConfigurableField(description="Default scheme for EC2_URL in eucarc.", changeListener=UriChangeListener.class)
    @Deprecated
    public static String DEFAULT_EC2_URI_SCHEME = "http";
    @ConfigurableField(description="Default scheme for S3_URL in eucarc.", changeListener=UriChangeListener.class)
    @Deprecated
    public static String DEFAULT_S3_URI_SCHEME = "http";
    @ConfigurableField(description="Default scheme for AWS_SNS_URL in eucarc.", changeListener=UriChangeListener.class)
    @Deprecated
    public static String DEFAULT_AWS_SNS_URI_SCHEME = "http";
    @ConfigurableField(description="Default scheme for EUARE_URL in eucarc.", changeListener=UriChangeListener.class)
    @Deprecated
    public static String DEFAULT_EUARE_URI_SCHEME = "http";
    @ConfigurableField(description="Default EUSTORE_URL in eucarc.", changeListener=UriChangeListener.class)
    @Deprecated
    public static String DEFAULT_EUSTORE_URL = "http://emis.eucalyptus.com/";
    @ConfigurableField(description="Request unknown parameter handling (default|ignore|error).")
    public static String UNKNOWN_PARAMETER_HANDLING = "default";
    @ConfigurableField(description="Enable request logging.", initial="true", changeListener=WebServices.CheckBooleanPropertyChangeListener.class)
    public static volatile Boolean LOG_REQUESTS = true;
    @ConfigurableField(description="List of services with disabled SOAP APIs.", initial="", changeListener=WebServices.ComponentListPropertyChangeListener.class)
    public static volatile String DISABLED_SOAP_API_COMPONENTS = "";
    private static Logger LOG = Logger.getLogger(StackConfiguration.class);

    @Deprecated
    public static String lookupDnsDomain() {
        return SystemConfiguration.getSystemConfiguration().getDnsDomain();
    }

    public static class UriChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            String prefix = null;
            if (newValue instanceof String && ("http".equals(prefix = (String)newValue) || "https".equals(prefix))) {
                return;
            }
            try {
                URL uRL = new URL((String)newValue);
            }
            catch (MalformedURLException e) {
                throw new ConfigurablePropertyException("Invalid URL or URL prefix: " + t.getFieldName() + e);
            }
        }
    }

    public static class TemporarySchemeUpdater
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            String scheme;
            DEFAULT_EUARE_URI_SCHEME = DEFAULT_S3_URI_SCHEME = (scheme = Boolean.TRUE.equals(Boolean.parseBoolean("" + newValue)) ? "https" : "http");
            DEFAULT_EC2_URI_SCHEME = DEFAULT_S3_URI_SCHEME;
            DEFAULT_AWS_SNS_URI_SCHEME = DEFAULT_S3_URI_SCHEME;
        }
    }

    public static class TimeChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            int time = -1;
            try {
                if (newValue instanceof String) {
                    time = Integer.parseInt((String)newValue);
                }
            }
            catch (NumberFormatException e) {
                LOG.debug((Object)("Failed to parse int from " + newValue));
            }
            if (time < 0) {
                throw new ConfigurablePropertyException("An integer >= 0 is expected for " + t.getFieldName());
            }
        }
    }

    public static enum BasicTransport implements TransportDefinition
    {
        HTTP{

            @Override
            public String getScheme() {
                return "http";
            }

            @Override
            public String getSecureScheme() {
                return "https";
            }
        }
        ,
        JMX{

            @Override
            public String getSecureScheme() {
                return this.getScheme();
            }

            @Override
            public String getScheme() {
                return "service:jmx:rmi:///jndi/rmi://";
            }
        }
        ,
        JDBC{

            @Override
            public String getSecureScheme() {
                return this.getScheme();
            }

            @Override
            public String getScheme() {
                return Databases.getJdbcScheme();
            }
        };


        @Override
        public abstract String getScheme();

        @Override
        public abstract String getSecureScheme();
    }
}

