/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.ws;

import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.binding.BindingManager;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.ComponentMessages;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceOperations;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceStateException;
import com.eucalyptus.crypto.util.SslSetup;
import com.eucalyptus.empyrean.ServiceTransitionType;
import com.eucalyptus.http.MappingHttpMessage;
import com.eucalyptus.http.MappingHttpRequest;
import com.eucalyptus.http.MappingHttpResponse;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.async.AsyncRequestHandler;
import com.eucalyptus.ws.StackConfiguration;
import com.eucalyptus.ws.WebServicesException;
import com.eucalyptus.ws.handlers.BindingHandler;
import com.eucalyptus.ws.handlers.InternalWsSecHandler;
import com.eucalyptus.ws.handlers.QueryTimestampHandler;
import com.eucalyptus.ws.handlers.SoapMarshallingHandler;
import com.eucalyptus.ws.handlers.http.HttpUtils;
import com.eucalyptus.ws.handlers.http.NioHttpDecoder;
import com.eucalyptus.ws.protocol.AddressingHandler;
import com.eucalyptus.ws.protocol.SoapHandler;
import com.eucalyptus.ws.server.NioServerHandler;
import com.eucalyptus.ws.server.ServiceAccessLoggingHandler;
import com.eucalyptus.ws.server.ServiceContextHandler;
import com.eucalyptus.ws.server.ServiceHackeryHandler;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMessageEncoder;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;

public class Handlers {
    private static Logger LOG = Logger.getLogger(Handlers.class);
    private static final ExecutionHandler pipelineExecutionHandler = new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(StackConfiguration.SERVER_POOL_MAX_THREADS.intValue(), 0L, 0L));
    private static final ExecutionHandler serviceExecutionHandler = new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(StackConfiguration.SERVER_POOL_MAX_THREADS.intValue(), 0L, 0L));
    private static final ChannelHandler queryTimestampHandler = new QueryTimestampHandler();
    private static final ChannelHandler soapMarshallingHandler = new SoapMarshallingHandler();
    private static final ChannelHandler httpRequestEncoder = new NioHttpRequestEncoder();
    private static final ChannelHandler internalWsSecHandler = new InternalWsSecHandler();
    private static final ChannelHandler soapHandler = new SoapHandler();
    private static final ChannelHandler addressingHandler = new AddressingHandler();
    private static final ChannelHandler bindingHandler = new BindingHandler(BindingManager.getDefaultBinding());
    private static final HashedWheelTimer timer = new HashedWheelTimer(){
        {
            this.start();
        }
    };
    public static final Map<String, ChannelHandler> extraMonitors = Maps.newConcurrentMap();
    private static final LoadingCache<String, BindingHandler> bindingHandlers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, BindingHandler>(){

        public BindingHandler load(String bindingName) {
            String maybeBindingName = "";
            if (BindingManager.isRegisteredBinding(bindingName)) {
                return new BindingHandler(BindingManager.getBinding(bindingName));
            }
            maybeBindingName = BindingManager.sanitizeNamespace(bindingName);
            if (BindingManager.isRegisteredBinding(maybeBindingName)) {
                return new BindingHandler(BindingManager.getBinding(maybeBindingName));
            }
            throw Exceptions.trace("Failed to find registerd binding for name: " + bindingName + ".  Also tried looking for sanitized name: " + maybeBindingName);
        }
    });

    private static NioServerHandler newNioServerHandler() {
        return new NioServerHandler();
    }

    private static ChannelHandler newChunkedWriteHandler() {
        return new ChunkedWriteHandler();
    }

    private static ChannelHandler newHttpResponseEncoder() {
        return new HttpResponseEncoder();
    }

    private static ChannelHandler newHttpDecoder() {
        return new NioHttpDecoder();
    }

    public static ChannelPipelineFactory serverPipelineFactory() {
        return ServerPipelineFactory.INSTANCE;
    }

    public static ChannelHandler bootstrapFence() {
        return BootstrapStateCheck.INSTANCE;
    }

    public static Map<String, ChannelHandler> channelMonitors(final TimeUnit unit, final int timeout) {
        return new HashMap<String, ChannelHandler>(2 + extraMonitors.size()){
            {
                super(x0);
                this.put("idlehandler", new IdleStateHandler((Timer)timer, 0L, 0L, (long)timeout, unit));
                this.put("idlecloser", new IdleStateAwareChannelHandler(){

                    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
                        if (e.getState() == IdleState.ALL_IDLE) {
                            e.getChannel().close();
                        }
                    }
                });
                this.putAll(extraMonitors);
            }
        };
    }

    public static ChannelHandler newSslHandler() {
        return new NioSslHandler();
    }

    public static ChannelHandler newHttpResponseDecoder() {
        return new NioHttpResponseDecoder();
    }

    public static ChannelHandler newHttpChunkAggregator() {
        return new HttpChunkAggregator(StackConfiguration.CLIENT_HTTP_CHUNK_BUFFER_MAX.intValue());
    }

    public static ChannelHandler addressingHandler() {
        return addressingHandler;
    }

    public static ChannelHandler newAddressingHandler(String addressingPrefix) {
        return new AddressingHandler(addressingPrefix);
    }

    public static ChannelHandler bindingHandler() {
        return bindingHandler;
    }

    public static ChannelHandler bindingHandler(String bindingName) {
        return (ChannelHandler)bindingHandlers.getUnchecked((Object)bindingName);
    }

    public static ChannelHandler httpRequestEncoder() {
        return httpRequestEncoder;
    }

    public static ChannelHandler soapMarshalling() {
        return soapMarshallingHandler;
    }

    public static ChannelHandler soapHandler() {
        return soapHandler;
    }

    public static ChannelHandler internalServiceStateHandler() {
        return ServiceStateChecksHandler.INSTANCE;
    }

    public static ChannelHandler internalEpochHandler() {
        return MessageEpochChecks.INSTANCE;
    }

    static void sendRedirect(ChannelHandlerContext ctx, ChannelEvent e, Class<? extends ComponentId> compClass, MappingHttpRequest request) {
        URI serviceUri;
        e.getFuture().cancel();
        String redirectUri = null;
        if (Topology.isEnabled(compClass)) {
            serviceUri = ServiceUris.remote(Topology.lookup(compClass, new Partition[0]), new String[0]);
            redirectUri = serviceUri.toASCIIString() + request.getServicePath().replace(serviceUri.getPath(), "");
        } else if (Topology.isEnabled(Eucalyptus.class)) {
            serviceUri = ServiceUris.remote(Topology.lookup(Eucalyptus.class, new Partition[0]), new String[0]);
            redirectUri = serviceUri.toASCIIString().replace(Eucalyptus.INSTANCE.getServicePath(new String[0]), "") + request.getServicePath().replace(serviceUri.getPath(), "");
        }
        DefaultHttpResponse response = null;
        if (redirectUri == null || Handlers.isRedirectLoop(request, redirectUri)) {
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SERVICE_UNAVAILABLE);
            if (Logs.isDebug()) {
                String errorMessage = "Failed to lookup service for " + Components.lookup(compClass).getName() + " for path " + request.getServicePath() + ".\nCurrent state: \n\t" + Joiner.on((String)"\n\t").join(Topology.enabledServices());
                byte[] errorBytes = Exceptions.string(new ServiceStateException(errorMessage)).getBytes();
                response.setContent(ChannelBuffers.wrappedBuffer((byte[])errorBytes));
            }
        } else {
            response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TEMPORARY_REDIRECT);
            if (request.getQuery() != null) {
                redirectUri = redirectUri + "?" + request.getQuery();
            }
            response.setHeader("Location", (Object)redirectUri);
        }
        response.setHeader("Connection", (Object)"close");
        if (ctx.getChannel().isConnected()) {
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public static ChannelHandler internalOnlyHandler() {
        return InternalOnlyHandler.INSTANCE;
    }

    public static void addComponentHandlers(Class<? extends ComponentId> componentIdClass, ChannelPipeline pipeline) {
        pipeline.addLast("msg-component-check", (ChannelHandler)new ComponentMessageCheckHandler(componentIdClass));
    }

    public static void addSystemHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("service-state-check", Handlers.internalServiceStateHandler());
        pipeline.addLast("service-specific-mangling", (ChannelHandler)ServiceHackeryHandler.INSTANCE);
        if (StackConfiguration.ASYNC_OPERATIONS.booleanValue()) {
            pipeline.addLast("async-operations-execution-handler", (ChannelHandler)Handlers.serviceExecutionHandler());
        }
        pipeline.addLast("service-request-handler", (ChannelHandler)ServiceAccessLoggingHandler.INSTANCE);
        pipeline.addLast("service-sink", (ChannelHandler)new ServiceContextHandler());
    }

    public static void addInternalSystemHandlers(ChannelPipeline pipeline) {
        pipeline.addLast("internal-only-restriction", Handlers.internalOnlyHandler());
        pipeline.addLast("msg-epoch-check", Handlers.internalEpochHandler());
    }

    public static ExecutionHandler pipelineExecutionHandler() {
        return pipelineExecutionHandler;
    }

    public static ExecutionHandler serviceExecutionHandler() {
        return serviceExecutionHandler;
    }

    public static ChannelHandler queryTimestamphandler() {
        return queryTimestampHandler;
    }

    public static ChannelHandler internalWsSecHandler() {
        return internalWsSecHandler;
    }

    private static boolean isRedirectLoop(MappingHttpRequest request, String uri) {
        String requestHost = request.getHeader("Host");
        String requestPath = request.getServicePath();
        return requestHost != null && requestPath != null && uri.contains(requestHost + requestPath);
    }

    private static boolean isImpersonationSupported(BaseMessage message) {
        ComponentMessage componentMessage;
        boolean impersonationSupported = false;
        ComponentMessage componentMessage2 = componentMessage = message == null ? null : Ats.inClassHierarchy(message.getClass()).get(ComponentMessage.class);
        if (componentMessage != null) {
            impersonationSupported = ComponentIds.lookup(componentMessage.value()).isImpersonationSupported();
        }
        return impersonationSupported;
    }

    @ChannelHandler.Sharable
    static enum InternalOnlyHandler implements ChannelUpstreamHandler
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         */
        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            Object request = MappingHttpMessage.extractMessage(e);
            Object msg = BaseMessage.extractMessage(e);
            if (request != null && msg != null) {
                Context context = Contexts.lookup(((MappingHttpMessage)((Object)request)).getCorrelationId());
                User user = context.getUser();
                AuthContextSupplier userContext = context.getAuthContext();
                if (user.isSystemAdmin() || context.isImpersonated() && Handlers.isImpersonationSupported(msg) || (user.isSystemUser() || ServiceOperations.isUserOperation(msg)) && Permissions.isAuthorized(RestrictedTypes.findPolicyVendor(msg.getClass()), "", "", null, RestrictedTypes.getIamActionByMessageType(msg), userContext)) {
                    ctx.sendUpstream(e);
                    return;
                }
                Contexts.clear(Contexts.lookup(((BaseMessage)msg).getCorrelationId()));
                throw new WebServicesException(HttpResponseStatus.FORBIDDEN);
            }
            ctx.sendUpstream(e);
        }
    }

    @ChannelHandler.Sharable
    static enum SocketLoggingHandler implements Runnable,
    ChannelUpstreamHandler,
    ChannelDownstreamHandler
    {
        INSTANCE;

        private final Joiner.MapJoiner joiner = Joiner.on((char)' ').useForNull("null").withKeyValueSeparator(":");
        private final Maps.EntryTransformer<String, Object, Object> transformer = new Maps.EntryTransformer<String, Object, Object>(){

            public Object transformEntry(@Nullable String key, @Nullable Object value) {
                if (key.startsWith("time.")) {
                    return new Date((Long)value).toString();
                }
                if (key.startsWith("silent")) {
                    return "";
                }
                return "" + value;
            }
        };
        private final Object NULLPROXY = new Object();
        private static final ConcurrentMap<Channel, ConcurrentMap<String, Object>> channelDetails;

        private SocketLoggingHandler() {
            Threads.newThread(this, "Socket Monitoring");
        }

        @Override
        public void run() {
            while (!Bootstrap.isShuttingDown().booleanValue()) {
                try {
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (InterruptedException e) {
                    return;
                }
                for (Map info : channelDetails.values()) {
                    LOG.info((Object)this.joiner.join(info));
                }
            }
        }

        public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            try {
                ConcurrentMap<String, Object> info = this.getChannelInfo(ctx);
                if (e instanceof ChannelStateEvent) {
                    this.downstreamChannelStateEvent((ChannelStateEvent)e, info);
                }
            }
            catch (Exception e1) {
                LOG.debug((Object)e1);
            }
            ctx.sendDownstream(e);
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            try {
                ConcurrentMap<String, Object> info = this.getChannelInfo(ctx);
                if (e instanceof ChannelStateEvent) {
                    this.upstreamChannelStateEvent((ChannelStateEvent)e, info);
                }
                if (ctx.getPipeline().getLast() instanceof AsyncRequestHandler) {
                    AsyncRequestHandler requestHandler = (AsyncRequestHandler)ctx.getPipeline().getLast();
                    info.putIfAbsent("pipeline", ctx.getPipeline().getClass());
                    info.putIfAbsent("silent.requesthandler", requestHandler);
                    if (requestHandler != null && requestHandler.getRequest() != null && requestHandler.getRequest().get() != null) {
                        info.putIfAbsent("request.message", Objects.firstNonNull(requestHandler.getRequest().get(), (Object)this.NULLPROXY).getClass());
                    }
                } else if (e instanceof ExceptionEvent) {
                    info.putIfAbsent("exception", ((ExceptionEvent)e).getCause());
                } else if (e instanceof MessageEvent) {
                    Object message = Objects.firstNonNull((Object)((MessageEvent)e).getMessage(), (Object)this.NULLPROXY);
                    info.putIfAbsent("silent.request", message);
                    info.putIfAbsent("request.type", message.getClass());
                }
            }
            catch (Exception e1) {
                LOG.debug((Object)e1);
            }
            ctx.sendUpstream(e);
        }

        private ConcurrentMap<String, Object> getChannelInfo(ChannelHandlerContext ctx) {
            ConcurrentMap info = channelDetails.putIfAbsent(ctx.getChannel(), Maps.newConcurrentMap());
            info = info == null ? (ConcurrentMap)channelDetails.get(ctx.getChannel()) : info;
            info.putIfAbsent("time.start", System.currentTimeMillis());
            return info;
        }

        private void downstreamChannelStateEvent(ChannelStateEvent e, Map<String, Object> info) {
            ChannelStateEvent stateEvent = e;
            ChannelState state = stateEvent.getState();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(stateEvent.getValue())) break;
                    info.put("time.close-requested", System.currentTimeMillis());
                    break;
                }
                case BOUND: {
                    SocketAddress addr = (SocketAddress)stateEvent.getValue();
                    if (addr != null) {
                        info.put("address.local-specified", addr);
                        info.put("time.bind-requested", System.currentTimeMillis());
                        break;
                    }
                    info.put("time.unbind-requested", System.currentTimeMillis());
                    break;
                }
                case CONNECTED: {
                    SocketAddress addr = (SocketAddress)stateEvent.getValue();
                    if (addr != null) {
                        info.put("address.local-specified", addr);
                        info.put("time.connect-requested", System.currentTimeMillis());
                        break;
                    }
                    info.put("time.disconnect-requested", System.currentTimeMillis());
                    break;
                }
            }
        }

        private void upstreamChannelStateEvent(ChannelStateEvent e, Map<String, Object> info) {
            ChannelStateEvent stateEvent = e;
            ChannelState state = stateEvent.getState();
            switch (state) {
                case OPEN: {
                    if (Boolean.TRUE.equals(stateEvent.getValue())) {
                        info.put("time.opened", System.currentTimeMillis());
                        break;
                    }
                    info.put("time.closed", System.currentTimeMillis());
                    channelDetails.remove(e.getChannel());
                    Map transformed = Maps.transformEntries(info, this.transformer);
                    LOG.info((Object)(e.getChannel().getId() + ": " + Joiner.on((String)" ").withKeyValueSeparator("=").join(transformed)));
                    break;
                }
                case BOUND: {
                    SocketAddress addr = (SocketAddress)stateEvent.getValue();
                    if (addr != null) {
                        info.put("address.local", addr);
                        info.put("time.bound", System.currentTimeMillis());
                        break;
                    }
                    info.put("time.unbound", System.currentTimeMillis());
                    break;
                }
                case CONNECTED: {
                    SocketAddress addr = (SocketAddress)stateEvent.getValue();
                    if (addr != null) {
                        info.put("address.local", addr);
                        info.put("time.connected", System.currentTimeMillis());
                        break;
                    }
                    info.put("time.disconnected", System.currentTimeMillis());
                    break;
                }
            }
        }

        static {
            channelDetails = Maps.newConcurrentMap();
        }
    }

    private static final class ComponentMessageCheckHandler
    implements ChannelUpstreamHandler {
        @Nullable
        private final Class<? extends ComponentId> componentIdClass;

        private ComponentMessageCheckHandler(Class<? extends ComponentId> componentIdClass) {
            this.componentIdClass = componentIdClass;
        }

        public void handleUpstream(ChannelHandlerContext channelHandlerContext, ChannelEvent channelEvent) throws Exception {
            if (channelEvent instanceof MessageEvent && this.componentIdClass != null) {
                ComponentMessage componentMessage;
                Object message = BaseMessage.extractMessage(channelEvent);
                ComponentMessage componentMessage2 = componentMessage = message == null ? null : Ats.inClassHierarchy(message.getClass()).get(ComponentMessage.class);
                if (!(message == null || componentMessage != null && this.componentIdClass.equals(componentMessage.value()))) {
                    LOG.warn((Object)String.format("Message %s does not match pipeline component %s", message.getClass(), this.componentIdClass.getSimpleName()));
                    Object baseMessage = BaseMessage.extractMessage(channelEvent);
                    if (baseMessage != null) {
                        Contexts.clear(Contexts.lookup(((BaseMessage)baseMessage).getCorrelationId()));
                    }
                    throw new WebServicesException(HttpResponseStatus.FORBIDDEN);
                }
            }
            channelHandlerContext.sendUpstream(channelEvent);
        }
    }

    @ChannelHandler.Sharable
    static enum MessageEpochChecks implements ChannelUpstreamHandler
    {
        INSTANCE{

            public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
                MappingHttpRequest request = (MappingHttpRequest)((Object)MappingHttpMessage.extractMessage(e));
                Object msg = BaseMessage.extractMessage(e);
                if (msg != null) {
                    try {
                        if (msg instanceof ServiceTransitionType && !Hosts.isCoordinator()) {
                            Topology.touch((ServiceTransitionType)msg);
                            ctx.sendUpstream(e);
                        } else if (Topology.check(msg)) {
                            ctx.sendUpstream(e);
                        } else {
                            Class<ComponentId> compClass = ComponentMessages.lookup(msg);
                            Handlers.sendRedirect(ctx, e, compClass, request);
                        }
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        ctx.sendUpstream(e);
                    }
                }
            }
        };

    }

    @ChannelHandler.Sharable
    public static enum ServiceStateChecksHandler implements ChannelUpstreamHandler
    {
        INSTANCE{

            public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
                block6: {
                    MappingHttpRequest request = (MappingHttpRequest)((Object)MappingHttpMessage.extractMessage(e));
                    Object msg = BaseMessage.extractMessage(e);
                    if (msg != null) {
                        try {
                            Class<ComponentId> compClass = ComponentMessages.lookup(msg);
                            ComponentId compId = ComponentIds.lookup(compClass);
                            if (compId.isAlwaysLocal().booleanValue() || Topology.isEnabledLocally(compClass)) {
                                ctx.sendUpstream(e);
                                break block6;
                            }
                            Handlers.sendRedirect(ctx, e, compClass, request);
                        }
                        catch (NoSuchElementException ex) {
                            LOG.warn((Object)("Failed to find reverse component mapping for message type: " + msg.getClass()));
                            ctx.sendUpstream(e);
                        }
                        catch (Exception ex) {
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            ctx.sendUpstream(e);
                        }
                    } else {
                        ctx.sendUpstream(e);
                    }
                }
            }
        };

    }

    private static class NioSslHandler
    extends SslHandler {
        private final AtomicBoolean first = new AtomicBoolean(true);
        private static List<String> httpVerbPrefix = Lists.newArrayList((Object[])new String[]{HttpMethod.CONNECT.getName().substring(0, 3), HttpMethod.GET.getName().substring(0, 3), HttpMethod.PUT.getName().substring(0, 3), HttpMethod.POST.getName().substring(0, 3), HttpMethod.HEAD.getName().substring(0, 3), HttpMethod.OPTIONS.getName().substring(0, 3), HttpMethod.DELETE.getName().substring(0, 3), HttpMethod.TRACE.getName().substring(0, 3)});

        NioSslHandler() {
            super(SslSetup.getServerEngine());
        }

        private static boolean maybeSsl(ChannelBuffer buffer) {
            buffer.markReaderIndex();
            StringBuffer sb = new StringBuffer();
            int lineLength = 0;
            while (lineLength++ < 3) {
                sb.append((char)buffer.readByte());
            }
            buffer.resetReaderIndex();
            return !httpVerbPrefix.contains(sb.toString());
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            Object o = null;
            if (e instanceof MessageEvent && this.first.compareAndSet(true, false) && (o = ((MessageEvent)e).getMessage()) instanceof ChannelBuffer && !NioSslHandler.maybeSsl((ChannelBuffer)o)) {
                ctx.getPipeline().removeFirst();
                ctx.sendUpstream(e);
            } else if (!(e instanceof MessageEvent)) {
                ctx.sendUpstream(e);
            } else {
                super.handleUpstream(ctx, e);
            }
        }
    }

    @ChannelHandler.Sharable
    static enum BootstrapStateCheck implements ChannelUpstreamHandler
    {
        INSTANCE;


        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (!Bootstrap.isFinished().booleanValue()) {
                ctx.sendUpstream(e);
            } else {
                ctx.sendUpstream(e);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class NioHttpRequestEncoder
    extends HttpMessageEncoder {
        protected void encodeInitialLine(ChannelBuffer buf, HttpMessage message) throws Exception {
            MappingHttpRequest request = (MappingHttpRequest)message;
            buf.writeBytes(request.getMethod().toString().getBytes("ASCII"));
            buf.writeByte(32);
            buf.writeBytes(request.getServicePath().getBytes("ASCII"));
            buf.writeByte(32);
            buf.writeBytes(request.getProtocolVersion().toString().getBytes("ASCII"));
            buf.writeBytes(HttpUtils.CRLF);
        }
    }

    public static class NioHttpResponseDecoder
    extends HttpResponseDecoder {
        protected HttpMessage createMessage(String[] strings) {
            return new MappingHttpResponse(strings);
        }
    }

    static enum ServerPipelineFactory implements ChannelPipelineFactory
    {
        INSTANCE;


        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("ssl", Handlers.newSslHandler());
            for (Map.Entry<String, ChannelHandler> e : Handlers.channelMonitors(TimeUnit.SECONDS, StackConfiguration.PIPELINE_IDLE_TIMEOUT_SECONDS).entrySet()) {
                pipeline.addLast(e.getKey(), e.getValue());
            }
            pipeline.addLast("decoder", Handlers.newHttpDecoder());
            pipeline.addLast("encoder", Handlers.newHttpResponseEncoder());
            pipeline.addLast("chunkedWriter", Handlers.newChunkedWriteHandler());
            pipeline.addLast("fence", Handlers.bootstrapFence());
            pipeline.addLast("pipeline-filter", (ChannelHandler)Handlers.newNioServerHandler());
            if (StackConfiguration.ASYNC_PIPELINE.booleanValue()) {
                pipeline.addLast("async-pipeline-execution-handler", (ChannelHandler)Handlers.pipelineExecutionHandler());
            }
            return pipeline;
        }
    }
}

