/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.fsm;

import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.async.Callbacks;
import com.eucalyptus.util.fsm.AbstractTransitionAction;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionException;
import com.eucalyptus.util.fsm.TransitionListener;
import com.google.common.base.Predicate;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class Transitions {
    private static Logger LOG = Logger.getLogger(Transitions.class);

    private static TransitionException exceptionOnCondition(String message, Predicate p) {
        return new TransitionException("Transition rejected because constraint check is false: " + message + " for class " + p.getClass());
    }

    public static <P extends HasName<P>> TransitionListener<P> callbackAsListener(final Callback<P> p) {
        return new TransitionListener<P>(){

            @Override
            public boolean before(P parent) {
                return true;
            }

            @Override
            public void leave(P parent) {
                try {
                    p.fire(parent);
                }
                catch (Exception ex) {
                    LOG.error((Object)ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }

            @Override
            public void enter(P parent) {
            }

            @Override
            public void after(P parent) {
            }
        };
    }

    public static <P extends HasName<P>> TransitionAction<P> noop() {
        return SimpleTransitions.NOOP;
    }

    public static <P extends HasName<P>> TransitionListener<P> predicateAsBeforeListener(final Predicate<P> predicate) {
        TransitionListener listener = new TransitionListener<P>(){

            @Override
            public boolean before(P parent) {
                return predicate.apply(parent);
            }

            @Override
            public void leave(P parent) {
            }

            @Override
            public void enter(P parent) {
            }

            @Override
            public void after(P parent) {
            }
        };
        return listener;
    }

    public static <P extends HasName<P>> TransitionAction<P> callbackAsAction(final Callback<P> callback) {
        AbstractTransitionAction action = new AbstractTransitionAction<P>(){

            @Override
            public void leave(P parent, Callback.Completion transitionCallback) {
                try {
                    callback.fire(parent);
                    transitionCallback.fire();
                }
                catch (RuntimeException ex) {
                    LOG.error((Object)ex);
                    transitionCallback.fireException(ex);
                }
            }
        };
        return action;
    }

    public static <P extends HasName<P>> TransitionAction<P> callableAsAction(Callable<P> callable) {
        return Transitions.callbackAsAction(Callbacks.forCallable(callable));
    }

    public static <P extends HasName<P>> TransitionAction<P> runnableAsAction(Runnable runnable) {
        return Transitions.callbackAsAction(Callbacks.forRunnable(runnable));
    }

    public static <P extends HasName<P>> TransitionAction<P> predicateAsAction(final Predicate<P> predicate) {
        AbstractTransitionAction action = new AbstractTransitionAction<P>(){

            @Override
            public void leave(P parent, Callback.Completion transitionCallback) {
                try {
                    if (!predicate.apply(parent)) {
                        transitionCallback.fireException(Transitions.exceptionOnCondition("Transition condition failed for " + parent + " on condition ", predicate));
                    } else {
                        transitionCallback.fire();
                    }
                }
                catch (RuntimeException ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    transitionCallback.fireException(ex);
                }
            }
        };
        return action;
    }

    private static enum SimpleTransitions implements TransitionAction
    {
        NOOP{

            public void leave(HasName parent, Callback.Completion transitionCallback) {
                transitionCallback.fire();
            }

            public String toString() {
                return "TransitionAction.noop";
            }

            public boolean before(HasName parent) {
                return true;
            }

            public void enter(HasName parent) {
            }

            public void after(HasName parent) {
            }
        }
        ,
        OUTOFBAND{

            public void leave(HasName parent, Callback.Completion transitionCallback) {
            }

            public String toString() {
                return "TransitionAction.OUTOFBAND";
            }

            public boolean before(HasName parent) {
                return true;
            }

            public void enter(HasName parent) {
            }

            public void after(HasName parent) {
            }
        };

    }
}

