/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.fsm;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionException;
import com.eucalyptus.util.fsm.TransitionHandler;
import com.eucalyptus.util.fsm.TransitionListener;
import com.eucalyptus.util.fsm.TransitionListenerException;
import com.eucalyptus.util.fsm.TransitionRule;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class TransitionImpl<P extends HasName<P>, S extends Automata.State, T extends Automata.Transition>
implements TransitionAction<P>,
TransitionHandler<P, S, T>,
TransitionRule<S, T> {
    private static Logger LOG = Logger.getLogger(TransitionImpl.class);
    private final AtomicInteger index = new AtomicInteger(0);
    private final TransitionRule<S, T> rule;
    private final ConcurrentMap<Integer, TransitionListener<P>> listeners = Maps.newConcurrentMap();
    private final TransitionAction<P> action;

    TransitionImpl(TransitionRule<S, T> transitionRule, TransitionAction<P> action, TransitionListener<P> ... listeners) {
        this.rule = transitionRule;
        this.action = action;
        for (TransitionListener<P> listener : listeners) {
            this.addListener(listener);
        }
    }

    @Override
    public TransitionHandler<P, S, T> addListener(TransitionListener<P> listener) {
        Logs.extreme().debug((Object)EventRecord.here(TransitionImpl.class, EventType.TRANSITION, this.toString(), "addListener", listener.getClass().getSimpleName()));
        this.listeners.put(this.index.incrementAndGet(), listener);
        return this;
    }

    private void removeListener(Integer key) {
        TransitionListener listener = (TransitionListener)this.listeners.remove(key);
        Logs.extreme().debug((Object)EventRecord.here(TransitionImpl.class, EventType.TRANSITION, this.toString(), "removeListener", listener.getClass().getSimpleName()));
    }

    @Override
    public T getName() {
        return (T)((Automata.Transition)this.rule.getName());
    }

    @Override
    public Boolean getFromStateMark() {
        return this.rule.getFromStateMark();
    }

    @Override
    public S getFromState() {
        return this.rule.getFromState();
    }

    @Override
    public Boolean getToStateMark() {
        return this.rule.getToStateMark();
    }

    @Override
    public S getToState() {
        return this.rule.getToState();
    }

    @Override
    public S getErrorState() {
        return this.rule.getErrorState();
    }

    @Override
    public Boolean getErrorStateMark() {
        return this.rule.getErrorStateMark();
    }

    private boolean fireListeners(TransitionListener.Phases phase, Predicate<TransitionListener<P>> pred, P parent) {
        for (Map.Entry entry : this.listeners.entrySet()) {
            TransitionListener tl = (TransitionListener)entry.getValue();
            Logs.extreme().trace((Object)EventRecord.here(TransitionImpl.class, EventType.TRANSITION_LISTENER, "" + parent.getName(), this.toString(), phase.toString(), ((Integer)entry.getKey()).toString(), tl.getClass().toString()));
            try {
                if (pred.apply(entry.getValue())) continue;
                throw new TransitionListenerException(((TransitionListener)entry.getValue()).getClass().getSimpleName() + "." + (Object)((Object)phase) + "( ) returned false.");
            }
            catch (Exception t) {
                Logs.extreme().error((Object)t, (Throwable)t);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean before(P parent) {
        if (this.action == null) {
            throw new IllegalStateException("Attempt to apply delegated transition before it is defined.");
        }
        this.fireListeners(TransitionListener.Phases.before, new Predicate<TransitionListener<P>>((HasName)parent){
            final /* synthetic */ HasName val$parent;
            {
                this.val$parent = hasName;
            }

            public boolean apply(TransitionListener<P> listener) {
                return listener.before(this.val$parent);
            }
        }, parent);
        try {
            return this.action.before(parent);
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
            return false;
        }
    }

    @Override
    public void leave(P parent, Callback.Completion transitionCallback) {
        if (this.action == null) {
            throw new IllegalStateException("Attempt to apply delegated transition before it is defined.");
        }
        try {
            this.action.leave(parent, transitionCallback);
            this.fireListeners(TransitionListener.Phases.leave, new Predicate<TransitionListener<P>>((HasName)parent){
                final /* synthetic */ HasName val$parent;
                {
                    this.val$parent = hasName;
                }

                public boolean apply(TransitionListener<P> listener) {
                    listener.leave(this.val$parent);
                    return true;
                }
            }, parent);
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            transitionCallback.fireException(new TransitionException(ex));
        }
    }

    @Override
    public void enter(P parent) {
        if (this.action == null) {
            throw new IllegalStateException("Attempt to apply delegated transition before it is defined.");
        }
        this.fireListeners(TransitionListener.Phases.enter, new Predicate<TransitionListener<P>>((HasName)parent){
            final /* synthetic */ HasName val$parent;
            {
                this.val$parent = hasName;
            }

            public boolean apply(TransitionListener<P> listener) {
                listener.enter(this.val$parent);
                return true;
            }
        }, parent);
        this.action.enter(parent);
    }

    @Override
    public void after(P parent) {
        if (this.action == null) {
            throw new IllegalStateException("Attempt to apply delegated transition before it is defined.");
        }
        this.fireListeners(TransitionListener.Phases.after, new Predicate<TransitionListener<P>>((HasName)parent){
            final /* synthetic */ HasName val$parent;
            {
                this.val$parent = hasName;
            }

            public boolean apply(TransitionListener<P> listener) {
                listener.after(this.val$parent);
                return true;
            }
        }, parent);
        this.action.after(parent);
    }

    @Override
    public String toString() {
        String actionName = "null";
        if (this.action != null) {
            actionName = this.action.getClass().getName().replaceAll("^(\\w.)*", "");
        }
        return String.format("Transition name=%s from=%s/%s to=%s/%s error=%s action=%s", this.getName(), this.getFromState(), this.getFromStateMark(), this.getToState(), this.getToStateMark(), this.getErrorState(), "" + this.action);
    }

    @Override
    public TransitionRule<S, T> getRule() {
        return this.rule;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rule == null ? 0 : this.rule.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransitionImpl other = (TransitionImpl)obj;
        return this.rule.equals(other.rule);
    }

    @Override
    public TransitionAction<P> getAction() {
        return this.action;
    }

    @Override
    public int compareTo(TransitionRule<S, T> that) {
        return this.getName().compareTo(that.getName());
    }
}

