/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.fsm;

import com.eucalyptus.util.Callback;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.fsm.AtomicMarkedState;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.StateMachine;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionHandler;
import com.eucalyptus.util.fsm.TransitionImpl;
import com.eucalyptus.util.fsm.TransitionListener;
import com.eucalyptus.util.fsm.TransitionRule;
import com.eucalyptus.util.fsm.Transitions;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class StateMachineBuilder<P extends HasName<P>, S extends Automata.State, T extends Automata.Transition> {
    private static Logger LOG = Logger.getLogger(StateMachineBuilder.class);
    protected P parent;
    protected S startState;
    private ImmutableList<S> immutableStates;
    private final Set<TransitionHandler<P, S, T>> transitions = Sets.newHashSet();
    private final Multimap<S, Callback<P>> inStateListeners = ArrayListMultimap.create();
    private final Multimap<S, Callback<P>> outStateListeners = ArrayListMultimap.create();

    protected InStateBuilder in(S input) {
        return new InStateBuilder((Automata.State)input){
            final /* synthetic */ Automata.State val$input;
            {
                this.val$input = state;
                this.state = this.val$input;
            }
        };
    }

    protected OutStateBuilder out(S input) {
        return new OutStateBuilder((Automata.State)input){
            final /* synthetic */ Automata.State val$input;
            {
                this.val$input = state;
                this.state = this.val$input;
            }
        };
    }

    protected TransitionBuilder on(T input) {
        return new TransitionBuilder((Automata.Transition)input){
            final /* synthetic */ Automata.Transition val$input;
            {
                this.val$input = transition;
                this.name = this.val$input;
            }
        };
    }

    protected TransitionBuilder from(S input) {
        return new TransitionBuilder((Automata.State)input){
            final /* synthetic */ Automata.State val$input;
            {
                this.val$input = state;
                this.fromState = this.val$input;
            }
        };
    }

    protected StateMachineBuilder<P, S, T> addTransition(TransitionHandler<P, S, T> transition) {
        if (this.transitions.contains(transition)) {
            throw new IllegalArgumentException("Duplicate transition named: " + transition.getName());
        }
        this.transitions.add(transition);
        return this;
    }

    public StateMachine<P, S, T> newAtomicMarkedState() {
        if (this.startState == null || this.parent == null || this.transitions == null || this.transitions.isEmpty()) {
            throw new IllegalStateException("Call to build() for an ill-formed state machine -- did you finish adding all the transition rules?");
        }
        this.doChecks();
        return new AtomicMarkedState<P, S, T>(this.startState, this.parent, this.transitions, this.inStateListeners, this.outStateListeners);
    }

    private void doChecks() {
        this.immutableStates = ImmutableList.copyOf((Object[])Automata.EnumMappable.Mapper.getEnumConstants(this.startState));
        if (this.transitions.isEmpty()) {
            throw new IllegalStateException("Started state machine with no registered transitions.");
        }
        T transitionName = this.transitions.iterator().next().getName();
        Automata.Transition[] trans = (Automata.Transition[])Automata.EnumMappable.Mapper.getEnumConstants(transitionName);
        HashMap alltransitions = Maps.newHashMap();
        for (Automata.State s1 : this.immutableStates) {
            for (Automata.State s2 : this.immutableStates) {
                alltransitions.put(String.format("%s.%s->%s.%s", s1, false, s2, false), null);
                alltransitions.put(String.format("%s.%s->%s.%s", s1, false, s2, true), null);
                alltransitions.put(String.format("%s.%s->%s.%s", s1, true, s2, false), null);
                alltransitions.put(String.format("%s.%s->%s.%s", s1, true, s2, true), null);
            }
        }
        LOG.debug((Object)("Starting state machine: " + this.parent.getClass().getSimpleName() + " " + this.parent.getName()));
        ArrayListMultimap transNames = ArrayListMultimap.create();
        for (TransitionHandler<P, S, T> t : this.transitions) {
            transNames.put(t.getName(), t);
        }
        for (Automata.Transition t : trans) {
            for (TransitionHandler tr : transNames.get((Object)t)) {
                String trKey = String.format("%s.%s->%s.%s (err=%s.%s)", tr.getFromState(), tr.getFromStateMark(), tr.getToState(), tr.getToStateMark(), tr.getErrorState(), tr.getErrorStateMark());
                if (alltransitions.get(trKey) != null) {
                    LOG.error((Object)("Duplicate transition: " + tr + " AND " + alltransitions.get(trKey)));
                    throw new IllegalStateException("Duplicate transition: " + tr + " AND " + alltransitions.get(trKey));
                }
                alltransitions.put(trKey, tr);
            }
        }
        for (String trKey : alltransitions.keySet()) {
            if (alltransitions.get(trKey) == null) continue;
            LOG.debug((Object)String.format("fsm %s %-60.60s %s", this.parent.getName(), trKey, alltransitions.get(trKey)));
        }
    }

    public StateMachineBuilder(P parent, S startState) {
        this.parent = parent;
        this.startState = startState;
    }

    static class BasicTransitionRule<S extends Automata.State, T extends Automata.Transition>
    implements TransitionRule<S, T> {
        private T name;
        private S fromState;
        private S toState;
        private S errorState;
        private final Boolean fromStateMark;
        private final Boolean toStateMark;
        private final Boolean errorStateMark;

        protected BasicTransitionRule(T name, S fromState, S toState) {
            this.name = name;
            this.fromState = fromState;
            this.toState = toState;
            this.errorState = fromState;
            this.fromStateMark = false;
            this.toStateMark = false;
            this.errorStateMark = false;
        }

        protected BasicTransitionRule(T name, S fromState, S toState, S errorState) {
            this.name = name;
            this.fromState = fromState;
            this.toState = toState;
            this.errorState = errorState;
            this.fromStateMark = false;
            this.toStateMark = false;
            this.errorStateMark = false;
        }

        protected BasicTransitionRule(T name, S fromState, Boolean fromStateMark, S toState, Boolean toStateMark, S errorState, Boolean errorStateMark) {
            this.name = name;
            this.fromState = fromState;
            this.toState = toState;
            this.errorState = errorState;
            this.fromStateMark = fromStateMark;
            this.toStateMark = toStateMark;
            this.errorStateMark = errorStateMark;
        }

        @Override
        public final T getName() {
            return this.name;
        }

        @Override
        public final S getFromState() {
            return this.fromState;
        }

        @Override
        public final S getToState() {
            return this.toState;
        }

        @Override
        public final S getErrorState() {
            return this.errorState;
        }

        @Override
        public final Boolean getFromStateMark() {
            return this.fromStateMark;
        }

        @Override
        public final Boolean getToStateMark() {
            return this.toStateMark;
        }

        @Override
        public final Boolean getErrorStateMark() {
            return this.errorStateMark;
        }

        @Override
        public int compareTo(TransitionRule<S, T> that) {
            return this.getName().compareTo(that.getName());
        }

        @Override
        public String toString() {
            return String.format("Transition name=%s from=%s/%s to=%s/%s error=%s", this.getName(), this.getFromState(), this.getFromStateMark(), this.getToState(), this.getToStateMark(), this.getErrorState());
        }
    }

    protected class TransitionBuilder {
        TransitionHandler<P, S, T> transition;
        T name;
        S fromState;
        S toState;
        S errorState;
        TransitionAction<P> action;
        List<TransitionListener<P>> listeners = Lists.newArrayList();

        protected TransitionBuilder() {
        }

        TransitionBuilder commit(TransitionAction<P> action) {
            this.action = action;
            this.errorState = this.errorState == null ? this.fromState : this.errorState;
            BasicTransitionRule rule = new BasicTransitionRule(this.name, this.fromState, this.toState, this.errorState);
            this.transition = new TransitionImpl(rule, this.action, this.listeners.toArray(new TransitionListener[0]));
            this.listeners = null;
            StateMachineBuilder.this.addTransition(this.transition);
            return this;
        }

        private void commit() {
        }

        public TransitionBuilder on(T transitionName) {
            this.name = transitionName;
            return this;
        }

        public TransitionBuilder from(S fromState) {
            this.fromState = fromState;
            return this;
        }

        public TransitionBuilder to(S toState) {
            this.toState = toState;
            return this;
        }

        public TransitionBuilder error(S errorState) {
            this.errorState = errorState;
            return this;
        }

        public void run(Callback<P> callable) {
            TransitionAction action = Transitions.callbackAsAction(callable);
            this.commit(action);
        }

        public void run(Runnable function) {
            TransitionAction action = Transitions.runnableAsAction(function);
            this.commit(action);
        }

        public void run(Function<P, TransitionAction<P>> function) {
            this.commit((TransitionAction)function.apply(StateMachineBuilder.this.parent));
        }

        public void run(TransitionAction<P> action) {
            this.commit(action);
        }

        public void run(Predicate<P> predicate) {
            TransitionAction action = Transitions.predicateAsAction(predicate);
            this.commit(action);
        }

        public TransitionBuilder addListener(Callback<P> callback) {
            TransitionListener listener = Transitions.callbackAsListener(callback);
            if (this.listeners == null) {
                this.transition.addListener(listener);
            } else {
                this.listeners.add(listener);
            }
            return this;
        }

        public TransitionBuilder addListener(TransitionListener<P> ... listeners) {
            if (this.listeners == null) {
                for (TransitionListener l : listeners) {
                    this.transition.addListener(l);
                }
            } else {
                for (TransitionListener l : listeners) {
                    this.listeners.add(l);
                }
            }
            return this;
        }
    }

    protected class OutStateBuilder {
        S state;

        protected OutStateBuilder() {
        }

        public OutStateBuilder run(Callback<P> callback) {
            StateMachineBuilder.this.outStateListeners.put(this.state, callback);
            return this;
        }

        public OutStateBuilder run(final Predicate<P> predicate) {
            StateMachineBuilder.this.outStateListeners.put(this.state, (Object)new Callback<P>(){

                @Override
                public void fire(P p) {
                    predicate.apply(p);
                }
            });
            return this;
        }
    }

    protected class InStateBuilder {
        S state;

        protected InStateBuilder() {
        }

        public InStateBuilder run(Callback<P> callback) {
            StateMachineBuilder.this.inStateListeners.put(this.state, callback);
            return this;
        }

        public InStateBuilder run(final Predicate<P> predicate) {
            StateMachineBuilder.this.inStateListeners.put(this.state, (Object)new Callback<P>(){

                @Override
                public void fire(P p) {
                    predicate.apply(p);
                }
            });
            return this;
        }
    }
}

