/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.fsm;

import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.fsm.HasStateMachine;
import com.eucalyptus.util.fsm.StateMachine;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class Automata {
    public static Logger LOG = Logger.getLogger(Automata.class);

    public static <S extends State, P extends HasFullName<P>> Callable<CheckedListenableFuture<P>> sequenceTransitions(HasStateMachine<P, S, ?> hasFsm, S ... toStates) {
        Parameters.checkParam(toStates, Matchers.not((Matcher)Matchers.emptyArray()));
        S currentState = hasFsm.getStateMachine().getState();
        int index = Lists.newArrayList((Object[])toStates).indexOf(currentState);
        Object[] actualStates = toStates;
        if (index >= 0 && index < toStates.length) {
            actualStates = (State[])Arrays.copyOfRange(toStates, index + 1, toStates.length);
        }
        Logs.exhaust().debug((Object)("Preparing callback for " + hasFsm.getFullName() + " from state " + currentState + " followed by transition sequence: " + Joiner.on((String)"->").join(actualStates)));
        List callables = Automata.makeTransitionCallables(hasFsm, (State[])actualStates);
        return Futures.sequence(callables.toArray(new Callable[0]));
    }

    private static <S extends State, P extends HasFullName<P>> List<Callable<CheckedListenableFuture<P>>> makeTransitionCallables(final HasStateMachine<P, S, ?> hasFsm, S ... toStates) {
        ArrayList callables = Lists.newArrayList();
        final StateMachine<P, S, ?> fsm = hasFsm.getStateMachine();
        if (toStates.length > 0) {
            for (S toState : toStates) {
                callables.add(new Callable<CheckedListenableFuture<P>>((State)toState){
                    final /* synthetic */ State val$toState;
                    {
                        this.val$toState = state;
                    }

                    public String toString() {
                        return Automata.class.getSimpleName() + ":" + hasFsm.getFullName() + ":" + fsm.getState() + "->" + this.val$toState;
                    }

                    @Override
                    public CheckedListenableFuture<P> call() {
                        Object fromState = fsm.getState();
                        try {
                            CheckedListenableFuture res = fsm.transition(this.val$toState);
                            try {
                                res.get();
                                Logs.extreme().debug((Object)(fsm.toString() + " transitioned from " + fromState + "->" + this.val$toState));
                                return res;
                            }
                            catch (Exception ex) {
                                return res;
                            }
                        }
                        catch (Exception ex) {
                            Logs.extreme().debug((Object)(fsm.toString() + " failed transitioned from " + fromState + "->" + this.val$toState));
                            Exceptions.maybeInterrupted(ex);
                            Logs.extreme().error((Object)ex, (Throwable)ex);
                            return Futures.predestinedFailedFuture(ex);
                        }
                    }
                });
            }
        } else {
            callables.add(new Callable<CheckedListenableFuture<P>>(){

                public String toString() {
                    return Automata.class.getSimpleName() + ":" + hasFsm.getFullName() + ":" + fsm.getState();
                }

                @Override
                public CheckedListenableFuture<P> call() {
                    CheckedListenableFuture ret = Futures.predestinedFuture(hasFsm.getStateMachine().getParent());
                    return ret;
                }
            });
        }
        return callables;
    }

    public static interface State<S extends Enum<S>>
    extends EnumMappable,
    Comparable<S> {
    }

    public static interface Transition<T extends Enum<T>>
    extends EnumMappable,
    Comparable<T> {
    }

    public static interface EnumMappable {
        public static final Mapper asEnum = new Mapper();

        public static class Mapper {
            public static <E> E[] getEnumConstants(E input) {
                if (Enum.class.isAssignableFrom(input.getClass())) {
                    return ((Enum)input).getDeclaringClass().getEnumConstants();
                }
                throw new RuntimeException("Failed to produce Enum constants because underlying class does not extend Enum:  " + input.getClass());
            }
        }
    }
}

