/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.fsm;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasFullName;
import com.eucalyptus.util.HasName;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.fsm.Automata;
import com.eucalyptus.util.fsm.ExistingTransitionException;
import com.eucalyptus.util.fsm.StateMachine;
import com.eucalyptus.util.fsm.TransitionAction;
import com.eucalyptus.util.fsm.TransitionHandler;
import com.eucalyptus.util.fsm.TransitionRecord;
import com.eucalyptus.util.fsm.TransitionRule;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class AtomicMarkedState<P extends HasName<P>, S extends Automata.State, T extends Automata.Transition>
implements StateMachine<P, S, T> {
    private static Logger LOG = Logger.getLogger(AtomicMarkedState.class);
    private final P parent;
    private final String name;
    private final S startState;
    private final ImmutableList<S> immutableStates;
    private final Multimap<S, Callback<P>> inStateListeners = ArrayListMultimap.create();
    private final Multimap<S, Callback<P>> outStateListeners = ArrayListMultimap.create();
    private volatile ImmutableList<TransitionHandler<P, S, T>> immutableTransitions = null;
    private final Multimap<T, TransitionHandler<P, S, T>> transitions = ArrayListMultimap.create();
    private final Map<S, Map<S, TransitionHandler<P, S, T>>> stateTransitions;
    private final AtomicMarkableReference<S> state;
    private static final AtomicLong id = new AtomicLong(0L);
    private final AtomicReference<ActiveTransition> currentTransition = new AtomicReference<Object>(null);

    public AtomicMarkedState(S startState, P parent, Set<TransitionHandler<P, S, T>> transitions, Multimap<S, Callback<P>> inStateListeners, Multimap<S, Callback<P>> outStateListeners) {
        this.startState = startState;
        String tempName = null;
        if (parent instanceof HasFullName) {
            try {
                tempName = ((HasFullName)parent).getFullName().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.name = tempName != null ? tempName : String.format("%s-%s", parent.getClass().getSimpleName(), parent.getName());
        this.parent = parent;
        Object[] states = (Automata.State[])Automata.EnumMappable.Mapper.getEnumConstants(startState);
        this.stateTransitions = new HashMap<S, Map<S, TransitionHandler<P, S, T>>>((Automata.State[])states){
            final /* synthetic */ Automata.State[] val$states;
            {
                this.val$states = stateArray;
                for (Automata.State s : this.val$states) {
                    this.put(s, new HashMap());
                }
            }
        };
        this.immutableStates = ImmutableList.copyOf((Object[])states);
        this.state = new AtomicMarkableReference<S>(this.startState, false);
        this.immutableTransitions = ImmutableList.copyOf(transitions);
        for (TransitionHandler<P, S, T> t : transitions) {
            this.transitions.put(t.getName(), t);
            this.stateTransitions.get(t.getRule().getFromState()).put(t.getRule().getToState(), t);
        }
        this.inStateListeners.putAll(inStateListeners);
        this.outStateListeners.putAll(outStateListeners);
    }

    @Override
    public boolean isLegalTransition(T transitionName) {
        try {
            this.lookupTransition(transitionName);
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    @Deprecated
    public CheckedListenableFuture<P> transitionByName(T transitionName) throws IllegalStateException, ExistingTransitionException {
        if (this.state.isMarked()) {
            throw new ExistingTransitionException("Transition request transition=" + transitionName + " rejected because of an ongoing transition: " + this.toString());
        }
        if (!this.transitions.containsKey(transitionName)) {
            throw new NoSuchElementException("No such transition named: " + transitionName.toString() + ". Known transitions: " + this.getTransitions());
        }
        this.checkTransition(transitionName);
        ActiveTransition tid = this.beforeLeave(transitionName);
        CheckedListenableFuture<P> future = this.afterLeave(transitionName, tid);
        return future;
    }

    @Override
    public CheckedListenableFuture<P> transition(S nextState) throws IllegalStateException, ExistingTransitionException {
        if (this.state.isMarked()) {
            throw new ExistingTransitionException("Transition request state=" + nextState + " rejected because of an ongoing transition: " + this.toString());
        }
        if (!this.stateTransitions.get(this.state.getReference()).containsKey(nextState)) {
            throw new NoSuchElementException("No transition to " + nextState.toString() + " from current state " + this.toString() + ". Known transitions: " + this.getTransitions());
        }
        T transitionName = this.stateTransitions.get(this.state.getReference()).get(nextState).getName();
        this.checkTransition(transitionName);
        ActiveTransition tid = this.beforeLeave(transitionName);
        return this.afterLeave(transitionName, tid);
    }

    protected ActiveTransition request(T transitionName) throws ExistingTransitionException {
        TransitionHandler<P, S, T> transition = this.lookupTransition(transitionName);
        TransitionRule<S, T> rule = transition.getRule();
        if (!this.state.compareAndSet(rule.getFromState(), rule.getFromState(), rule.getFromStateMark(), true)) {
            throw new ExistingTransitionException("Transition request " + transitionName + " rejected because of an ongoing transition: " + this.toString());
        }
        this.currentTransition.set(this.create(rule, transition));
        return this.currentTransition.get();
    }

    private TransitionHandler<P, S, T> lookupTransition(T transitionName) {
        if (!this.transitions.containsKey(transitionName)) {
            throw new NoSuchElementException("No such transition: " + transitionName);
        }
        Automata.State fromState = null;
        boolean[] mark = new boolean[1];
        for (TransitionHandler transition : this.transitions.get(transitionName)) {
            fromState = (Automata.State)this.state.get(mark);
            if (!transition.getRule().getFromState().equals(fromState) || transition.getRule().getFromStateMark() != mark[0]) continue;
            return transition;
        }
        throw new NoSuchElementException("No such transition: " + transitionName + " for the current state " + fromState + " and mark " + mark[0] + " for parent " + this.parent.toString());
    }

    private void commit() {
        Logs.exhaust().trace((Object)("Transition commit(): " + this.currentTransition.get()));
        if (!this.state.isMarked()) {
            IllegalStateException ex = new IllegalStateException("commit() called when there is no currently pending transition: " + this.toString());
            Logs.exhaust().error((Object)ex, (Throwable)ex);
        } else {
            ActiveTransition tr = this.currentTransition.getAndSet(null);
            this.state.set(tr.getTransitionRule().getToState(), tr.getTransitionRule().getToStateMark());
            if (!tr.getTransitionRule().getFromState().equals(tr.getTransitionRule().getToState())) {
                this.state.set(tr.getTransitionRule().getToState(), false);
                this.fireInListeners(tr.getTransitionRule().getToState());
            } else {
                this.state.set(tr.getTransitionRule().getToState(), false);
            }
            tr.getTransitionFuture().set(this.parent);
            try {
                EventRecord.caller(this.getClass(), EventType.TRANSITION_FUTURE, "set(" + this.parent.toString() + ":" + this.parent.getClass().getCanonicalName() + ")").trace();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
        }
    }

    private void error(Throwable t) {
        Logs.extreme().error((Object)("Transition error(): " + this.toString()), t);
        if (!this.state.isMarked()) {
            IllegalStateException ex = new IllegalStateException("error() called when there is no currently pending transition: " + this.toString(), t);
            Logs.exhaust().error((Object)ex);
            ActiveTransition tr = this.currentTransition.getAndSet(null);
            if (tr != null) {
                tr.getTransitionFuture().setException(t);
                this.state.set(tr.getTransitionRule().getErrorState(), false);
            }
        } else {
            ActiveTransition tr = this.currentTransition.getAndSet(null);
            if (tr != null) {
                Logs.extreme().error((Object)("Transition error(): " + this.toString() + "Transition error(): START STACK\n" + tr.startStackTrace));
                Logs.extreme().error((Object)("Transition error(): " + this.toString() + "Transition error(): END STACK" + (String)tr.endStackTrace.get()));
                this.state.set(tr.getTransitionRule().getErrorState(), tr.getTransitionRule().getErrorStateMark());
                if (!tr.getTransitionRule().getFromState().equals(tr.getTransitionRule().getErrorState())) {
                    this.state.set(tr.getTransitionRule().getErrorState(), false);
                    this.fireInListeners(tr.getTransitionRule().getErrorState());
                } else {
                    this.state.set(tr.getTransitionRule().getErrorState(), false);
                }
                EventRecord.caller(this.getClass(), EventType.TRANSITION_FUTURE, "setException(" + t.getClass().getCanonicalName() + "): " + t.getMessage()).trace();
                tr.getTransitionFuture().setException(t);
            }
        }
    }

    private void rollback(Throwable t) {
        LOG.debug((Object)("Transition rollback(): " + this.toString()));
        if (!this.state.isMarked()) {
            Exceptions.trace(new IllegalStateException("rollback() called when there is no currently pending transition: " + this.toString()));
        } else {
            ActiveTransition tr = this.currentTransition.getAndSet(null);
            if (tr != null) {
                this.state.set(tr.getTransitionRule().getFromState(), false);
            }
        }
    }

    protected void fireInListeners(S state) {
        for (Callback cb : this.inStateListeners.get(state)) {
            try {
                Logs.exhaust().debug((Object)("Firing state-in listener: " + cb.getClass() + " for " + this.toString()));
                cb.fire(this.parent);
            }
            catch (Exception t) {
                Exceptions.trace("Firing state-in listeners failed for :" + cb.getClass().getCanonicalName(), Exceptions.filterStackTrace(t));
            }
        }
    }

    protected void fireOutListeners(S state) {
        for (Callback cb : this.outStateListeners.get(state)) {
            try {
                Logs.exhaust().debug((Object)("Firing state-in listener: " + cb.getClass() + " for " + this.toString()));
                cb.fire(this.parent);
            }
            catch (Exception t) {
                Exceptions.trace("Firing state-out listeners failed for :" + cb.getClass().getCanonicalName(), Exceptions.filterStackTrace(t));
            }
        }
    }

    private final void checkTransition(T transitionName) {
        try {
            if (!this.lookupTransition(transitionName).before(this.parent)) {
                throw Exceptions.trace(new IllegalStateException(String.format("Failed to apply transition %s because before() returned false.", transitionName.toString())));
            }
        }
        catch (Exception t) {
            throw Exceptions.trace(new IllegalStateException(String.format("Failed to apply transition %s because before() threw an exception: %s", transitionName.toString(), t.getMessage()), t));
        }
    }

    private final CheckedListenableFuture<P> afterLeave(T transitionName, ActiveTransition tid) throws IllegalStateException {
        try {
            CheckedListenableFuture result = tid.leave();
            try {
                this.fireOutListeners(tid.getTransitionRule().getFromState());
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
            }
            return result;
        }
        catch (Exception t) {
            this.error(t);
            throw Exceptions.trace(new IllegalStateException(String.format("Failed to apply transition %s because leave() threw an exception: %s", transitionName.toString(), t.getMessage()), t));
        }
    }

    private final ActiveTransition beforeLeave(T transitionName) throws IllegalStateException, ExistingTransitionException {
        ActiveTransition tid;
        try {
            tid = this.request(transitionName);
        }
        catch (ExistingTransitionException t) {
            throw t;
        }
        catch (Exception t) {
            this.error(t);
            throw Exceptions.trace(new IllegalStateException(String.format("Failed to apply transition %s because request() threw an exception.", transitionName.toString()), t));
        }
        return tid;
    }

    @Override
    public S getState() {
        return (S)((Automata.State)this.state.getReference());
    }

    @Override
    public boolean isBusy() {
        return this.state.isMarked();
    }

    @Override
    public ImmutableList<S> getStates() {
        return this.immutableStates;
    }

    @Override
    public ImmutableList<TransitionHandler<P, S, T>> getTransitions() {
        return this.immutableTransitions;
    }

    public String toString() {
        ActiveTransition t = this.currentTransition.get();
        return String.format("State:name=%s:state=%s:mark=%s:transition=%s", this.name, this.state.getReference(), this.state.isMarked(), t != null ? t.toString() : "idle");
    }

    public String getName() {
        return this.name;
    }

    private ActiveTransition create(TransitionRule<S, T> rule, TransitionAction<P> transition) {
        return new ActiveTransition(id.incrementAndGet(), rule, transition);
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    @Override
    public TransitionRecord getTransitionRecord() {
        return this.currentTransition.get();
    }

    private class ActiveTransition
    extends Callback.Completion
    implements HasName<ActiveTransition>,
    TransitionRecord {
        private final Long txId;
        private final String txName;
        private final Long startTime;
        private Long endTime = 0L;
        private final TransitionAction<P> transition;
        private final String startStackTrace;
        private final Supplier<String> endStackTrace;
        private final CheckedListenableFuture<P> transitionFuture = Futures.newGenericeFuture();
        private final TransitionRule<S, T> rule;

        private ActiveTransition(Long id, TransitionRule<S, T> rule, TransitionAction<P> transition) {
            this.txId = id;
            this.startTime = System.currentTimeMillis();
            this.endTime = 0L;
            this.rule = rule;
            this.transition = transition;
            this.txName = AtomicMarkedState.this.getName() + " #" + this.txId + " " + this.rule.getName();
            this.startStackTrace = Logs.isExtrrreeeme() ? Threads.currentStackString() : Threads.currentStackFrame(0).toString();
            this.endStackTrace = new Supplier<String>(){

                public String get() {
                    if (Logs.isExtrrreeeme()) {
                        return Threads.currentStackString();
                    }
                    return Threads.currentStackFrame(3).toString();
                }
            };
        }

        CheckedListenableFuture<P> getTransitionFuture() {
            return this.transitionFuture;
        }

        @Override
        public boolean isDone() {
            return this.transitionFuture.isDone();
        }

        @Override
        public void fire() {
            try {
                if (!this.isDone()) {
                    this.transition.enter(AtomicMarkedState.this.parent);
                    this.transition.after(AtomicMarkedState.this.parent);
                    try {
                        AtomicMarkedState.this.commit();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception t) {
                this.fireException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireException(Throwable t) {
            try {
                if (Logs.isExtrrreeeme()) {
                    Logs.extreme().error((Object)this.startStackTrace);
                    Logs.extreme().error(this.endStackTrace.get());
                }
                AtomicMarkedState.this.error(t);
            }
            finally {
                this.transitionFuture.setException(t);
            }
        }

        public final Long getId() {
            return this.txId;
        }

        public TransitionRule<S, T> getTransitionRule() {
            return this.rule;
        }

        public CheckedListenableFuture<P> leave() {
            try {
                this.transition.leave(AtomicMarkedState.this.parent, this);
                return this.transitionFuture;
            }
            catch (Exception ex) {
                this.transitionFuture.setException(ex);
                return this.transitionFuture;
            }
        }

        @Override
        public String getName() {
            return this.txName;
        }

        @Override
        public int compareTo(ActiveTransition that) {
            return this.txId.compareTo(that.txId);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)EventType.TRANSITION).append(" ").append(this.txName).append(" Active").append(this.transition != null ? this.transition.toString() : "null").append(" id=").append(this.txId).append(" startTime=").append(new Date(this.startTime));
            Logs.exhaust().trace((Object)sb.toString());
            return sb.toString();
        }

        @Override
        public Long getTxId() {
            return this.txId;
        }

        @Override
        public String getTxName() {
            return this.txName;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        @Override
        public TransitionAction<P> getTransition() {
            return this.transition;
        }

        public String getStartStackTrace() {
            return this.startStackTrace;
        }

        public Supplier<String> getEndStackTrace() {
            return this.endStackTrace;
        }

        @Override
        public TransitionRule<S, T> getRule() {
            return this.rule;
        }
    }
}

