/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.dns;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.Subnets;
import com.eucalyptus.util.dns.DnsResolvers;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.eucalyptus.util.dns.DomainNames;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.NavigableSet;
import java.util.concurrent.TimeUnit;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

@ConfigurableClass(root="dns.ns", description="Options controlling DNS name resolution for the system's nameservers.")
public class NameserverResolver
implements DnsResolvers.DnsResolver {
    @ConfigurableField(description="Enable the NS resolver.  Note: dns.enable must also be 'true'")
    public static Boolean enabled = Boolean.TRUE;
    private static final Function<InetAddress, Cidr> cidrLookup = CacheBuilder.newBuilder().maximumSize(64L).expireAfterWrite(1L, TimeUnit.MINUTES).build(CacheLoader.from((Function)Functions.compose(CollectionUtils.optionalOr(Cidr.of(0, 0)), Internets.interfaceCidr())));

    @Override
    public boolean checkAccepts(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        Name name = query.getName();
        if (!(Bootstrap.isOperational().booleanValue() && enabled.booleanValue() && DomainNames.isSystemSubdomain(name))) {
            return false;
        }
        if (DnsResolvers.RequestType.A.apply(query)) {
            return name.getLabelString(0).matches("ns[1-9]*");
        }
        return DnsResolvers.RequestType.NS.apply(query);
    }

    @Override
    public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
        Record query = request.getQuery();
        Name name = query.getName();
        if (DnsResolvers.RequestType.A.apply(query) && DomainNames.isSystemSubdomain(name)) {
            String label0 = name.getLabelString(0);
            if (name.equals((Object)Name.fromConstantString((String)(label0 + "." + DomainNames.internalSubdomain()))) || name.equals((Object)Name.fromConstantString((String)(label0 + "." + DomainNames.externalSubdomain())))) {
                NavigableSet<ServiceConfiguration> nsServers = Components.lookup(Eucalyptus.class).services();
                Integer index = (Integer)Objects.firstNonNull((Object)Ints.tryParse((String)label0.substring(2)), (Object)1);
                if (nsServers.size() >= index) {
                    ServiceConfiguration conf = nsServers.toArray(new ServiceConfiguration[0])[index - 1];
                    Record addressRecord = DomainNameRecords.addressRecord(query.getName(), NameserverResolver.maphost(request.getLocalAddress(), conf.getInetAddress()));
                    return DnsResolvers.DnsResponse.forName(name).answer(addressRecord);
                }
            }
        } else if (DnsResolvers.RequestType.NS.apply(query)) {
            NavigableSet<ServiceConfiguration> nsServers = Components.lookup(Eucalyptus.class).services();
            ArrayList aRecs = Lists.newArrayList();
            Name domain = DomainNames.isInternalSubdomain(name) ? DomainNames.internalSubdomain() : DomainNames.externalSubdomain();
            int idx = 1;
            for (ServiceConfiguration conf : nsServers) {
                aRecs.add(DomainNameRecords.addressRecord(Name.fromConstantString((String)("ns" + idx++ + "." + domain)), NameserverResolver.maphost(request.getLocalAddress(), conf.getInetAddress())));
            }
            return DnsResolvers.DnsResponse.forName(name).withAdditional(aRecs).answer(DomainNameRecords.nameservers(name));
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static InetAddress maphost(InetAddress listenerAddress, InetAddress hostAddress) {
        Host host;
        InetAddress result = hostAddress;
        Cidr cidr = (Cidr)cidrLookup.apply((Object)listenerAddress);
        if (!cidr.apply(result) && (host = Hosts.lookup(hostAddress)) != null) {
            result = (InetAddress)Iterables.tryFind(host.getHostAddresses(), (Predicate)cidr).or((Object)result);
        }
        return result;
    }

    public static class NameserverReverseResolver
    implements DnsResolvers.DnsResolver {
        @Override
        public boolean checkAccepts(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            return DnsResolvers.RequestType.PTR.apply(query) && Subnets.isSystemHostAddress(DomainNameRecords.inAddrArpaToInetAddress(query.getName()));
        }

        @Override
        public DnsResolvers.DnsResponse lookupRecords(DnsResolvers.DnsRequest request) {
            Record query = request.getQuery();
            InetAddress hostAddr = DomainNameRecords.inAddrArpaToInetAddress(query.getName());
            String hostAddress = hostAddr.getHostAddress();
            if (Hosts.contains(hostAddress)) {
                NavigableSet<ServiceConfiguration> nsServers = Components.lookup(Eucalyptus.class).services();
                int index = nsServers.headSet((ServiceConfiguration)ServiceConfigurations.lookupByHost(Eucalyptus.class, hostAddr.getHostAddress())).size();
                Name nsName = Name.fromConstantString((String)("ns" + index + "." + DomainNames.externalSubdomain()));
                Record ptrRecord = DomainNameRecords.ptrRecord(nsName, hostAddr);
                return DnsResolvers.DnsResponse.forName(query.getName()).answer(ptrRecord);
            }
            return DnsResolvers.DnsResponse.forName(query.getName()).answer(new Record[0]);
        }
    }
}

