/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.dns;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Components;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.xbill.DNS.NSRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.TextParseException;

public class DomainNames {
    private static final Name ROOT_NAME = Name.fromConstantString((String)".");
    private static Logger LOG = Logger.getLogger(DomainNames.class);

    public static Name internalSubdomain(Class<? extends ComponentId> componentId) {
        return SystemSubdomain.INTERNAL.apply(componentId);
    }

    public static Name externalSubdomain(Class<? extends ComponentId> componentId) {
        return SystemSubdomain.EXTERNAL.apply(componentId);
    }

    public static Name internalSubdomain() {
        return (Name)SystemSubdomain.INTERNAL.get();
    }

    public static Name externalSubdomain() {
        return (Name)SystemSubdomain.EXTERNAL.get();
    }

    public static boolean isSystemSubdomain(Name name) {
        return DomainNames.isInternalSubdomain(name) || DomainNames.isExternalSubdomain(name);
    }

    public static boolean isExternalSubdomain(Name name) {
        return name.subdomain((Name)SystemSubdomain.EXTERNAL.get());
    }

    public static boolean isInternalSubdomain(Name name) {
        return name.subdomain((Name)SystemSubdomain.INTERNAL.get());
    }

    public static List<NSRecord> nameServerRecords(Name systemDomain) throws NoSuchElementException {
        return SystemSubdomain.lookup(systemDomain).getNameServers();
    }

    public static Name sourceOfAuthority(Name name) throws NoSuchElementException {
        return (Name)SystemSubdomain.lookup(name).get();
    }

    public static Name root() {
        return ROOT_NAME;
    }

    public static Name absolute(Name name) {
        return DomainNames.absolute(name, ROOT_NAME);
    }

    public static Name absolute(Name name, Name origin) {
        if (name.isAbsolute()) {
            return name;
        }
        return DomainNames.concatenateConstant(name, origin);
    }

    public static Name relativize(Name name, Name origin) {
        return name.relativize(origin);
    }

    public static Name concatenateConstant(Name one, Name two) {
        try {
            return Name.concatenate((Name)one, (Name)two);
        }
        catch (NameTooLongException ex) {
            LOG.error((Object)ex);
            throw Exceptions.toUndeclared(ex);
        }
    }

    private static enum SystemSubdomain implements Function<Class<? extends ComponentId>, Name>,
    Supplier<Name>
    {
        INTERNAL{

            public Name get() {
                return DomainNames.absolute(Name.fromConstantString((String)SystemSubdomain.INTERNAL_SUBDOMAIN));
            }
        }
        ,
        EXTERNAL{

            public Name get() {
                try {
                    return DomainNames.absolute(Name.fromString((String)SystemConfiguration.getSystemConfiguration().getDnsDomain()));
                }
                catch (TextParseException e) {
                    return DomainNames.absolute(Name.fromConstantString((String)"localhost"));
                }
            }
        };

        private static final String INTERNAL_SUBDOMAIN = "internal.";

        public Name apply(Class<? extends ComponentId> input) {
            Name compName = Name.fromConstantString((String)ComponentIds.lookup(input).name());
            return DomainNames.absolute(compName, (Name)this.get());
        }

        public List<NSRecord> getNameServers() {
            ArrayList nsRecs = Lists.newArrayList();
            int idx = 1;
            for (ServiceConfiguration conf : Components.lookup(Eucalyptus.class).services()) {
                nsRecs.add(new NSRecord((Name)this.get(), 1, 60L, Name.fromConstantString((String)("ns" + idx + "." + ((Name)this.get()).toString()))));
            }
            return nsRecs;
        }

        public static SystemSubdomain lookup(Name name) {
            for (SystemSubdomain s : SystemSubdomain.values()) {
                if (!name.subdomain((Name)s.get())) continue;
                return s;
            }
            throw new NoSuchElementException("Failed to lookup SystemSubdomain for the name: " + name);
        }
    }
}

