/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.dns;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.dns.DomainNames;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.SOARecord;

@ConfigurableClass(root="dns", description="Configuration options controlling the behaviour of DNS features.")
public class DomainNameRecords {
    @ConfigurableField(description="Time-to-live for all authoritative records")
    private static final long TTL = 60L;
    @ConfigurableField(description="Time-to-live for negative caching on authoritative records")
    private static final long NEGATIVE_TTL = 5L;
    static final DateFormat SERIALFORMATTER = new SimpleDateFormat("yyMMddHHmm");

    public static long ttl() {
        return 60L;
    }

    public static long negativeTtl() {
        return 5L;
    }

    public static List<? extends Record> nameservers(Name subdomain) {
        return DomainNames.nameServerRecords(subdomain);
    }

    public static SOARecord sourceOfAuthority(Name name) {
        Name soa = DomainNames.sourceOfAuthority(name);
        Name ns = DomainNames.nameServerRecords(name).get(0).getTarget();
        SOARecord soaRecord = new SOARecord(name, 1, 60L, ns, Name.fromConstantString((String)("root." + soa)), DomainNameRecords.serial(), 1200L, 180L, 2419200L, 5L);
        return soaRecord;
    }

    public static SOARecord sourceOfAuthorityStaticSerial(Name name) {
        Name soa = DomainNames.sourceOfAuthority(name);
        Name ns = DomainNames.nameServerRecords(name).get(0).getTarget();
        SOARecord soaRecord = new SOARecord(name, 1, 60L, ns, Name.fromConstantString((String)("root." + soa)), 1L, 3600L, 600L, 86400L, 3600L);
        return soaRecord;
    }

    public static Record canonicalName(Name aliasName, Name canonicalName) {
        return new CNAMERecord(aliasName, 1, 60L, canonicalName);
    }

    public static InetAddress inAddrArpaToInetAddress(Name name) {
        String ipString = new StringBuffer().append(name.getLabelString(3)).append(".").append(name.getLabelString(2)).append(".").append(name.getLabelString(1)).append(".").append(name.getLabelString(0)).toString();
        return InetAddresses.forString((String)ipString);
    }

    public static Record ptrRecord(Name name, Name inAddrArpa) {
        return DomainNameRecords.ptrRecord(name, DomainNameRecords.inAddrArpaToInetAddress(inAddrArpa));
    }

    public static Record ptrRecord(Name name, InetAddress ip) {
        return new PTRRecord(ReverseMap.fromAddress((InetAddress)ip), 1, 60L, name);
    }

    public static Record addressRecord(Name name, InetAddress ip) {
        return new ARecord(name, 1, 60L, ip);
    }

    static long serial() {
        return Long.parseLong(SERIALFORMATTER.format(new Date()));
    }
}

