/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.dns;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.util.dns.DomainNameRecords;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SetResponse;

@ConfigurableClass(root="dns", description="Configuration options controlling the behaviour of DNS features.")
public class DnsResolvers
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(DnsResolvers.class);
    @ConfigurableField(description="Enable pluggable DNS resolvers.  Note: This must be 'true' for any pluggable resolver to work.  Also, each resolver may need to be separately enabled.See 'euca-describe-properties dns'.")
    public static Boolean enabled = Boolean.TRUE;
    private static final ClassToInstanceMap<DnsResolver> resolvers = MutableClassToInstanceMap.create();

    private static RRset createRRset(Record ... records) {
        RRset rrset = new RRset();
        for (Record r : records) {
            rrset.addRR(r);
        }
        return rrset;
    }

    private static void addRRset(Name name, final Message response, Record[] records, final int section) {
        LinkedHashMultimap rrsets = LinkedHashMultimap.create();
        for (Record r : records) {
            RequestType type = RequestType.typeOf(r.getType());
            rrsets.get((Object)type).addAll(Collections2.filter(Arrays.asList(records), (Predicate)type));
        }
        Predicate<Record> checkNewRecord = new Predicate<Record>(){

            public boolean apply(Record input) {
                for (int s = 1; s <= section; ++s) {
                    if (!response.findRecord(input, s)) continue;
                    return false;
                }
                return true;
            }
        };
        if (rrsets.containsKey((Object)RequestType.CNAME)) {
            for (Record cnames : Iterables.filter((Iterable)rrsets.removeAll((Object)RequestType.CNAME), (Predicate)checkNewRecord)) {
                response.addRecord(cnames, section);
            }
        }
        for (Record sectionRecord : Iterables.filter((Iterable)rrsets.values(), (Predicate)checkNewRecord)) {
            response.addRecord(sectionRecord, section);
        }
    }

    private static Iterable<DnsResolver> resolversFor(final DnsRequest request) {
        return Iterables.filter((Iterable)resolvers.values(), (Predicate)new Predicate<DnsResolver>(){

            public boolean apply(DnsResolver input) {
                try {
                    return input.checkAccepts(request);
                }
                catch (Exception ex) {
                    return false;
                }
            }
        });
    }

    private static SetResponse lookupRecords(Message response, DnsRequest request) {
        Record query = request.getQuery();
        InetAddress source = request.getRemoteAddress();
        Name name = query.getName();
        int type = query.getType();
        response.getHeader().setFlag(8);
        LOG.debug((Object)("DnsResolver: " + (Object)((Object)RequestType.typeOf(type)) + " " + name));
        for (DnsResolver r : DnsResolvers.resolversFor(request)) {
            try {
                DnsResponse reply = r.lookupRecords(request);
                if (reply == null) {
                    LOG.debug((Object)("DnsResolver: returned null " + name + " using " + r));
                    continue;
                }
                if (reply.isAuthoritative()) {
                    response.getHeader().setFlag(5);
                }
                if (reply.isNxdomain()) {
                    try {
                        DnsResolvers.addRRset(name, response, new Record[]{DomainNameRecords.sourceOfAuthority(name)}, type);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    response.getHeader().setRcode(3);
                    return SetResponse.ofType(1);
                }
                if (!reply.hasAnswer()) continue;
                for (ResponseSection s : ResponseSection.values()) {
                    Record[] records = reply.section(s);
                    if (records == null) continue;
                    DnsResolvers.addRRset(name, response, records, s.section());
                }
                return SetResponse.ofType(6);
            }
            catch (Exception ex) {
                LOG.debug((Object)("DnsResolver: failed for " + name + " using " + r + " because of: " + ex.getMessage()), (Throwable)ex);
            }
        }
        return SetResponse.ofType(0);
    }

    @Override
    public boolean processClass(Class candidate) throws Exception {
        if (DnsResolver.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers())) {
            try {
                DnsResolver resolver = (DnsResolver)candidate.newInstance();
                resolvers.putInstance(candidate, (Object)resolver);
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to create instance of DnsResolver: " + candidate + " because of: " + ex.getMessage()));
            }
        }
        return false;
    }

    @Override
    public Double getPriority() {
        return 0.5;
    }

    public static SetResponse findRecords(Message response, DnsRequest request) {
        try {
            if (!enabled.booleanValue() || !Bootstrap.isOperational().booleanValue()) {
                return SetResponse.ofType(0);
            }
            Iterable<DnsResolver> resolverList = DnsResolvers.resolversFor(request);
            if (Iterables.isEmpty(resolverList)) {
                return SetResponse.ofType(0);
            }
            return DnsResolvers.lookupRecords(response, request);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            LOG.trace((Object)ex, (Throwable)ex);
            return SetResponse.ofType(0);
        }
    }

    public static interface DnsResolver {
        public boolean checkAccepts(DnsRequest var1);

        public DnsResponse lookupRecords(DnsRequest var1);

        public String toString();
    }

    public static interface DnsRequest {
        public Record getQuery();

        public InetAddress getRemoteAddress();

        public InetAddress getLocalAddress();
    }

    public static class DnsResponse {
        private final Multimap<ResponseSection, Record> sections = LinkedHashMultimap.create();
        private final Name name;
        private boolean recursive = false;
        private boolean nxdomain = false;

        private DnsResponse(Name name) {
            this.name = name;
        }

        public static Builder forName(Name name) {
            return new Builder(name);
        }

        public boolean hasAnswer() {
            return !this.sections.isEmpty();
        }

        public Record[] section(ResponseSection s) {
            if (this.sections.containsKey((Object)s)) {
                return this.sections.get((Object)s).toArray(new Record[0]);
            }
            return null;
        }

        public boolean isAuthoritative() {
            return !this.recursive;
        }

        public boolean isNxdomain() {
            return this.nxdomain;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public static class Builder {
            private final DnsResponse response;

            Builder(Name name) {
                this.response = new DnsResponse(name);
            }

            public Builder withAuthority(List<Record> records) {
                if (records != null) {
                    this.response.sections.get((Object)ResponseSection.AUTHORITY).addAll(records);
                }
                return this;
            }

            public Builder withAuthority(Record ... records) {
                if (records != null) {
                    return this.withAuthority(Arrays.asList(records));
                }
                return this;
            }

            public Builder withAdditional(List<Record> records) {
                if (records != null) {
                    this.response.sections.get((Object)ResponseSection.ADDITIONAL).addAll(records);
                }
                return this;
            }

            public Builder withAdditional(Record ... records) {
                if (records != null) {
                    return this.withAdditional(Arrays.asList(records));
                }
                return this;
            }

            public Builder recursive() {
                this.response.recursive = true;
                return this;
            }

            public DnsResponse nxdomain() {
                this.response.nxdomain = true;
                return this.response;
            }

            public DnsResponse answer(List<? extends Record> records) {
                if (records != null) {
                    this.response.sections.get((Object)ResponseSection.ANSWER).addAll(records);
                }
                return this.response;
            }

            public DnsResponse answer(Record ... records) {
                if (records != null) {
                    return this.answer(Arrays.asList(records));
                }
                return this.response;
            }
        }
    }

    public static enum ResponseType {
        SUCCESSFUL,
        CNAME,
        DELEGATION,
        DNAME,
        NXDOMAIN,
        NXRRSET,
        UNKNOWN;


        public static ResponseType lookup(SetResponse sr) {
            if (sr.isCNAME()) {
                return CNAME;
            }
            if (sr.isDelegation()) {
                return DELEGATION;
            }
            if (sr.isDNAME()) {
                return DNAME;
            }
            if (sr.isNXDOMAIN()) {
                return NXDOMAIN;
            }
            if (sr.isNXRRSET()) {
                return NXRRSET;
            }
            if (sr.isSuccessful()) {
                return SUCCESSFUL;
            }
            return UNKNOWN;
        }
    }

    public static enum ResponseSection {
        QUESTION,
        ANSWER,
        AUTHORITY,
        ADDITIONAL,
        ZONE{

            @Override
            public int section() {
                return 0;
            }
        }
        ,
        PREREQ{

            @Override
            public int section() {
                return 1;
            }
        }
        ,
        UPDATE{

            @Override
            public int section() {
                return 2;
            }
        };


        public int section() {
            return this.ordinal();
        }
    }

    public static enum RequestType implements Predicate<Record>
    {
        A(1),
        NS(2),
        MD(3),
        MF(4),
        CNAME(5),
        SOA(6),
        MB(7),
        MG(8),
        MR(9),
        NULL(10),
        WKS(11),
        PTR(12),
        HINFO(13),
        MINFO(14),
        MX(15),
        TXT(16),
        RP(17),
        AFSDB(18),
        X25(19),
        ISDN(20),
        RT(21),
        NSAP(22),
        NSAP_PTR(23),
        SIG(24),
        KEY(25),
        PX(26),
        GPOS(27),
        AAAA(28),
        LOC(29),
        NXT(30),
        EID(31),
        NIMLOC(32),
        SRV(33),
        ATMA(34),
        NAPTR(35),
        KX(36),
        CERT(37),
        A6(38),
        DNAME(39),
        OPT(41),
        APL(42),
        DS(43),
        SSHFP(44),
        IPSECKEY(45),
        RRSIG(46),
        NSEC(47),
        DNSKEY(48),
        DHCID(49),
        NSEC3(50),
        NSEC3PARAM(51),
        TLSA(52),
        SPF(99),
        TKEY(249),
        TSIG(250),
        IXFR(251),
        AXFR(252),
        MAILB(253),
        MAILA(254),
        ANY(255),
        DLV(32769);

        private static final Supplier<Map<Integer, RequestType>> backingMap;
        private static final Supplier<Map<Integer, RequestType>> typeMap;
        private final int type;

        private RequestType(int type) {
            this.type = type;
        }

        public boolean apply(Record input) {
            return input.getType() == this.type;
        }

        public static RequestType typeOf(int type) {
            if (!((Map)typeMap.get()).containsKey(type)) {
                throw new IllegalArgumentException("No RequestType with type=" + type);
            }
            return (RequestType)((Object)((Map)typeMap.get()).get(type));
        }

        public int getType() {
            return this.type;
        }

        static {
            backingMap = new Supplier(){

                public Map<Integer, RequestType> get() {
                    return new HashMap(){
                        {
                            for (RequestType t : RequestType.values()) {
                                this.put(t.getType(), t);
                            }
                        }
                    };
                }
            };
            typeMap = Suppliers.memoize(backingMap);
        }
    }
}

