/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.concurrent;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableFieldType;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.concurrent.AbstractFuture;
import com.eucalyptus.util.concurrent.ListenableFuture;
import com.google.common.base.Predicate;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

@ConfigurableClass(root="bootstrap.async", description="Parameters controlling the asynchronous futures and executors.")
public abstract class AbstractListenableFuture<V>
extends AbstractFuture<V>
implements ListenableFuture<V> {
    private static Logger LOG = Logger.getLogger(AbstractListenableFuture.class);
    protected final ConcurrentLinkedQueue<Runnable> listeners = new ConcurrentLinkedQueue();
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private static final Runnable DONE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread s = Executors.defaultThreadFactory().newThread(r);
            s.setName("AbstractListenableFuture: " + r);
            return s;
        }
    });
    @ConfigurableField(description="Number of seconds a future listener can execute before a debug message is logged.", type=ConfigurableFieldType.PRIVATE)
    public static Long FUTURE_LISTENER_DEBUG_LIMIT_SECS = 30L;
    @ConfigurableField(description="Number of seconds a future listener can execute before an info message is logged.", type=ConfigurableFieldType.PRIVATE)
    public static Long FUTURE_LISTENER_INFO_LIMIT_SECS = 60L;
    @ConfigurableField(description="Number of seconds a future listener can execute before an error message is logged.", type=ConfigurableFieldType.PRIVATE)
    public static Long FUTURE_LISTENER_ERROR_LIMIT_SECS = 120L;
    @ConfigurableField(description="Number of seconds a future listener's executor waits to get() per call.", type=ConfigurableFieldType.PRIVATE)
    public static Long FUTURE_LISTENER_GET_TIMEOUT = 30L;
    @ConfigurableField(description="Total number of seconds a future listener's executor waits to get().", type=ConfigurableFieldType.PRIVATE)
    public static Integer FUTURE_LISTENER_GET_RETRIES = 8;
    private static final Predicate<StackTraceElement> filter = Threads.filterStackByQualifiedName("com.eucalyptus.*");
    private final String startingStack = Threads.currentStackString();

    protected AbstractListenableFuture() {
    }

    protected <T> void add(ExecPair<T> pair) {
        this.listeners.add(pair);
        if (this.finished.get()) {
            EventRecord.here(pair.getClass(), EventType.FUTURE, "run(" + pair.toString() + ")").exhaust();
            this.listeners.remove(pair);
            pair.run();
        } else {
            EventRecord.here(pair.getClass(), EventType.FUTURE, "add(" + pair.toString() + ")").exhaust();
        }
    }

    @Override
    public void addListener(final Runnable listener, ExecutorService exec) {
        ExecPair pair = new ExecPair(new Callable(){

            public Object call() throws Exception {
                listener.run();
                return null;
            }

            public String toString() {
                return "ListenableFuture.ExecPair.listener " + listener + " [" + Thread.currentThread().getStackTrace()[2] + "]";
            }
        }, exec);
        this.add(pair);
    }

    @Override
    public void addListener(Runnable listener) {
        this.addListener(listener, executor);
    }

    @Override
    public <T> CheckedListenableFuture<T> addListener(Callable<T> listener, ExecutorService executor) {
        ExecPair pair = new ExecPair(listener, executor);
        this.add(pair);
        return pair.getFuture();
    }

    @Override
    public <T> CheckedListenableFuture<T> addListener(Callable<T> listener) {
        return this.addListener(listener, executor);
    }

    @Override
    protected void done() {
        this.listeners.add(DONE);
        if (this.finished.compareAndSet(false, true)) {
            while (this.listeners.peek() != DONE) {
                this.listeners.poll().run();
            }
        }
    }

    @Override
    public boolean set(V value) {
        return super.set(value);
    }

    @Override
    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }

    class ExecPair<C>
    implements Runnable {
        private Callable<C> callable;
        private Runnable runnable;
        private final CheckedListenableFuture<C> future = Futures.newGenericeFuture();
        private final ExecutorService executor;
        private static final String message = "Listener failed to execute within the time limit (%d): %s using executor %s";

        ExecPair(Callable callable, ExecutorService executor) {
            Parameters.checkParam("BUG: callable is null.", callable, Matchers.notNullValue());
            Parameters.checkParam("BUG: executor is null.", executor, Matchers.notNullValue());
            this.callable = callable;
            this.executor = executor;
        }

        ExecPair(Callable<C> callable) {
            this(callable, executor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                final long startTime = System.currentTimeMillis();
                Predicate timeoutLogger = new Predicate<Callable<C>>(){

                    public boolean apply(@Nullable Callable<C> input) {
                        try {
                            long elapsed = System.currentTimeMillis() - startTime;
                            long seconds = TimeUnit.MILLISECONDS.toSeconds(elapsed);
                            String details = ExecPair.this.callable.toString() + " [" + Threads.filteredStack((Predicate<StackTraceElement>)filter).iterator().next() + "]";
                            if (seconds > FUTURE_LISTENER_DEBUG_LIMIT_SECS) {
                                LOG.debug((Object)String.format(ExecPair.message, FUTURE_LISTENER_DEBUG_LIMIT_SECS, details, ExecPair.this.executor.toString()));
                                return true;
                            }
                            if (seconds > FUTURE_LISTENER_INFO_LIMIT_SECS) {
                                LOG.info((Object)String.format(ExecPair.message, FUTURE_LISTENER_INFO_LIMIT_SECS, details, ExecPair.this.executor.toString()));
                                return true;
                            }
                            if (seconds > FUTURE_LISTENER_ERROR_LIMIT_SECS) {
                                LOG.error((Object)String.format(ExecPair.message, FUTURE_LISTENER_ERROR_LIMIT_SECS, details, ExecPair.this.executor.toString()));
                                return true;
                            }
                            LOG.trace((Object)String.format("Listener still within time limit (%d): %s using executor %s", FUTURE_LISTENER_ERROR_LIMIT_SECS, details, ExecPair.this.executor.toString()));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e);
                        }
                        return false;
                    }
                };
                Future<C> execFuture = this.executor.submit(this.callable);
                for (int iterations = 0; !Bootstrap.isOperational().booleanValue() && !Bootstrap.isShuttingDown().booleanValue() || iterations < FUTURE_LISTENER_GET_RETRIES; ++iterations) {
                    try {
                        C outcome = execFuture.get(FUTURE_LISTENER_GET_TIMEOUT, TimeUnit.SECONDS);
                        this.future.set(outcome);
                        break;
                    }
                    catch (TimeoutException e) {
                        continue;
                    }
                    finally {
                        if (timeoutLogger.apply(this.callable)) {
                            Logs.exhaust().debug((Object)("Intial Stack: \n" + AbstractListenableFuture.this.startingStack));
                            Logs.exhaust().debug((Object)("Current Stack: \n" + Threads.currentStackString()));
                        }
                    }
                }
                if (!this.future.isDone()) {
                    String message = "Failed to invoke listener for " + AbstractListenableFuture.this + " of type: " + (this.runnable != null ? this.runnable : this.callable);
                    LOG.error((Object)message);
                    LOG.error((Object)AbstractListenableFuture.this.startingStack);
                    throw new TimeoutException(message);
                }
            }
            catch (InterruptedException ex) {
                LOG.error((Object)ex);
                Thread.currentThread().interrupt();
                this.future.setException(ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.future.setException(ex.getCause());
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                this.future.setException(ex.getCause());
            }
        }

        CheckedListenableFuture<C> getFuture() {
            return this.future;
        }

        protected ExecutorService getExecutor() {
            return this.executor;
        }

        public String toString() {
            return String.format("ExecPair:callable=%s:runnable=%s", this.callable, this.runnable);
        }
    }
}

