/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.async.RemoteCallback;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public abstract class MessageCallback<Q extends BaseMessage, R extends BaseMessage>
implements RemoteCallback<Q, R> {
    private Logger LOG = Logger.getLogger(this.getClass());
    private final AtomicReference<Q> request = new AtomicReference<Object>(null);

    protected MessageCallback() {
    }

    protected MessageCallback(Q request) {
        if (((BaseMessage)request).getUserId() == null) {
            ((BaseMessage)request).setUser(Principals.systemUser());
        }
        this.request.set(request);
    }

    @Override
    public Q getRequest() {
        return (Q)((BaseMessage)this.request.get());
    }

    protected void setRequest(Q request) {
        BaseMessage oldReq = null;
        oldReq = (BaseMessage)this.request.getAndSet(request);
        if (oldReq != null) {
            Logs.extreme().error((Object)("Request has been set twice.  Old message was: " + oldReq), (Throwable)new IllegalStateException("Request has been set twice."));
        }
    }

    @Override
    public void initialize(Q request) throws Exception {
        Logs.extreme().trace((Object)(this.getClass() + ":" + ((BaseMessage)this.request.get()).getClass().getSimpleName() + " should implement: initialize( ) to check any preconditions!"));
    }

    @Override
    public abstract void fire(R var1);

    @Override
    public void fireException(Throwable t) {
        Logs.extreme().error((Object)(this.getClass() + ":" + ((BaseMessage)this.request.get()).getClass().getSimpleName() + " should implement: fireException( Throwable t ) to handle errors!"));
        Logs.exhaust().error((Object)t, t);
    }
}

