/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.concurrent.GenericCheckedListenableFuture;
import com.eucalyptus.util.concurrent.ListenableFuture;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class Futures {
    private static Logger LOG = Logger.getLogger(Futures.class);

    private static <T> Predicate<Map.Entry<T, Future<T>>> waitForResults() {
        WaitForResults func = WaitForResults.INSTANCE;
        return func;
    }

    public static <T> Map<T, Future<T>> waitAll(Map<T, Future<T>> futures) {
        Predicate<Map.Entry<T, Future<T>>> func = Futures.waitForResults();
        Map res = Maps.filterEntries(futures, func);
        return res;
    }

    public static <T> RunnableFuture<T> resultOf(Callable<T> call) {
        return new FutureTask<T>(call);
    }

    public static <T> CheckedListenableFuture<T> newGenericeFuture() {
        return new GenericCheckedListenableFuture();
    }

    public static <T> CheckedListenableFuture<T> predestinedFuture(final T initValue) {
        return new GenericCheckedListenableFuture<T>(){
            {
                this.set(initValue);
            }
        };
    }

    public static <T> CheckedListenableFuture<T> predestinedFailedFuture(final Throwable exValue) {
        return new GenericCheckedListenableFuture<T>(){
            {
                this.setException(exValue);
            }
        };
    }

    public static <T extends ListenableFuture<V>, V> Callable<T> combine(final Callable<T> firstCall, final Callable<T> secondCall) {
        final CheckedListenableFuture<T> resultFuture = Futures.newGenericeFuture();
        final CheckedListenableFuture<T> intermediateFuture = Futures.newGenericeFuture();
        Callable chainingCallable = new Callable<T>(){

            public String toString() {
                return Callable.class.getSimpleName() + ":[" + firstCall.toString() + "] ==> " + secondCall.toString();
            }

            @Override
            public T call() {
                try {
                    try {
                        ListenableFuture res = (ListenableFuture)firstCall.call();
                        intermediateFuture.set(res);
                    }
                    catch (Exception ex) {
                        resultFuture.setException(ex);
                        intermediateFuture.setException(ex);
                    }
                    Threads.lookup(Empyrean.class, Futures.class).submit(new Runnable(){

                        public String toString() {
                            return Runnable.class.getSimpleName() + ":" + firstCall.toString() + " ==> [" + secondCall.toString() + "]";
                        }

                        @Override
                        public void run() {
                            try {
                                ((ListenableFuture)intermediateFuture.get()).get();
                                try {
                                    ListenableFuture res2 = (ListenableFuture)secondCall.call();
                                    resultFuture.set(res2.get());
                                }
                                catch (Exception ex) {
                                    resultFuture.setException(ex);
                                }
                            }
                            catch (InterruptedException ex) {
                                LOG.error((Object)ex);
                                Thread.currentThread().interrupt();
                                resultFuture.setException(ex);
                            }
                            catch (ExecutionException ex) {
                                resultFuture.setException(ex.getCause());
                            }
                            catch (Exception ex) {
                                resultFuture.setException(ex);
                            }
                        }
                    }).get();
                }
                catch (InterruptedException ex1) {
                    Thread.currentThread().interrupt();
                    resultFuture.setException(ex1);
                }
                catch (RejectedExecutionException ex1) {
                    resultFuture.setException(ex1);
                }
                catch (Exception ex1) {
                    resultFuture.setException(ex1);
                }
                return resultFuture;
            }
        };
        return chainingCallable;
    }

    public static <P> Callable<CheckedListenableFuture<P>> sequence(Callable<CheckedListenableFuture<P>> ... callables) {
        Parameters.checkParam(callables, Matchers.not((Matcher)Matchers.emptyArray()));
        if (callables.length == 1) {
            return callables[0];
        }
        if (callables.length == 2) {
            return Futures.combine(callables[0], callables[1]);
        }
        Callable<CheckedListenableFuture<P>>[] nextCallables = Arrays.copyOfRange(callables, 1, callables.length);
        nextCallables[0] = Futures.combine(callables[0], callables[1]);
        return Futures.sequence(nextCallables);
    }

    public static <R> CheckedListenableFuture<List<R>> allAsList(List<CheckedListenableFuture<R>> futures) {
        final GenericCheckedListenableFuture<List<R>> combined = new GenericCheckedListenableFuture<List<R>>();
        final ArrayList resultList = Lists.newArrayListWithCapacity((int)futures.size());
        Iterables.addAll((Collection)resultList, (Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new Object[]{null}), (int)futures.size()));
        final AtomicInteger completionCountdown = new AtomicInteger(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            final int resultIndex = i;
            final CheckedListenableFuture<R> future = futures.get(i);
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        resultList.set(resultIndex, future.get());
                    }
                    catch (ExecutionException e) {
                        combined.setException(e.getCause());
                    }
                    catch (CancellationException e) {
                        combined.cancel(false);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (completionCountdown.decrementAndGet() == 0) {
                        combined.set(resultList);
                    }
                }
            });
        }
        return combined;
    }

    static enum WaitForResults implements Predicate<Map.Entry<?, Future<?>>>
    {
        INSTANCE;


        public boolean apply(Map.Entry<?, Future<?>> input) {
            try {
                Object result = input.getValue().get();
                LOG.trace((Object)("Operation succeeded for " + result));
                return true;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                Logs.extreme().trace((Object)ex, (Throwable)ex);
            }
            return false;
        }
    }
}

