/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.async.CheckedListenableFuture;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class Callbacks {
    private static Logger LOG = Logger.getLogger(Callbacks.class);

    public static Callback forCallable(final Callable callable) {
        return new Callback(){

            public void fire(Object t) {
                try {
                    callable.call();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };
    }

    public static Callback forRunnable(final Runnable runnable) {
        return new Callback(){

            public void fire(Object t) {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
            }
        };
    }

    public static <T> Callback<T> noop() {
        return new NoopCallback();
    }

    public static <R> Callback.Failure<R> noopFailure() {
        return new NoopFailure();
    }

    public static Runnable addListenerHandler(CheckedListenableFuture<?> future, Callback<?> listener) {
        BasicCallbackProcessor r = new BasicCallbackProcessor(future, listener);
        future.addListener(r, (ExecutorService)Threads.lookup(Empyrean.class, Callbacks.class, BasicCallbackProcessor.class.toString()));
        return r;
    }

    static class BasicCallbackProcessor<R extends BaseMessage>
    implements Runnable {
        private final Callback<R> callback;
        private final Future<R> future;
        private final Logger log;

        private BasicCallbackProcessor(Future<R> future, Callback<R> callback) {
            this.callback = callback;
            this.future = future;
            this.log = Logger.getLogger(this.callback.getClass());
        }

        @Override
        public void run() {
            BaseMessage reply = null;
            try {
                reply = (BaseMessage)this.future.get();
                try {
                    EventRecord.here(this.getClass(), EventType.CALLBACK, "fire(" + reply.getClass().getSimpleName() + ")").exhaust();
                    this.callback.fire(reply);
                }
                catch (Throwable ex) {
                    EventRecord.here(this.getClass(), EventType.CALLBACK, "FAILED", "fire(" + reply.getClass().getSimpleName() + ")", ex.getMessage()).exhaust();
                    this.doFail(ex);
                }
            }
            catch (Throwable e) {
                EventRecord.here(this.getClass(), EventType.FUTURE, "FAILED", "get()", e.getMessage()).exhaust();
                this.doFail(e);
            }
        }

        private final void doFail(Throwable failure) {
            EventRecord.here(BasicCallbackProcessor.class, EventType.CALLBACK, this.callback.getClass().toString(), "fireException(" + failure.getClass().getSimpleName() + ")").exhaust();
            this.log.trace((Object)failure.getMessage(), failure);
            if (this.callback instanceof Callback.Checked) {
                ((Callback.Checked)this.callback).fireException(failure);
            } else if (this.callback instanceof Callback.Completion) {
                ((Callback.Completion)this.callback).fireException(failure);
            }
        }

        public String toString() {
            return String.format("BasicCallbackProcessor:callback=%s", this.callback.getClass().getName().replaceAll("^(\\w.)*", ""));
        }
    }

    private static final class NoopFailure<R>
    extends Callback.Failure<R> {
        private NoopFailure() {
        }

        @Override
        public void fireException(Throwable t) {
        }
    }

    private static final class NoopCallback<T>
    implements Callback<T> {
        private NoopCallback() {
        }

        @Override
        public final void fire(T t) {
        }
    }
}

