/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.async.UnconditionalCallback;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.List;
import org.apache.log4j.Logger;

public class CallbackListenerSequence<R extends BaseMessage>
implements Callback.Checked<R> {
    private Logger LOG = Logger.getLogger(this.getClass());
    private List<Callback<? super R>> successCallbacks = Lists.newArrayList();
    private List<Callback.Checked<? super R>> failureCallbacks = Lists.newArrayList();

    public CallbackListenerSequence<R> addCallback(final UnconditionalCallback<? super R> c) {
        EventRecord.caller(CallbackListenerSequence.class, EventType.CALLBACK, UnconditionalCallback.class.getSimpleName(), c.getClass()).extreme();
        this.successCallbacks.add(c);
        this.failureCallbacks.add(new Callback.Failure<Object>(){

            @Override
            public void fireException(Throwable t) {
                c.fire();
            }
        });
        return this;
    }

    public CallbackListenerSequence<R> addCallback(Callback.Checked<? super R> c) {
        EventRecord.caller(CallbackListenerSequence.class, EventType.CALLBACK, Callback.Checked.class.getSimpleName(), c.getClass()).extreme();
        this.successCallbacks.add(c);
        this.failureCallbacks.add(c);
        return this;
    }

    public CallbackListenerSequence<R> addSuccessCallback(Callback.Success<? super R> c) {
        EventRecord.caller(CallbackListenerSequence.class, EventType.CALLBACK, Callback.Success.class.getSimpleName(), c.getClass()).extreme();
        this.successCallbacks.add(c);
        return this;
    }

    public CallbackListenerSequence<R> addFailureCallback(Callback.Failure<? super R> c) {
        EventRecord.caller(CallbackListenerSequence.class, EventType.CALLBACK, Callback.Failure.class.getSimpleName(), c.getClass()).extreme();
        this.failureCallbacks.add(c);
        return this;
    }

    @Override
    public void fire(R response) {
        EventRecord.here(CallbackListenerSequence.class, EventType.CALLBACK, "fire(" + response.getClass().getName() + ")").extreme();
        for (Callback<R> cb : this.successCallbacks) {
            try {
                EventRecord.here(this.getClass(), EventType.CALLBACK, "" + cb.getClass(), "fire(" + response.getClass().getCanonicalName() + ")").extreme();
                cb.fire(response);
            }
            catch (Exception t) {
                this.LOG.error((Object)("Exception occurred while trying to call: " + cb.getClass() + ".apply( " + t.getMessage() + " )"));
                this.LOG.error((Object)t, (Throwable)t);
            }
        }
    }

    @Override
    public void fireException(Throwable t) {
        EventRecord.here(CallbackListenerSequence.class, EventType.CALLBACK, "fireException(" + t.getClass().getName() + ")").extreme();
        for (Callback.Checked<R> cb : this.failureCallbacks) {
            try {
                EventRecord.here(this.getClass(), EventType.CALLBACK, "" + cb.getClass(), "fireException(" + t.getClass().getCanonicalName() + ")").extreme();
                cb.fireException(t);
            }
            catch (Exception t2) {
                this.LOG.error((Object)("Exception occurred while trying to call: " + cb.getClass() + ".failure( " + t.getMessage() + " )"));
                this.LOG.error((Object)t2, (Throwable)t2);
            }
        }
    }
}

