/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.concurrent.GenericCheckedListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class AsyncResponseFuture<R>
extends GenericCheckedListenableFuture<R> {
    private static Logger LOG = Logger.getLogger(AsyncResponseFuture.class);

    AsyncResponseFuture() {
    }

    @Override
    public boolean setException(Throwable exception) {
        boolean r = super.setException(exception);
        if (r) {
            EventRecord.caller(this.getClass(), EventType.FUTURE, "setException(" + exception.getClass().getCanonicalName() + "): " + exception.getMessage()).trace();
        } else {
            Logs.exhaust().debug((Object)("Duplicate exception: " + exception.getMessage()));
        }
        return r;
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return (R)super.get(timeout, unit);
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        return (R)super.get();
    }

    @Override
    public boolean set(R reply) {
        boolean r = super.set(reply);
        if (r) {
            EventRecord.caller(this.getClass(), EventType.FUTURE, "set(" + reply.getClass().getCanonicalName() + ")").trace();
        } else {
            Logs.exhaust().debug((Object)("Duplicate response: " + reply));
        }
        return r;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return super.cancel();
    }

    @Override
    public boolean isCanceled() {
        return super.isCancelled();
    }
}

