/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.ServiceContext;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.async.AsyncRequest;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.util.async.MessageCallback;
import com.eucalyptus.util.async.RemoteCallback;
import com.eucalyptus.util.async.Request;
import com.google.common.base.Optional;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.CallerContext;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class AsyncRequests {
    private static Logger LOG = Logger.getLogger(AsyncRequests.class);
    private static final int LOCAL_THREADS = 64;

    public static <A extends BaseMessage, B extends BaseMessage> CheckedListenableFuture<B> dispatch(final ServiceConfiguration config, final A msg) throws Exception {
        if (config.isVmLocal().booleanValue()) {
            final CheckedListenableFuture future = Futures.newGenericeFuture();
            Threads.enqueue(Empyrean.class, AsyncRequests.class, (Integer)64, new Callable<B>(){

                @Override
                public B call() {
                    try {
                        BaseMessage ret = (BaseMessage)ServiceContext.send(config.getComponentId(), (Object)msg);
                        future.set(ret);
                    }
                    catch (Exception ex) {
                        future.setException(ex);
                    }
                    return null;
                }
            });
            return future;
        }
        Request<A, B> req = AsyncRequests.newRequest(new MessageCallback<A, B>(){
            {
                this.setRequest(msg);
            }

            @Override
            public void fire(B msg2) {
                Logs.extreme().debug((Object)((BaseMessage)msg2).toSimpleString());
            }
        });
        return req.dispatch(config);
    }

    public static <A extends BaseMessage, B extends BaseMessage> B sendSync(Class<? extends ComponentId> target, A msg) throws Exception {
        return AsyncRequests.sendSync(Topology.lookup(target, new Partition[0]), (Optional<CallerContext>)Optional.absent(), msg);
    }

    public static <A extends BaseMessage, B extends BaseMessage> B sendSync(ServiceConfiguration config, A msg) throws Exception {
        return AsyncRequests.sendSync(config, (Optional<CallerContext>)Optional.absent(), msg);
    }

    public static <A extends BaseMessage, B extends BaseMessage> B sendSyncWithCurrentIdentity(ServiceConfiguration config, A msg) throws Exception {
        return AsyncRequests.sendSync(config, (Optional<CallerContext>)Optional.of((Object)new CallerContext(Contexts.lookup())), msg);
    }

    private static <A extends BaseMessage, B extends BaseMessage> B sendSync(ServiceConfiguration config, Optional<CallerContext> callerContext, final A msg) throws Exception {
        if (callerContext.isPresent()) {
            ((CallerContext)callerContext.get()).apply(msg);
        }
        if (config.isVmLocal().booleanValue()) {
            return (B)((BaseMessage)ServiceContext.send(config.getComponentId(), msg));
        }
        try {
            Request<A, B> req = AsyncRequests.newRequest(new MessageCallback<A, B>(){
                {
                    this.setRequest(msg);
                }

                @Override
                public void fire(B msg2) {
                    Logs.extreme().debug((Object)((BaseMessage)msg2).toSimpleString());
                }
            });
            return req.sendSync(config);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw ex;
        }
    }

    @Deprecated
    public static void dispatchSafely(Request<?, ?> request, String clusterOrPartition) {
        try {
            request.dispatch(clusterOrPartition);
        }
        catch (NoSuchElementException e) {
            request.getCallback().fireException(e);
        }
    }

    public static <A extends BaseMessage, B extends BaseMessage> Request<A, B> newRequest(final RemoteCallback<A, B> msgCallback) {
        return new AsyncRequest<A, B>(msgCallback){
            {
                super(x0);
                this.setRequest(msgCallback.getRequest());
            }
        };
    }
}

