/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util.async;

import com.eucalyptus.component.Components;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.AsyncRequestHandler;
import com.eucalyptus.util.async.AsyncResponseFuture;
import com.eucalyptus.util.async.CallbackListenerSequence;
import com.eucalyptus.util.async.Callbacks;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Request;
import com.eucalyptus.util.async.RequestException;
import com.eucalyptus.util.async.RequestHandler;
import com.eucalyptus.util.async.RequestInitializationException;
import com.eucalyptus.util.async.UnconditionalCallback;
import com.google.common.collect.Iterables;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class AsyncRequest<Q extends BaseMessage, R extends BaseMessage>
implements Request<Q, R> {
    private static Logger LOG = Logger.getLogger(AsyncRequest.class);
    private final Callback.TwiceChecked<Q, R> wrapperCallback;
    private final CheckedListenableFuture<R> requestResult;
    private final CheckedListenableFuture<R> result = new AsyncResponseFuture();
    private final RequestHandler<Q, R> handler;
    private final CallbackListenerSequence<R> callbackSequence;
    private Q request;
    public static Integer NUM_WORKERS = 8;

    protected AsyncRequest(final Callback.TwiceChecked<Q, R> cb) {
        this.requestResult = new AsyncResponseFuture();
        this.handler = new AsyncRequestHandler(this, this.requestResult);
        this.callbackSequence = new CallbackListenerSequence();
        this.wrapperCallback = new Callback.TwiceChecked<Q, R>(){

            @Override
            public void fireException(Throwable t) {
                try {
                    cb.fireException(t);
                    AsyncRequest.this.result.setException(t);
                }
                catch (Exception ex) {
                    AsyncRequest.this.result.setException(t);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
                try {
                    AsyncRequest.this.callbackSequence.fireException(t);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                }
            }

            @Override
            public void fire(R r) {
                try {
                    Logs.extreme().debug((Object)(cb.getClass().getCanonicalName() + ".fire():\n" + r));
                    cb.fire(r);
                    AsyncRequest.this.result.set(r);
                    try {
                        AsyncRequest.this.callbackSequence.fire(r);
                    }
                    catch (Exception ex) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        AsyncRequest.this.result.setException(ex);
                    }
                }
                catch (RuntimeException ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    try {
                        cb.fireException(ex);
                    }
                    catch (Exception ex1) {
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                    }
                    AsyncRequest.this.result.setException(ex);
                    AsyncRequest.this.callbackSequence.fireException(ex);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    try {
                        cb.fireException(ex);
                    }
                    catch (Exception ex1) {
                        Logs.extreme().error((Object)ex1, (Throwable)ex1);
                    }
                    AsyncRequest.this.result.setException(ex);
                    AsyncRequest.this.callbackSequence.fireException(ex);
                }
            }

            @Override
            public void initialize(Q request) throws Exception {
                Logs.extreme().debug((Object)(cb.getClass().getCanonicalName() + ".initialize():\n" + request));
                try {
                    cb.initialize(request);
                }
                catch (Exception ex) {
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    AsyncRequest.this.result.setException(ex);
                    AsyncRequest.this.callbackSequence.fireException(ex);
                    throw ex;
                }
            }

            public String toString() {
                return AsyncRequest.class.getSimpleName() + ":" + cb.toString();
            }
        };
        Callbacks.addListenerHandler(this.requestResult, this.wrapperCallback);
    }

    @Override
    public CheckedListenableFuture<R> dispatch(String clusterOrPartition) {
        ServiceConfiguration serviceConfig;
        block5: {
            serviceConfig = null;
            if (Partitions.exists(clusterOrPartition)) {
                Partition partition = Partitions.lookupByName(clusterOrPartition);
                try {
                    serviceConfig = Topology.lookup(ClusterController.class, partition);
                }
                catch (Exception ex) {
                    Iterable serviceInPartition = Iterables.filter(Components.lookup(ClusterController.class).services(), ServiceConfigurations.filterByPartition(partition));
                    if (!serviceInPartition.iterator().hasNext()) break block5;
                    serviceConfig = (ServiceConfiguration)serviceInPartition.iterator().next();
                }
            }
        }
        if (serviceConfig == null) {
            serviceConfig = (ServiceConfiguration)ServiceConfigurations.lookupByName(ClusterController.class, clusterOrPartition);
        }
        if (serviceConfig != null) {
            return this.dispatch(serviceConfig);
        }
        throw new NoSuchElementException("Failed to lookup service configuration named: " + clusterOrPartition);
    }

    @Override
    public CheckedListenableFuture<R> dispatch(final ServiceConfiguration serviceConfig) {
        Callable call = new Callable<CheckedListenableFuture<R>>(){

            public String toString() {
                return AsyncRequest.class.getSimpleName() + ":" + serviceConfig.getFullName() + ":" + ((BaseMessage)AsyncRequest.this.getRequest()).toSimpleString();
            }

            @Override
            public CheckedListenableFuture<R> call() throws Exception {
                try {
                    Request execute = AsyncRequest.this.execute(serviceConfig);
                    return execute.getResponse();
                }
                catch (Exception ex) {
                    AsyncRequest.this.result.setException(ex);
                    Logs.extreme().error((Object)ex, (Throwable)ex);
                    throw ex;
                }
            }
        };
        try {
            try {
                ((BaseMessage)this.getRequest()).lookupAndSetCorrelationId();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Future res = Threads.enqueue(serviceConfig, call);
            return this.getResponse();
        }
        catch (Exception ex1) {
            LOG.error((Object)ex1);
            Logs.extreme().error((Object)ex1, (Throwable)ex1);
            Future res = Threads.lookup(Empyrean.class, AsyncRequest.class, serviceConfig.getFullName().toString()).limitTo(NUM_WORKERS).submit(call);
            return this.getResponse();
        }
    }

    @Override
    public R sendSync(ServiceConfiguration serviceConfig) throws ExecutionException, InterruptedException {
        try {
            ((BaseMessage)this.getRequest()).lookupAndSetCorrelationId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Request<Q, R> asyncRequest = this.execute(serviceConfig);
        return (R)((BaseMessage)asyncRequest.getResponse().get());
    }

    public Request<Q, R> execute(ServiceConfiguration config) {
        this.doInitializeCallback(config);
        try {
            Logs.extreme().debug((Object)("fire: endpoint " + config));
            if (!this.handler.fire(config, this.request)) {
                Logs.extreme().error((Object)("Error occurred while trying to send request: " + this.request));
                RequestException ex = new RequestException("Error occured attempting to fire the request.", (BaseMessage)this.getRequest());
                try {
                    this.result.setException(ex);
                }
                catch (Exception exception) {}
            } else {
                this.requestResult.get();
            }
        }
        catch (Exception ex) {
            Exceptions.maybeInterrupted(ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
            this.result.setException(ex);
            throw Exceptions.toUndeclared(ex);
        }
        return this;
    }

    private void doInitializeCallback(ServiceConfiguration config) throws RequestException {
        Logs.extreme().info((Object)("initialize: endpoint " + config + " request " + this.request.getClass().getSimpleName() + ":" + ((BaseMessage)this.request).toSimpleString()));
        try {
            this.wrapperCallback.initialize(this.request);
        }
        catch (Exception e) {
            Logs.extreme().error((Object)e.getMessage(), (Throwable)e);
            RequestException ex = e instanceof RequestException ? (RequestException)e : new RequestInitializationException(this.wrapperCallback.getClass().getSimpleName() + " failed: " + e.getMessage(), e, (BaseMessage)this.getRequest());
            this.result.setException(ex);
            throw ex;
        }
    }

    @Override
    public Request<Q, R> then(UnconditionalCallback<? super R> callback) {
        this.callbackSequence.addCallback(callback);
        return this;
    }

    @Override
    public Request<Q, R> then(Callback.Completion<? super R> callback) {
        this.callbackSequence.addCallback(callback);
        return this;
    }

    @Override
    public Request<Q, R> then(Callback.Failure<? super R> callback) {
        this.callbackSequence.addFailureCallback(callback);
        return this;
    }

    @Override
    public Request<Q, R> then(Callback.Success<? super R> callback) {
        this.callbackSequence.addSuccessCallback(callback);
        return this;
    }

    @Override
    public Callback.TwiceChecked<Q, R> getCallback() {
        return this.wrapperCallback;
    }

    @Override
    public CheckedListenableFuture<R> getResponse() {
        return this.result;
    }

    @Override
    public Q getRequest() {
        return this.request;
    }

    protected void setRequest(Q request) {
        this.request = request;
    }

    public String toString() {
        return String.format("AsyncRequest:callback=%s", this.wrapperCallback);
    }
}

