/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.apache.xml.dtm.ref.DTMNodeList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParser {
    private static Logger LOG = Logger.getLogger(XMLParser.class);
    private DocumentBuilder docBuilder;
    private Document docRoot;
    private XPath xpath = XPathFactory.newInstance().newXPath();
    private File file;
    private String rawData;

    public XMLParser() {
        this.docBuilder = XMLParser.getDocBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLParser(File file) {
        this();
        this.file = file;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            this.docRoot = this.docBuilder.parse(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public XMLParser(String xmlData) {
        this();
        this.rawData = xmlData;
        ByteArrayInputStream in = new ByteArrayInputStream(xmlData.getBytes());
        try {
            this.docRoot = this.docBuilder.parse(in);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static DocumentBuilderFactory getDocBuilderFactory() {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setExpandEntityReferences(false);
        try {
            dFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            dFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        try {
            dFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return dFactory;
    }

    public static DocumentBuilder getDocBuilder() {
        DocumentBuilderFactory dFactory = XMLParser.getDocBuilderFactory();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return dBuilder;
    }

    public static DocumentBuilder getDocBuilderWithDTD() {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        dFactory.setExpandEntityReferences(false);
        try {
            dFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dFactory.newDocumentBuilder();
            dBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
        }
        catch (ParserConfigurationException ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
        return dBuilder;
    }

    public String getValue(String name) {
        try {
            return (String)this.xpath.evaluate(name, this.docRoot, XPathConstants.STRING);
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getValue(Node node, String name) {
        try {
            return (String)this.xpath.evaluate(name, node, XPathConstants.STRING);
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public List<String> getValues(String name) {
        try {
            DTMNodeList nodes = (DTMNodeList)this.xpath.evaluate(name, this.docRoot, XPathConstants.NODESET);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                values.add(nodes.item(i).getFirstChild().getNodeValue());
            }
            return values;
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public DTMNodeList getNodes(String name) {
        try {
            DTMNodeList nodes = (DTMNodeList)this.xpath.evaluate(name, this.docRoot, XPathConstants.NODESET);
            return nodes;
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXML(String name) {
        if (this.rawData == null) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
                this.rawData = "";
                byte[] bytes = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = in.read(bytes)) > 0) {
                    this.rawData = this.rawData + new String(bytes, 0, bytesRead);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String startString = new String("<" + name + ">");
        String endString = new String("</" + name + ">");
        int start = this.rawData.indexOf(startString);
        int end = this.rawData.indexOf(endString);
        if (end > start) {
            return this.rawData.substring(start, end += endString.length());
        }
        return null;
    }
}

