/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import groovy.sql.Sql;
import java.io.Serializable;
import java.util.concurrent.Callable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

public class UniqueIds
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(UniqueIds.class);
    private static final Long BLOCK_SIZE = 1000L;
    private static final LoadingCache<String, Function<Long, Long>> counterMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Function<Long, Long>>(){

        public Function<Long, Long> load(final String counterName) {
            return new Function<Long, Long>(){

                public Long apply(Long arg0) {
                    Long ret = 0L;
                    try {
                        PersistedCounter entity = Entities.uniqueResult(new PersistedCounter(null, counterName));
                        ret = entity.nextBlock(arg0);
                        return ret;
                    }
                    catch (Exception ex) {
                        try {
                            PersistedCounter entity = Entities.persist(new PersistedCounter(0L, counterName));
                            ret = entity.nextBlock(arg0);
                            return ret;
                        }
                        catch (Exception ex1) {
                            LOG.error((Object)ex1, (Throwable)ex1);
                            throw Exceptions.toUndeclared((String)("Failed to initialize counter for: " + counterName + " because of: " + ex.getMessage()), (Throwable[])new Exception[]{ex});
                        }
                    }
                }
            };
        }
    });

    public static Long nextIndex(Class c, long extent) {
        return UniqueIds.nextIndex(c.toString(), extent);
    }

    public static String nextId(Class c) {
        return UniqueIds.nextId(c.toString());
    }

    public static String nextId() {
        return UniqueIds.nextId("SYSTEM");
    }

    private static String nextId(String counterName) {
        return (String)PersistedCounter.Transaction.NEXT_INDEX.apply(UniqueIds.nextIndex(counterName, 1L));
    }

    private static Long nextIndex(String counterName, long extent) {
        return (Long)Entities.asTransaction(PersistedCounter.class, (Function)counterMap.getUnchecked((Object)counterName), 1000).apply((Object)extent);
    }

    @Upgrades.PreUpgrade(value=Empyrean.class, since=Upgrades.Version.v3_2_0)
    public static enum DropOldTable implements Callable<Boolean>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try (Sql sql = null;){
                sql = Databases.getBootstrapper().getConnection("eucalyptus_config");
                sql.execute("drop table if exists config_unique_ids");
                Boolean bl = true;
                return bl;
            }
        }
    }

    @Entity
    @PersistenceContext(name="eucalyptus_config")
    @Table(name="config_unique_ids_sets")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    public static class PersistedCounter
    extends AbstractPersistent {
        @Transient
        private static final long serialVersionUID = 1L;
        @Column(name="config_unique_ids_current_base")
        private Long currentBase;
        @Column(name="config_unique_ids_set_name", unique=true)
        private String idSetName;

        private PersistedCounter() {
        }

        private PersistedCounter(Long counter, String counterName) {
            this.currentBase = counter;
            this.idSetName = counterName;
        }

        private Long nextBlock(Long size) {
            Long oldBase = this.getCurrentBase() + 1L;
            this.setCurrentBase(oldBase + size);
            return oldBase;
        }

        private Long getCurrentBase() {
            return this.currentBase;
        }

        private void setCurrentBase(Long currentBase) {
            this.currentBase = currentBase;
        }

        private String getIdSetName() {
            return this.idSetName;
        }

        private void setIdSetName(String idSetName) {
            this.idSetName = idSetName;
        }

        static enum Transaction implements Function<Long, String>
        {
            NEXT_INDEX{

                public String apply(Long arg0) {
                    return Crypto.getDigestBase64(Long.toString(arg0), Digest.SHA512).replaceAll("\\.", "");
                }
            };

        }
    }
}

