/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.records.EventRecord;
import com.eucalyptus.records.EventType;
import com.eucalyptus.system.Ats;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TypeMappers {
    private static Logger LOG = Logger.getLogger(TypeMappers.class);
    private static SortedSetMultimap<Class, Class> knownMappers = TreeMultimap.create((Comparator)CompareClasses.INSTANCE, (Comparator)CompareClasses.INSTANCE);
    private static Map<String, Function> mappers = Maps.newHashMap();

    public static <A, B> B transform(A from, Class<B> to) {
        Class target = from.getClass();
        for (Class p : Classes.ancestors(from)) {
            if (!knownMappers.containsKey((Object)p) || !knownMappers.get((Object)p).contains(to)) continue;
            target = p;
            break;
        }
        Function<?, B> func = TypeMappers.lookup(target, to);
        return (B)func.apply(from);
    }

    public static <A, B> Function<A, B> lookup(Class<A> a, Class<B> b) {
        Parameters.checkParam(knownMappers.keySet(), Matchers.hasItem(a));
        Parameters.checkParam(knownMappers.get(a), Matchers.hasItem(b));
        String key = Joiner.on((String)"=>").join(a, b, new Object[0]);
        return mappers.get(key);
    }

    private static void registerMapper(Class from, Class to, Function mapper) {
        EventRecord.here(TypeMapperDiscovery.class, EventType.BOOTSTRAP_INIT_DISCOVERY, "mapper", from.getCanonicalName(), to.getCanonicalName(), mapper.getClass().getCanonicalName()).info();
        String key = Joiner.on((String)"=>").join((Object)from, (Object)to, new Object[0]);
        Parameters.checkParam(knownMappers.get((Object)from), Matchers.not((Matcher)Matchers.hasItem((Object)to)));
        Parameters.checkParam(mappers, Matchers.not((Matcher)Matchers.hasKey((Object)key)));
        knownMappers.put((Object)from, (Object)to);
        mappers.put(key, mapper);
    }

    public static class TypeMapperDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (Ats.from(candidate).has(TypeMapper.class) && Function.class.isAssignableFrom(candidate)) {
                TypeMapper mapper = Ats.from(candidate).get(TypeMapper.class);
                Class[] types = mapper.value();
                ArrayList generics = Lists.newArrayList();
                try {
                    generics.addAll(Classes.genericsToClasses(Classes.newInstance(candidate, new Object[0])));
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                }
                if (generics.size() != 2) {
                    LOG.error((Object)(candidate + " looks like it is a @TypeMapper but needs generics: " + generics));
                    return false;
                }
                try {
                    TypeMappers.registerMapper((Class)generics.get(0), (Class)generics.get(1), (Function)Classes.newInstance(candidate, new Object[0]));
                    return true;
                }
                catch (Exception ex1) {
                    LOG.error((Object)("Error registering type mapper: " + candidate), (Throwable)ex1);
                }
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.3;
        }
    }

    private static enum CompareClasses implements Comparator<Class>
    {
        INSTANCE;


        @Override
        public int compare(Class o1, Class o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 != null && o2 != null) {
                return ("" + o1.toString()).compareTo("" + o2.toString());
            }
            return o1 != null ? 1 : -1;
        }
    }
}

