/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class Timers {
    private static Logger LOG = Logger.getLogger(Timers.class);

    public static <T> Callable<T> loggingWrapper(final Runnable run, final T returnValue) {
        return Timers.loggingWrapper(new Callable<T>(){

            @Override
            public T call() throws Exception {
                run.run();
                return returnValue;
            }
        });
    }

    public static <T> Callable<T> loggingWrapper(final Callable<T> call) {
        return new Callable<T>(){

            @Override
            public T call() throws Exception {
                long start = System.currentTimeMillis();
                Object res = call.call();
                LOG.debug((Object)(call.toString() + ": completed in " + (System.currentTimeMillis() - start) + " msec."));
                return res;
            }
        };
    }
}

