/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.ws.StackConfiguration;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class TimedEvictionSet<E extends Comparable>
implements Set<E> {
    private static Logger LOG = Logger.getLogger(TimedEvictionSet.class);
    private NavigableSet<E> entries = new ConcurrentSkipListSet();
    private NavigableSet<TimestampedElement> timestamps = new ConcurrentSkipListSet<TimestampedElement>();
    private Long evictionNanos = 900000000000L;
    private AtomicBoolean busy = new AtomicBoolean(false);

    private boolean timestamp(E e) {
        this.scavenge();
        if (this.entries.add(e)) {
            TimestampedElement elem = new TimestampedElement(this, e);
            this.timestamps.add(elem);
            return true;
        }
        LOG.debug((Object)("Use of the same signature is detected: " + e));
        Long now = System.nanoTime();
        Long adjust = TimeUnit.NANOSECONDS.convert(StackConfiguration.REPLAY_SKEW_WINDOW_SEC.intValue(), TimeUnit.SECONDS);
        if (adjust <= 0L) {
            return false;
        }
        Long timeNanosAdj = now - adjust;
        TimestampedElement fakeElem = new TimestampedElement(this, e, timeNanosAdj);
        NavigableSet<TimestampedElement> elems = this.timestamps.tailSet(fakeElem, true);
        for (TimestampedElement elem : elems) {
            Object sig = elem.get();
            if (!e.equals(sig)) continue;
            LOG.debug((Object)("Found elem with signature " + sig + " within allowed " + StackConfiguration.REPLAY_SKEW_WINDOW_SEC + " sec window "));
            return true;
        }
        return false;
    }

    public TimedEvictionSet(Long evictionMillis) {
        this.evictionNanos = evictionMillis * 1000L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        if (this.busy.compareAndSet(false, true)) {
            try {
                TimestampedElement elem = null;
                while (!this.timestamps.isEmpty() && ((TimestampedElement)this.timestamps.first()).isExpired() && (elem = this.timestamps.pollFirst()) != null) {
                    this.entries.remove(elem.get());
                }
            }
            finally {
                this.busy.lazySet(false);
            }
        }
    }

    public Long getEvictionNanos() {
        return this.evictionNanos;
    }

    @Override
    public boolean add(E e) {
        Long skew = TimeUnit.NANOSECONDS.convert(StackConfiguration.REPLAY_SKEW_WINDOW_SEC.intValue(), TimeUnit.SECONDS);
        if (skew >= this.evictionNanos) {
            return true;
        }
        return this.timestamp(e);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends E> c) {
        return false;
    }

    @Override
    public void clear() {
        this.timestamps.clear();
        this.entries.clear();
        this.busy.set(false);
    }

    public Comparator<? super E> comparator() {
        return this.entries.comparator();
    }

    @Override
    public boolean contains(Object o) {
        this.scavenge();
        return this.entries.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entries.containsAll(c);
    }

    public E first() {
        return (E)((Comparable)this.entries.first());
    }

    public SortedSet<E> headSet(E toElement) {
        return this.entries.headSet(toElement);
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.iterator();
    }

    public E last() {
        return (E)((Comparable)this.entries.last());
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        return false;
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.entries.subSet(fromElement, toElement);
    }

    public SortedSet<E> tailSet(E fromElement) {
        return this.entries.tailSet(fromElement);
    }

    @Override
    public Object[] toArray() {
        return this.entries.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entries.toArray(a);
    }

    static class TimestampedElement
    implements Comparable<TimestampedElement> {
        private E element;
        private Long timeNanos;
        final /* synthetic */ TimedEvictionSet this$0;

        public TimestampedElement(E element) {
            this.this$0 = var1_1;
            this.element = element;
            this.timeNanos = System.nanoTime();
        }

        protected TimestampedElement(E element, Long nanos) {
            this.this$0 = var1_1;
            this.element = element;
            this.timeNanos = nanos;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
            result = 31 * result + (this.timeNanos == null ? 0 : this.timeNanos.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimestampedElement other = (TimestampedElement)obj;
            if (this.element == null ? other.element != null : !this.element.equals(other.element)) {
                return false;
            }
            return !(this.timeNanos == null ? other.timeNanos != null : !this.timeNanos.equals(other.timeNanos));
        }

        @Override
        public int compareTo(TimestampedElement that) {
            if (!this.equals(that) && this.timeNanos.compareTo(that.timeNanos) == 0) {
                return this.element.compareTo(that.element);
            }
            return this.timeNanos.compareTo(that.timeNanos);
        }

        public boolean isExpired() {
            return System.nanoTime() > this.timeNanos + this.this$0.evictionNanos;
        }

        public E get() {
            return this.element;
        }

        public Long getTimestamp() {
            return this.timeNanos;
        }
    }
}

