/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.BootstrapArgs;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.Topology;
import com.eucalyptus.util.async.AsyncRequests;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SynchronousClient<MT extends BaseMessage, CT extends ComponentId> {
    @Nullable
    protected final String userId;
    private final Class<CT> componentIdClass;
    protected ServiceConfiguration configuration;

    public SynchronousClient(@Nullable String userId, @Nonnull Class<CT> componentIdClass) {
        this.userId = userId;
        this.componentIdClass = componentIdClass;
    }

    public SynchronousClient(@Nonnull Class<CT> componentIdClass) {
        this(null, componentIdClass);
    }

    public void init() throws SynchronousClientException {
        try {
            CT componentId = ComponentIds.lookup(this.componentIdClass);
            this.configuration = ((ComponentId)componentId).isAlwaysLocal().booleanValue() || BootstrapArgs.isCloudController().booleanValue() && ((ComponentId)componentId).isCloudLocal().booleanValue() && !((ComponentId)componentId).isRegisterable() ? ServiceConfigurations.createEphemeral(componentId) : Topology.lookup(this.componentIdClass, new Partition[0]);
        }
        catch (NoSuchElementException e) {
            throw new SynchronousClientException(e);
        }
    }

    public <REQ extends MT, RES extends MT> RES sendSync(REQ request) throws Exception {
        ((BaseMessage)request).setEffectiveUserId(this.userId);
        return (RES)AsyncRequests.sendSync(this.configuration, request);
    }

    public static final class SynchronousClientException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public SynchronousClientException(String message) {
            super(message);
        }

        public SynchronousClientException(String message, Throwable cause) {
            super(message, cause);
        }

        public SynchronousClientException(Throwable cause) {
            super(cause);
        }
    }
}

