/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.system.Ats;
import com.google.common.base.Predicate;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.net.InetAddresses;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class Subnets
extends ServiceJarDiscovery {
    private static Logger LOG = Logger.getLogger(Subnets.class);
    private static final ClassToInstanceMap<Predicate<InetAddress>> subnetCheckers = MutableClassToInstanceMap.create();

    public static boolean isSystemManagedAddress(InetAddress addr) {
        for (Predicate p : subnetCheckers.values()) {
            try {
                if (!p.apply((Object)addr)) continue;
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
        }
        return false;
    }

    public static boolean isSystemHostAddress(final InetAddress addr) {
        Predicate<Host> filter = new Predicate<Host>(){

            public boolean apply(Host arg0) {
                return arg0.getHostAddresses().contains((Object)addr);
            }
        };
        return !Hosts.list(filter).isEmpty();
    }

    public static Predicate<InetAddress> internalPredicate(String subnet, String netmask) throws UnknownHostException {
        return Subnets.create(subnet, netmask).getPredicate();
    }

    public static Subnet create(String subnet, String netmask) throws UnknownHostException {
        return new Subnet(InetAddress.getByName(subnet), InetAddress.getByName(netmask));
    }

    @Override
    public boolean processClass(Class candidate) throws Exception {
        if (Ats.from(candidate).has(SystemSubnetPredicate.class) && Predicate.class.isAssignableFrom(candidate) && !Modifier.isAbstract(candidate.getModifiers())) {
            try {
                Predicate resolver = (Predicate)candidate.newInstance();
                subnetCheckers.putInstance(candidate, (Object)resolver);
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to create instance of SystemSubnetPredicate: " + candidate + " because of: " + ex.getMessage()));
            }
        }
        return false;
    }

    @Override
    public Double getPriority() {
        return 0.5;
    }

    private static class Subnet {
        private final InetAddress subnet;
        private final int networkId;
        private final int subnetMask;
        private final int prefix;
        private final Predicate<InetAddress> predicate = new Predicate<InetAddress>(){

            public boolean apply(InetAddress arg0) {
                return Subnet.this.inSubnet(arg0);
            }
        };

        Subnet(InetAddress address, InetAddress netmask) {
            this.subnetMask = InetAddresses.coerceToInteger((InetAddress)netmask);
            this.networkId = InetAddresses.coerceToInteger((InetAddress)address) & this.subnetMask;
            this.subnet = InetAddresses.fromInteger((int)this.networkId);
            this.prefix = (int)Math.round(Math.log(Integer.lowestOneBit(this.subnetMask)) / Math.log(2.0));
        }

        Subnet(InetAddress subnet, int prefix) throws UnknownHostException {
            this(subnet, InetAddresses.fromInteger((int)(-1 << 32 - prefix)));
        }

        public boolean inSubnet(InetAddress address) {
            return (InetAddresses.coerceToInteger((InetAddress)address) & this.subnetMask) == this.networkId;
        }

        public String toString() {
            return this.subnet.getHostAddress() + "/" + this.prefix;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Subnet)) {
                return false;
            }
            return ((Subnet)obj).networkId == this.networkId;
        }

        public InetAddress getSubnet() {
            return this.subnet;
        }

        public InetAddress getNetworkId() {
            return InetAddresses.fromInteger((int)this.networkId);
        }

        public int getSubnetMask() {
            return this.subnetMask;
        }

        public int getPrefix() {
            return this.prefix;
        }

        public Predicate<InetAddress> getPredicate() {
            return this.predicate;
        }
    }

    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SystemSubnetPredicate {
    }
}

