/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Strings {
    public static String toString(@Nullable Object object) {
        return Objects.toString(object, null);
    }

    public static String trimPrefix(@Nonnull String prefix, @Nullable String text) {
        if (text != null && text.startsWith(prefix)) {
            return text.substring(prefix.length());
        }
        return text;
    }

    public static String trimSuffix(@Nonnull String suffix, @Nullable String text) {
        if (text != null && text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static Function<String, String> trim() {
        return StringFunctions.TRIM;
    }

    public static Function<String, String> upper() {
        return StringFunctions.UPPER;
    }

    public static Function<String, String> lower() {
        return StringFunctions.LOWER;
    }

    public static Predicate<String> startsWith(final String prefix) {
        return new Predicate<String>(){

            public boolean apply(@Nullable String text) {
                return text != null && text.startsWith(prefix);
            }
        };
    }

    public static Predicate<String> isPrefixOf(final String text) {
        return text == null ? Predicates.alwaysFalse() : new Predicate<String>(){

            public boolean apply(@Nullable String prefix) {
                return prefix != null && text.startsWith(prefix);
            }
        };
    }

    public static Predicate<String> endsWith(final String suffix) {
        return new Predicate<String>(){

            public boolean apply(@Nullable String text) {
                return text != null && text.endsWith(suffix);
            }
        };
    }

    public static Predicate<String> isSuffixOf(final String text) {
        return text == null ? Predicates.alwaysFalse() : new Predicate<String>(){

            public boolean apply(@Nullable String prefix) {
                return prefix != null && text.endsWith(prefix);
            }
        };
    }

    public static Function<String, String> append(final String suffix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String text) {
                return text == null ? suffix : text + suffix;
            }
        };
    }

    public static Function<String, String> prepend(final String prefix) {
        return new Function<String, String>(){

            @Nullable
            public String apply(@Nullable String text) {
                return text == null ? prefix : prefix + text;
            }
        };
    }

    public static Function<String, Function<String, String>> join() {
        return new Function<String, Function<String, String>>(){

            @Nullable
            public Function<String, String> apply(@Nullable String prefix) {
                return Strings.prepend(prefix);
            }
        };
    }

    public static Function<Object, String> toStringFunction() {
        return StringerFunctions.TOSTRING;
    }

    private static enum StringerFunctions implements Function<Object, String>
    {
        TOSTRING{

            public String apply(Object object) {
                return Strings.toString(object);
            }
        };

    }

    private static enum StringFunctions implements Function<String, String>
    {
        LOWER{

            public String apply(String text) {
                return text == null ? null : text.toLowerCase();
            }
        }
        ,
        UPPER{

            public String apply(String text) {
                return text == null ? null : text.toUpperCase();
            }
        }
        ,
        TRIM{

            public String apply(String text) {
                return text == null ? null : text.trim();
            }
        };

    }
}

