/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthContextSupplier;
import com.eucalyptus.auth.AuthEvaluationContext;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthQuotaException;
import com.eucalyptus.auth.Permissions;
import com.eucalyptus.auth.PolicyResourceContext;
import com.eucalyptus.auth.policy.PolicyAction;
import com.eucalyptus.auth.policy.PolicyResourceType;
import com.eucalyptus.auth.policy.PolicySpec;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Policy;
import com.eucalyptus.auth.principal.Principal;
import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.bootstrap.ServiceJarDiscovery;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.annotation.ComponentMessage;
import com.eucalyptus.component.annotation.PolicyVendor;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.Ats;
import com.eucalyptus.system.Threads;
import com.eucalyptus.util.Classes;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedType;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.hamcrest.Matchers;

public class RestrictedTypes {
    static Logger LOG = Logger.getLogger(RestrictedTypes.class);
    private static final Interner<AllocationScope> allocationInterner = Interners.newWeakInterner();
    private static final Map<Class, Function<?, ?>> resourceResolvers = Maps.newHashMap();
    private static final Map<Class, Function<?, ?>> usageMetricFunctions = Maps.newHashMap();
    private static final Map<Class, Function<?, ?>> quantityMetricFunctions = Maps.newHashMap();

    public static <T extends RestrictedType> Function<String, T> resolver(Class<T> type) {
        return RestrictedTypes.checkMapByType(type, resourceResolvers);
    }

    public static Function<OwnerFullName, Long> usageMetricFunction(Class type) {
        return RestrictedTypes.checkMapByType(type, usageMetricFunctions);
    }

    public static Function<OwnerFullName, Long> quantityMetricFunction(Class type) {
        return RestrictedTypes.checkMapByType(type, quantityMetricFunctions);
    }

    private static Function<?, ?> checkMapByType(Class type, Map<Class, Function<?, ?>> map) {
        for (Class subType : Classes.ancestors(type)) {
            if (!map.containsKey(subType)) continue;
            return map.get(subType);
        }
        throw new NoSuchElementException("Failed to lookup function (@" + Threads.currentStackFrame(1).getMethodName() + ") for type: " + type);
    }

    private static <T> List<T> runAllocator(int quantity, Supplier<T> allocator, Predicate<T> rollback) {
        ArrayList res = Lists.newArrayList();
        try {
            for (int i = 0; i < quantity; ++i) {
                Object rsc = allocator.get();
                if (rsc == null) {
                    throw new NoSuchElementException("Attempt to allocate " + quantity + " resources failed.");
                }
                res.add(rsc);
            }
        }
        catch (Exception ex) {
            for (Object rsc : res) {
                try {
                    rollback.apply(rsc);
                }
                catch (Exception ex1) {
                    LOG.trace((Object)ex1, (Throwable)ex1);
                }
            }
            if (ex.getCause() != null) {
                throw Exceptions.toUndeclared(ex.getCause());
            }
            throw Exceptions.toUndeclared(ex);
        }
        return res;
    }

    public static <T extends RestrictedType> T allocateUnitlessResource(Supplier<T> allocator) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return (T)((RestrictedType)RestrictedTypes.allocateUnitlessResources(1, allocator).get(0));
    }

    public static <T extends RestrictedType> List<T> allocateUnitlessResources(Integer quantity, Supplier<T> allocator) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return RestrictedTypes.allocateUnitlessResources(RestrictedTypes.findResourceClass(allocator), quantity, allocator);
    }

    public static <T extends RestrictedType> List<T> allocateUnitlessResources(Class<?> rscType, final Integer quantity, final Supplier<T> allocator) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return (List)RestrictedTypes.doAllocate(rscType, quantity, new Supplier<List<T>>(){

            public List<T> get() {
                return RestrictedTypes.runAllocator(quantity, allocator, Predicates.alwaysTrue());
            }
        });
    }

    public static <T extends RestrictedType> List<T> allocateUnitlessResources(Class<?> rscType, final int min, final int max, final BatchAllocator<T> allocator) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return (List)RestrictedTypes.doAllocate(rscType, max, new Supplier<List<T>>(){

            public List<T> get() {
                return allocator.allocate(min, max);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <A> A doAllocate(Class<?> rscType, Integer quantity, Supplier<A> allocator) throws AuthException, IllegalContextAccessException {
        String identifier = "";
        Context ctx = Contexts.lookup();
        if (!ctx.hasAdministrativePrivileges()) {
            Class<?> msgType = ctx.getRequest().getClass();
            Ats ats = RestrictedTypes.findPolicyAnnotations(rscType, msgType);
            PolicyVendor vendor = ats.get(PolicyVendor.class);
            PolicyResourceType type = ats.get(PolicyResourceType.class);
            String action = RestrictedTypes.getIamActionByMessageType();
            AuthContextSupplier userContext = ctx.getAuthContext();
            if (!Permissions.isAuthorized(vendor.value(), type.value(), identifier, null, action, userContext)) {
                throw new AuthException("Not authorized to create: " + type.value() + " by user: " + ctx.getUserFullName());
            }
            Lock lock = ((AllocationScope)allocationInterner.intern((Object)new AllocationScope(vendor.value(), type.value(), userContext.get().getAccountNumber()))).lock();
            lock.lock();
            try {
                if (!Permissions.canAllocate(vendor.value(), type.value(), identifier, action, ctx.getUser(), (Long)((Object)quantity))) {
                    throw new AuthQuotaException(type.value(), "Quota exceeded while trying to create: " + type.value() + " by user: " + ctx.getUserFullName());
                }
                Object object = allocator.get();
                return (A)object;
            }
            finally {
                lock.unlock();
            }
        }
        return (A)allocator.get();
    }

    public static <T extends RestrictedType> List<T> allocateNamedUnitlessResources(Integer quantity, Supplier<T> allocator, Predicate<T> rollback) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        Context ctx = Contexts.lookup();
        Class<?> rscType = RestrictedTypes.findResourceClass(allocator);
        if (ctx.hasAdministrativePrivileges()) {
            return RestrictedTypes.runAllocator(quantity, allocator, rollback);
        }
        Class<?> msgType = ctx.getRequest().getClass();
        Ats ats = RestrictedTypes.findPolicyAnnotations(rscType, msgType);
        PolicyVendor vendor = ats.get(PolicyVendor.class);
        PolicyResourceType type = ats.get(PolicyResourceType.class);
        String action = RestrictedTypes.getIamActionByMessageType();
        AuthContextSupplier userContext = ctx.getAuthContext();
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < quantity; ++i) {
            RestrictedType rsc = null;
            try {
                rsc = (RestrictedType)allocator.get();
            }
            catch (RuntimeException ex1) {
                if (rsc != null) {
                    rollback.apply((Object)rsc);
                }
                throw ex1;
            }
            if (rsc == null) {
                throw new NoSuchElementException("Attempt to allocate " + quantity + " " + type + " failed.");
            }
            try {
                String identifier = rsc.getDisplayName();
                if (!Permissions.isAuthorized(vendor.value(), type.value(), identifier, null, action, userContext)) {
                    throw new AuthException("Not authorized to create: " + type.value() + " by user: " + ctx.getUserFullName());
                }
                if (!Permissions.canAllocate(vendor.value(), type.value(), identifier, action, ctx.getUser(), (Long)((Object)quantity))) {
                    throw new AuthQuotaException(type.value(), "Quota exceeded while trying to create: " + type.value() + " by user: " + ctx.getUserFullName());
                }
            }
            catch (AuthException ex) {
                if (rsc != null) {
                    rollback.apply((Object)rsc);
                }
                throw ex;
            }
            res.add(rsc);
        }
        return res;
    }

    public static <T extends RestrictedType> T allocateMeasurableResource(Long amount, Function<Long, T> allocator) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        String identifier = "";
        Context ctx = Contexts.lookup();
        if (!ctx.hasAdministrativePrivileges()) {
            Class<?> msgType = ctx.getRequest().getClass();
            Class<?> rscType = RestrictedTypes.findResourceClass(allocator);
            Ats ats = RestrictedTypes.findPolicyAnnotations(rscType, msgType);
            PolicyVendor vendor = ats.get(PolicyVendor.class);
            PolicyResourceType type = ats.get(PolicyResourceType.class);
            String action = RestrictedTypes.getIamActionByMessageType();
            AuthContextSupplier userContext = ctx.getAuthContext();
            if (!Permissions.isAuthorized(vendor.value(), type.value(), identifier, null, action, userContext)) {
                throw new AuthException("Not authorized to create: " + type.value() + " by user: " + ctx.getUserFullName());
            }
            if (!Permissions.canAllocate(vendor.value(), type.value(), identifier, action, ctx.getUser(), amount)) {
                throw new AuthQuotaException(type.value(), "Quota exceeded while trying to create: " + type.value() + " by user: " + ctx.getUserFullName());
            }
        }
        return (T)((RestrictedType)allocator.apply((Object)amount));
    }

    public static <T extends RestrictedType> T doPrivileged(String identifier, Class<T> type) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return (T)RestrictedTypes.doPrivileged(identifier, RestrictedTypes.checkMapByType(type, resourceResolvers));
    }

    public static <T extends RestrictedType> T doPrivileged(String identifier, Function<String, T> resolverFunction) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return RestrictedTypes.doPrivileged(identifier, resolverFunction, false);
    }

    public static <T extends RestrictedType> T doPrivilegedWithoutOwner(String identifier, Function<? super String, T> resolverFunction) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        return RestrictedTypes.doPrivileged(identifier, resolverFunction, true);
    }

    private static <T extends RestrictedType> T doPrivileged(String identifier, Function<? super String, T> resolverFunction, boolean ignoreOwningAccount) throws AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        String principalName;
        Principal.PrincipalType principalType;
        RestrictedType requestedObject;
        Parameters.checkParam("Resolver function must be not null: " + identifier, resolverFunction, Matchers.notNullValue());
        Context ctx = Contexts.lookup();
        if (ctx.hasAdministrativePrivileges()) {
            return (T)((RestrictedType)resolverFunction.apply((Object)identifier));
        }
        Class<?> msgType = ctx.getRequest().getClass();
        LOG.debug((Object)("Attempting to lookup " + identifier + " using lookup: " + resolverFunction.getClass() + " typed as " + Classes.genericsToClasses(resolverFunction)));
        Class<?> rscType = RestrictedTypes.findResourceClass(resolverFunction);
        Ats ats = RestrictedTypes.findPolicyAnnotations(rscType, msgType);
        PolicyVendor vendor = ats.get(PolicyVendor.class);
        PolicyResourceType type = ats.get(PolicyResourceType.class);
        String action = RestrictedTypes.getIamActionByMessageType();
        String actionVendor = RestrictedTypes.findPolicyVendor(msgType);
        User requestUser = ctx.getUser();
        Map<String, String> evaluatedKeys = ctx.evaluateKeys();
        try {
            requestedObject = (RestrictedType)resolverFunction.apply((Object)identifier);
            if (requestedObject == null) {
                throw new NoSuchElementException("Failed to lookup requested " + rscType.getCanonicalName() + " with id " + identifier + " using " + resolverFunction.getClass());
            }
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (PersistenceException ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            LOG.error((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            Logs.extreme().error((Object)ex, (Throwable)ex);
            LOG.error((Object)ex);
            throw new PersistenceException("Error occurred while attempting to lookup " + identifier + " using lookup: " + resolverFunction.getClass() + " typed as " + rscType, (Throwable)ex);
        }
        if (Principals.isSameUser(requestUser, Principals.systemUser())) {
            principalType = Principal.PrincipalType.Service;
            principalName = "ec2.amazon.com";
        } else {
            principalType = Principal.PrincipalType.AWS;
            principalName = Accounts.getUserArn(requestUser);
        }
        Account owningAccount = null;
        if (!ignoreOwningAccount) {
            owningAccount = Principals.nobodyFullName().getAccountNumber().equals(requestedObject.getOwner().getAccountNumber()) ? null : Accounts.lookupAccountById(requestedObject.getOwner().getAccountNumber());
        }
        String qualifiedAction = PolicySpec.qualifiedName(actionVendor, action);
        try (PolicyResourceContext policyResourceContext = PolicyResourceContext.of(requestedObject, qualifiedAction);){
            if (!Permissions.isAuthorized(principalType, principalName, RestrictedTypes.findPolicy(requestedObject, actionVendor, action), PolicySpec.qualifiedName(vendor.value(), type.value()), identifier, owningAccount, qualifiedAction, requestUser, evaluatedKeys)) {
                throw new AuthException("Not authorized to use " + type.value() + " identified by " + identifier + " as the user " + UserFullName.getInstance(requestUser, new String[0]));
            }
        }
        return (T)requestedObject;
    }

    public static <T extends RestrictedType> Predicate<T> filterPrivileged() {
        return RestrictedTypes.filterPrivileged(false, ContextSupplier.INSTANCE);
    }

    public static <T extends RestrictedType> Predicate<T> filterPrivilegedWithoutOwner() {
        return RestrictedTypes.filterPrivileged(true, ContextSupplier.INSTANCE);
    }

    public static <T extends RestrictedType> Function<T, String> toDisplayName() {
        return new Function<T, String>(){

            public String apply(T arg0) {
                return arg0 == null ? null : arg0.getDisplayName();
            }
        };
    }

    public static <T extends RestrictedType> Predicate<T> filterById(Collection<String> requestedIdentifiers) {
        return RestrictedTypes.filterByProperty(requestedIdentifiers, RestrictedTypes.toDisplayName());
    }

    public static <T extends RestrictedType> Predicate<T> filterByProperty(String requestedValue, Function<? super T, String> extractor) {
        return RestrictedTypes.filterByProperty((Collection)CollectionUtils.listUnit().apply((Object)requestedValue), extractor);
    }

    public static <T extends RestrictedType> Predicate<T> filterByProperty(final Collection<String> requestedValues, final Function<? super T, String> extractor) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return requestedValues == null || requestedValues.isEmpty() || requestedValues.contains(extractor.apply(input));
            }
        };
    }

    public static <T extends RestrictedType> Predicate<T> filterByOwningAccount(final Collection<String> requestedIdentifiers) {
        return new Predicate<T>(){

            public boolean apply(T input) {
                return requestedIdentifiers == null || requestedIdentifiers.isEmpty() || requestedIdentifiers.contains(input.getOwner().getAccountNumber());
            }
        };
    }

    public static <T extends RestrictedType> FilterBuilder<T> filteringFor(Class<T> metadataClass) {
        return new FilterBuilder(metadataClass);
    }

    private static <T extends RestrictedType> Predicate<T> filterPrivileged(final boolean ignoreOwningAccount, final Function<? super Class<?>, AuthEvaluationContext> contextFunction) {
        return new Predicate<T>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean apply(T arg0) {
                Context ctx = Contexts.lookup();
                if (ctx.hasAdministrativePrivileges()) return true;
                try {
                    String owningAccountNumber = null;
                    if (!ignoreOwningAccount) {
                        owningAccountNumber = Principals.nobodyFullName().getAccountNumber().equals(arg0.getOwner().getAccountNumber()) ? null : arg0.getOwner().getAccountNumber();
                    }
                    AuthEvaluationContext evaluationContext = (AuthEvaluationContext)contextFunction.apply(arg0.getClass());
                    try (PolicyResourceContext policyResourceContext = PolicyResourceContext.of(arg0, evaluationContext.getAction());){
                        boolean bl = Permissions.isAuthorized(evaluationContext, owningAccountNumber, arg0.getDisplayName());
                        return bl;
                    }
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };
    }

    @Nonnull
    public static Predicate<RestrictedType.AccountRestrictedType> filterByOwner(@Nullable OwnerFullName owner) {
        return owner == null ? Predicates.alwaysTrue() : Predicates.and(RestrictedTypes.filterByAccount(owner.getAccountNumber()), RestrictedTypes.typeSafeFilterByUser(owner.getUserId()));
    }

    @Nonnull
    public static Predicate<RestrictedType.AccountRestrictedType> filterByAccount(final @Nonnull String accountNumber) {
        return new Predicate<RestrictedType.AccountRestrictedType>(){

            public boolean apply(@Nullable RestrictedType.AccountRestrictedType restricted) {
                return restricted == null || accountNumber.equals(restricted.getOwnerAccountNumber());
            }
        };
    }

    @Nonnull
    public static Predicate<RestrictedType.UserRestrictedType> filterByUser(final @Nonnull String userId) {
        return new Predicate<RestrictedType.UserRestrictedType>(){

            public boolean apply(@Nullable RestrictedType.UserRestrictedType restricted) {
                return restricted == null || userId.equals(restricted.getOwnerUserId());
            }
        };
    }

    @Nonnull
    private static Predicate<RestrictedType.AccountRestrictedType> typeSafeFilterByUser(@Nullable String userId) {
        final Predicate<RestrictedType.UserRestrictedType> userFilter = userId == null ? Predicates.alwaysTrue() : RestrictedTypes.filterByUser(userId);
        return new Predicate<RestrictedType.AccountRestrictedType>(){

            public boolean apply(@Nullable RestrictedType.AccountRestrictedType restricted) {
                return !(restricted instanceof RestrictedType.UserRestrictedType) || userFilter.apply((Object)((RestrictedType.UserRestrictedType)((Object)restricted)));
            }
        };
    }

    public static String getIamActionByMessageType() {
        return RestrictedTypes.getIamActionByMessageType(Contexts.lookup().getRequest());
    }

    public static String getIamActionByMessageType(BaseMessage request) {
        String action = PolicySpec.requestToAction(request);
        if (action == null) {
            if (request != null) {
                return request.getClass().getSimpleName().replaceAll("(ResponseType|Type)$", "").toLowerCase();
            }
            return null;
        }
        return action;
    }

    private static Class<?> findResourceClass(Object allocator) throws IllegalArgumentException, NoSuchElementException {
        Class rscType;
        List<Class> lookupTypes = Classes.genericsToClasses(allocator);
        if (lookupTypes.isEmpty()) {
            throw new IllegalArgumentException("Failed to find required generic type for lookup " + allocator.getClass() + " so the policy type for looking up " + allocator + " cannot be determined.");
        }
        try {
            rscType = (Class)Iterables.find(lookupTypes, (Predicate)new Predicate<Class>(){

                public boolean apply(Class arg0) {
                    return RestrictedType.class.isAssignableFrom(arg0);
                }
            });
        }
        catch (NoSuchElementException ex1) {
            LOG.error((Object)ex1, (Throwable)ex1);
            throw ex1;
        }
        return rscType;
    }

    private static Ats findPolicyAnnotations(Class<?> rscType, Class<? extends BaseMessage> msgType) throws IllegalArgumentException {
        Ats ats = Ats.inClassHierarchy(rscType);
        Ats msgAts = Ats.inClassHierarchy(msgType);
        if (!ats.has(PolicyVendor.class) && !msgAts.has(PolicyVendor.class)) {
            throw new IllegalArgumentException("Failed to determine policy for allocating type instance " + rscType.getCanonicalName() + ": required @PolicyVendor missing in resource type hierarchy " + rscType.getCanonicalName() + " and request type hierarchy " + msgType.getCanonicalName());
        }
        if (!ats.has(PolicyResourceType.class) && !msgAts.has(PolicyResourceType.class)) {
            throw new IllegalArgumentException("Failed to determine policy for looking up type instance " + rscType.getCanonicalName() + ": required @PolicyResourceType missing in resource type hierarchy " + rscType.getCanonicalName() + " and request type hierarchy " + msgType.getCanonicalName());
        }
        return ats;
    }

    public static String findPolicyVendor(Class<? extends BaseMessage> msgType) throws IllegalArgumentException {
        Class<? extends ComponentId> componentIdClass;
        Ats componentAts;
        Ats ats = Ats.inClassHierarchy(msgType);
        if (ats.has(PolicyVendor.class)) {
            return ats.get(PolicyVendor.class).value();
        }
        if (ats.has(PolicyAction.class)) {
            return ats.get(PolicyAction.class).vendor();
        }
        if (ats.has(ComponentMessage.class) && (componentAts = Ats.inClassHierarchy(componentIdClass = ats.get(ComponentMessage.class).value())).has(PolicyVendor.class)) {
            return componentAts.get(PolicyVendor.class).value();
        }
        throw new IllegalArgumentException("Failed to determine policy: require @PolicyVendor, @PolicyAction or @ComponentMessage in request type hierarchy " + msgType.getCanonicalName());
    }

    private static Policy findPolicy(RestrictedType object, String vendor, String action) throws AuthException {
        Ats ats;
        PolicyResourceType policyResourceType;
        Policy policy = null;
        if (object instanceof RestrictedType.PolicyRestrictedType && ((policyResourceType = (ats = Ats.inClassHierarchy(object.getClass())).get(PolicyResourceType.class)) == null || Lists.newArrayList((Object[])policyResourceType.resourcePolicyActions()).contains(PolicySpec.qualifiedName(vendor, action).toLowerCase()))) {
            try {
                policy = ((RestrictedType.PolicyRestrictedType)((Object)object)).getPolicy();
                if (policy == null) {
                    throw new AuthException("Policy not found for resource");
                }
            }
            catch (Exception e) {
                throw new AuthException("Error finding policy", e);
            }
        }
        return policy;
    }

    private static final class AllocationScope {
        private final String resourceVendor;
        private final String resourceType;
        private final String accountNumber;
        private final Lock lock = new ReentrantLock();

        private AllocationScope(String resourceVendor, String resourceType, String accountNumber) {
            Parameters.checkParam("resourceVendor", resourceVendor, Matchers.notNullValue());
            Parameters.checkParam("resourceType", resourceType, Matchers.notNullValue());
            Parameters.checkParam("accountNumber", accountNumber, Matchers.notNullValue());
            this.resourceVendor = resourceVendor;
            this.resourceType = resourceType;
            this.accountNumber = accountNumber;
        }

        public Lock lock() {
            return this.lock;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllocationScope that = (AllocationScope)o;
            if (!this.accountNumber.equals(that.accountNumber)) {
                return false;
            }
            if (!this.resourceType.equals(that.resourceType)) {
                return false;
            }
            return this.resourceVendor.equals(that.resourceVendor);
        }

        public int hashCode() {
            int result = this.resourceVendor.hashCode();
            result = 31 * result + this.resourceType.hashCode();
            result = 31 * result + this.accountNumber.hashCode();
            return result;
        }

        public String getResourceVendor() {
            return this.resourceVendor;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public String getAccountNumber() {
            return this.accountNumber;
        }
    }

    public static class ResourceMetricFunctionDiscovery
    extends ServiceJarDiscovery {
        @Override
        public boolean processClass(Class candidate) throws Exception {
            if (Ats.from(candidate).has(UsageMetricFunction.class) && Function.class.isAssignableFrom(candidate)) {
                UsageMetricFunction measures = Ats.from(candidate).get(UsageMetricFunction.class);
                Class<?> measuredType = measures.value();
                LOG.info((Object)("Registered @UsageMetricFunction:    " + measuredType.getSimpleName() + " => " + candidate));
                usageMetricFunctions.put(measuredType, (Function)Classes.newInstance(candidate, new Object[0]));
                return true;
            }
            if (Ats.from(candidate).has(QuantityMetricFunction.class) && Function.class.isAssignableFrom(candidate)) {
                QuantityMetricFunction measures = Ats.from(candidate).get(QuantityMetricFunction.class);
                Class<?> measuredType = measures.value();
                LOG.info((Object)("Registered @QuantityMetricFunction: " + measuredType.getSimpleName() + " => " + candidate));
                quantityMetricFunctions.put(measuredType, (Function)Classes.newInstance(candidate, new Object[0]));
                return true;
            }
            if (Ats.from(candidate).has(Resolver.class) && Function.class.isAssignableFrom(candidate)) {
                Resolver resolver = Ats.from(candidate).get(Resolver.class);
                Class<?> resolverFunctionType = resolver.value();
                LOG.info((Object)("Registered @Resolver:               " + resolverFunctionType.getSimpleName() + " => " + candidate));
                resourceResolvers.put(resolverFunctionType, (Function)Classes.newInstance(candidate, new Object[0]));
                return true;
            }
            return false;
        }

        @Override
        public Double getPriority() {
            return 0.3;
        }
    }

    public static interface BatchAllocator<T> {
        public List<T> allocate(int var1, int var2);
    }

    public static class FilterBuilder<T extends RestrictedType> {
        private final Class<T> metadataClass;
        private final List<Predicate<? super T>> predicates = Lists.newArrayList();

        private FilterBuilder(Class<T> metadataClass) {
            this.metadataClass = metadataClass;
        }

        public FilterBuilder<T> byId(Collection<String> requestedIdentifiers) {
            this.predicates.add(RestrictedTypes.filterById(requestedIdentifiers));
            return this;
        }

        public <T extends RestrictedType> Predicate<T> filterByProperty(final Collection<String> requestedValues, final Function<? super T, String> extractor) {
            return new Predicate<T>(){

                public boolean apply(T input) {
                    return requestedValues == null || requestedValues.isEmpty() || requestedValues.contains(extractor.apply(input));
                }
            };
        }

        public FilterBuilder<T> byProperty(Collection<String> requestedValues, Function<? super T, String> extractor) {
            this.predicates.add(this.filterByProperty(requestedValues, extractor));
            return this;
        }

        public FilterBuilder<T> byPrivileges() {
            this.predicates.add(RestrictedTypes.filterPrivileged(false, Functions.constant((Object)ContextSupplier.INSTANCE.apply(this.metadataClass))));
            return this;
        }

        public FilterBuilder<T> byPrivilegesWithoutOwner() {
            this.predicates.add(RestrictedTypes.filterPrivileged(true, Functions.constant((Object)ContextSupplier.INSTANCE.apply(this.metadataClass))));
            return this;
        }

        public FilterBuilder<T> byOwningAccount(Collection<String> requestedIdentifiers) {
            this.predicates.add(RestrictedTypes.filterByOwningAccount(requestedIdentifiers));
            return this;
        }

        public FilterBuilder<T> byPredicate(Predicate<? super T> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        public Predicate<? super T> buildPredicate() {
            return Predicates.and(this.predicates);
        }
    }

    @TypeMapper
    public static enum RestrictedTypeToPolicyResourceInfo implements Function<RestrictedType, PolicyResourceContext.PolicyResourceInfo>
    {
        INSTANCE;


        @Nullable
        public PolicyResourceContext.PolicyResourceInfo apply(RestrictedType restrictedType) {
            String accountNumber = restrictedType instanceof RestrictedType.UserRestrictedType ? ((RestrictedType.UserRestrictedType)((Object)restrictedType)).getOwnerAccountNumber() : (restrictedType instanceof RestrictedType.AccountRestrictedType ? ((RestrictedType.AccountRestrictedType)((Object)restrictedType)).getOwnerAccountNumber() : null);
            return PolicyResourceContext.resourceInfo(accountNumber, restrictedType);
        }
    }

    private static enum ContextSupplier implements Function<Class<?>, AuthEvaluationContext>
    {
        INSTANCE;


        public AuthEvaluationContext apply(Class<?> rscType) {
            try {
                Context ctx = Contexts.lookup();
                Class<?> msgType = ctx.getRequest().getClass();
                Ats ats = RestrictedTypes.findPolicyAnnotations(rscType, msgType);
                PolicyVendor vendor = ats.get(PolicyVendor.class);
                PolicyResourceType type = ats.get(PolicyResourceType.class);
                String action = RestrictedTypes.getIamActionByMessageType();
                User requestUser = ctx.getUser();
                Map<String, String> evaluatedKeys = ctx.evaluateKeys();
                return Permissions.createEvaluationContext(vendor.value(), type.value(), action, requestUser, evaluatedKeys);
            }
            catch (AuthException e) {
                throw Exceptions.toUndeclared(e);
            }
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface QuantityMetricFunction {
        public Class<?> value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UsageMetricFunction {
        public Class<?> value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Resolver {
        public Class<?> value();
    }
}

