/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermissions;
import org.apache.log4j.RollingFileAppender;

public class PermissionedRollingFileAppender
extends RollingFileAppender {
    private String permissions;

    public String getPermissions() {
        return this.permissions;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFile(fileName, append, bufferedIO, bufferSize);
        File file = new File(fileName);
        Path path = file.toPath();
        if (this.permissions != null && !this.permissions.isEmpty()) {
            try {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(this.permissions));
            }
            catch (IllegalArgumentException e) {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString("rw-------"));
            }
        }
    }
}

