/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Matchers;

public class Pair<L, R> {
    private final L left;
    private final R right;

    public Pair(@Nonnull L left, @Nonnull R right) {
        this.left = Parameters.checkParam("left", left, Matchers.notNullValue());
        this.right = Parameters.checkParam("right", right, Matchers.notNullValue());
    }

    @Nonnull
    public static <L, R> Function<L, Function<R, Pair<L, R>>> pair() {
        return new Function<L, Function<R, Pair<L, R>>>(){

            public Function<R, Pair<L, R>> apply(final L left) {
                return new Function<R, Pair<L, R>>(){

                    public Pair<L, R> apply(R right) {
                        return Pair.pair(left, right);
                    }
                };
            }
        };
    }

    public static <L, R> Pair<L, R> pair(@Nonnull L left, @Nonnull R right) {
        return new Pair<L, R>(left, right);
    }

    public static <L, R> Pair<Optional<L>, Optional<R>> opair(@Nullable L left, @Nullable R right) {
        return new Pair<Optional<L>, Optional<R>>(Optional.fromNullable(left), Optional.fromNullable(right));
    }

    public static <L, R> Pair<Optional<L>, R> lopair(@Nullable L left, @Nonnull R right) {
        return new Pair<Optional, R>(Optional.fromNullable(left), right);
    }

    public static <L, R> Pair<L, Optional<R>> ropair(@Nonnull L left, @Nullable R right) {
        return new Pair<L, Optional>(left, Optional.fromNullable(right));
    }

    @Nonnull
    public L getLeft() {
        return this.left;
    }

    @Nonnull
    public R getRight() {
        return this.right;
    }

    @Nonnull
    public static <L, R> Function<Pair<L, R>, L> left() {
        return new PairLeftExtractor();
    }

    @Nonnull
    public static <L, R> Function<Pair<L, R>, R> right() {
        return new PairRightExtractor();
    }

    @Nonnull
    public static <T, L, R> NonNullFunction<T, Pair<L, R>> builder(final @Nonnull Function<? super T, L> leftFunction, final @Nonnull Function<? super T, R> rightFunction) {
        return new NonNullFunction<T, Pair<L, R>>(){

            @Override
            @Nonnull
            public Pair<L, R> apply(T value) {
                return Pair.pair(leftFunction.apply(value), rightFunction.apply(value));
            }
        };
    }

    @Nonnull
    public static <T, L, R> NonNullFunction<T, Pair<L, Optional<R>>> robuilder(final @Nonnull Function<? super T, L> leftFunction, final @Nonnull Function<? super T, R> rightFunction) {
        return new NonNullFunction<T, Pair<L, Optional<R>>>(){

            @Override
            @Nonnull
            public Pair<L, Optional<R>> apply(T value) {
                return Pair.pair(leftFunction.apply(value), Optional.fromNullable((Object)rightFunction.apply(value)));
            }
        };
    }

    public static <L, R> NonNullFunction<R, Iterable<Pair<L, R>>> explodeLeft(final Iterable<L> leftValues) {
        return new NonNullFunction<R, Iterable<Pair<L, R>>>(){

            @Override
            @Nonnull
            public Iterable<Pair<L, R>> apply(R rightValue) {
                return Iterables.transform((Iterable)leftValues, CollectionUtils.flipCurried(Pair.pair()).apply(rightValue));
            }
        };
    }

    public static <L, R> NonNullFunction<L, Iterable<Pair<L, R>>> explodeRight(final Iterable<R> rightValues) {
        return new NonNullFunction<L, Iterable<Pair<L, R>>>(){

            @Override
            @Nonnull
            public Iterable<Pair<L, R>> apply(L leftValue) {
                return Iterables.transform((Iterable)rightValues, (Function)((Function)Pair.pair().apply(leftValue)));
            }
        };
    }

    public static <L, R, V> NonNullFunction<Pair<L, R>, V> transformer(final Function<L, Function<R, V>> pairTransform) {
        return new NonNullFunction<Pair<L, R>, V>(){

            @Override
            @Nonnull
            public V apply(Pair<L, R> pair) {
                return ((Function)pairTransform.apply(pair.getLeft())).apply(pair.getRight());
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (!this.left.equals(pair.left)) {
            return false;
        }
        return this.right.equals(pair.right);
    }

    public int hashCode() {
        int result = this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("left", this.left).add("right", this.right).toString();
    }

    private static class PairRightExtractor<L, R>
    implements Function<Pair<L, R>, R> {
        private PairRightExtractor() {
        }

        public R apply(Pair<L, R> pair) {
            return pair.getRight();
        }
    }

    private static class PairLeftExtractor<L, R>
    implements Function<Pair<L, R>, L> {
        private PairLeftExtractor() {
        }

        public L apply(Pair<L, R> pair) {
            return pair.getLeft();
        }
    }
}

