/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.util;

import com.google.common.base.Objects;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class NamespaceMappingXMLStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter delegate;
    private final Map<String, String> namespaceMappings;

    public NamespaceMappingXMLStreamWriter(XMLStreamWriter delegate, Map<String, String> namespaceMappings) {
        this.delegate = delegate;
        this.namespaceMappings = namespaceMappings;
    }

    private String mapNs(String namespaceUri) {
        return (String)Objects.firstNonNull((Object)this.namespaceMappings.get(namespaceUri), (Object)namespaceUri);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.delegate.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeStartElement(this.mapNs(namespaceURI), localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.delegate.writeStartElement(prefix, localName, this.mapNs(namespaceURI));
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(this.mapNs(namespaceURI), localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.delegate.writeEmptyElement(prefix, localName, this.mapNs(namespaceURI));
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.delegate.writeEmptyElement(localName);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.delegate.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.delegate.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.delegate.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.delegate.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(prefix, this.mapNs(namespaceURI), localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.delegate.writeAttribute(this.mapNs(namespaceURI), localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.delegate.writeNamespace(prefix, this.mapNs(namespaceURI));
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.delegate.writeDefaultNamespace(this.mapNs(namespaceURI));
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.delegate.writeComment(data);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.delegate.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.delegate.writeCData(data);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.delegate.writeDTD(dtd);
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.delegate.writeEntityRef(name);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.delegate.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.delegate.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.delegate.writeStartDocument(encoding, version);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.delegate.writeCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.delegate.writeCharacters(text, start, len);
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.delegate.getPrefix(this.mapNs(uri));
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.delegate.setPrefix(prefix, this.mapNs(uri));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.delegate.setDefaultNamespace(this.mapNs(uri));
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.delegate.setNamespaceContext(context);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.delegate.getNamespaceContext();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.delegate.getProperty(name);
    }
}

